/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.util;

import com.alibaba.alink.executor.datasource.DataSourceFactory;
import com.alibaba.alink.operator.stream.StreamOperator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class OpUtil {
    static Map<String, String> OP_NAME_MAPPING = OpUtil.loadOpNameMappingFile();

    private static Map<String, String> loadOpNameMappingFile() {
        InputStream is = OpUtil.class.getResourceAsStream("/function_name_mapping");
        String data = null;
        try {
            data = IOUtils.toString((InputStream)is, (String)"utf-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IOUtils.closeQuietly((InputStream)is);
        JsonObject x = new JsonParser().parse(data).getAsJsonObject();
        HashMap<String, String> ans = new HashMap<String, String>();
        for (Map.Entry p : x.entrySet()) {
            ans.put(((String)p.getKey()).trim(), ((JsonElement)p.getValue()).getAsString());
        }
        return ans;
    }

    public static String transformOpName(String src) {
        if (src.startsWith("com.alibaba.alink")) {
            String newName = OP_NAME_MAPPING.get(src);
            return newName != null ? newName : src;
        }
        return src;
    }

    public static boolean IsStreamOp(String clsName) throws Exception {
        if ((clsName = OpUtil.transformOpName(clsName)).startsWith("com.alibaba.alink.")) {
            Class<?> cls = Class.forName(clsName);
            return StreamOperator.class.isAssignableFrom(cls);
        }
        return DataSourceFactory.isStreamOp(clsName);
    }

    public static boolean IsBatchOp(String clsName) throws Exception {
        return !OpUtil.IsStreamOp(clsName);
    }

    public static boolean isExtendCls(String clsName, Class parent) {
        if ((clsName = OpUtil.transformOpName(clsName)).startsWith("com.alibaba.alink.")) {
            Class<?> cls = null;
            try {
                cls = Class.forName(clsName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Invalid functionName: " + clsName);
            }
            return parent.isAssignableFrom(cls);
        }
        return false;
    }
}

