/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.common.sql.builtin;

import com.alibaba.alink.common.sql.builtin.extension.AggAsArray;
import com.alibaba.alink.common.sql.builtin.extension.SlidingPairOverArray;
import com.alibaba.alink.common.sql.builtin.string.ConcatAgg;
import com.alibaba.alink.common.sql.builtin.string.DataFormat;
import com.alibaba.alink.common.sql.builtin.string.DateAdd;
import com.alibaba.alink.common.sql.builtin.string.DateDiff;
import com.alibaba.alink.common.sql.builtin.string.DateSub;
import com.alibaba.alink.common.sql.builtin.string.FromUnixTime;
import com.alibaba.alink.common.sql.builtin.string.KeyValue;
import com.alibaba.alink.common.sql.builtin.string.Now;
import com.alibaba.alink.common.sql.builtin.string.RegExp;
import com.alibaba.alink.common.sql.builtin.string.RegExpExtract;
import com.alibaba.alink.common.sql.builtin.string.RegExpReplace;
import com.alibaba.alink.common.sql.builtin.string.SplitPart;
import com.alibaba.alink.common.sql.builtin.string.ToTimeStamp;
import com.alibaba.alink.common.sql.builtin.string.UnixTimeStamp;
import com.alibaba.alink.common.utils.Types;
import com.alibaba.alink.operator.common.similarity.VectorDistanceUDF;
import java.util.stream.Stream;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.BatchTableEnvironment;
import org.apache.flink.table.api.java.StreamTableEnvironment;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;

public class AlinkRegisterBuiltinFunctions {
    public static void RegisterFunctions(TableEnvironment env) {
        String zeroFn = "__alink_zero__";
        if (Stream.of(env.listUserDefinedFunctions()).anyMatch("__alink_zero__"::equals)) {
            return;
        }
        env.registerFunction("__alink_zero__", (ScalarFunction)new ZeroScalarFunction());
        env.registerFunction("split_part", (ScalarFunction)new SplitPart());
        env.registerFunction("keyvalue", (ScalarFunction)new KeyValue());
        env.registerFunction("regexp_replace", (ScalarFunction)new RegExpReplace());
        env.registerFunction("REGEXP_REPLACE", (ScalarFunction)new RegExpReplace());
        env.registerFunction("regexp", (ScalarFunction)new RegExp());
        env.registerFunction("REGEXP", (ScalarFunction)new RegExp());
        env.registerFunction("regexp_extract", (ScalarFunction)new RegExpExtract());
        env.registerFunction("REGEXP_EXTRACT", (ScalarFunction)new RegExpExtract());
        env.registerFunction("NOW", (ScalarFunction)new Now());
        env.registerFunction("DATEDIFF", (ScalarFunction)new DateDiff());
        env.registerFunction("TO_TIMESTAMP", (ScalarFunction)new ToTimeStamp());
        env.registerFunction("UNIX_TIMESTAMP", (ScalarFunction)new UnixTimeStamp());
        env.registerFunction("FROM_UNIXTIME", (ScalarFunction)new FromUnixTime());
        env.registerFunction("DATE_FORMAT_LTZ", (ScalarFunction)new DataFormat());
        env.registerFunction("date_format_ltz", (ScalarFunction)new DataFormat());
        env.registerFunction("DATE_ADD", (ScalarFunction)new DateAdd());
        env.registerFunction("DATE_SUB", (ScalarFunction)new DateSub());
        env.registerFunction("VECTOR_DISTANCE", (ScalarFunction)new VectorDistanceUDF());
        if (env instanceof StreamTableEnvironment) {
            ((StreamTableEnvironment)env).registerFunction("CONCAT_AGG", (AggregateFunction)new ConcatAgg());
            ((StreamTableEnvironment)env).registerFunction("concat_agg", (AggregateFunction)new ConcatAgg());
        } else {
            ((BatchTableEnvironment)env).registerFunction("CONCAT_AGG", (AggregateFunction)new ConcatAgg());
            ((BatchTableEnvironment)env).registerFunction("concat_agg", (AggregateFunction)new ConcatAgg());
        }
        if (env instanceof StreamTableEnvironment) {
            ((StreamTableEnvironment)env).registerFunction("AGG_AS_ARRAY", (AggregateFunction)new AggAsArray());
            ((StreamTableEnvironment)env).registerFunction("agg_as_array", (AggregateFunction)new AggAsArray());
            ((StreamTableEnvironment)env).registerFunction("SLIDING_PIAR_OVER_STRING_ARRAY", (TableFunction)new SlidingPairOverArray(Types.STRING));
            ((StreamTableEnvironment)env).registerFunction("SLIDING_PAIR_OVER_STRING_ARRAY", (TableFunction)new SlidingPairOverArray(Types.STRING));
            ((StreamTableEnvironment)env).registerFunction("sliding_pair_over_string_array", (TableFunction)new SlidingPairOverArray(Types.STRING));
        }
    }

    public static class ZeroScalarFunction
    extends ScalarFunction {
        public int eval() {
            return 0;
        }
    }
}

