/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import shaded.alink.kafka011.org.apache.kafka.common.utils.CollectionUtils;

public class TxnOffsetCommitRequest
extends AbstractRequest {
    private static final String TRANSACTIONAL_ID_KEY_NAME = "transactional_id";
    private static final String CONSUMER_GROUP_ID_KEY_NAME = "consumer_group_id";
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String PRODUCER_EPOCH_KEY_NAME = "producer_epoch";
    private static final String TOPIC_PARTITIONS_KEY_NAME = "topics";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String OFFSET_KEY_NAME = "offset";
    private static final String METADATA_KEY_NAME = "metadata";
    private final String transactionalId;
    private final String consumerGroupId;
    private final long producerId;
    private final short producerEpoch;
    private final Map<TopicPartition, CommittedOffset> offsets;

    public TxnOffsetCommitRequest(short version, String transactionalId, String consumerGroupId, long producerId, short producerEpoch, Map<TopicPartition, CommittedOffset> offsets) {
        super(version);
        this.transactionalId = transactionalId;
        this.consumerGroupId = consumerGroupId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.offsets = offsets;
    }

    public TxnOffsetCommitRequest(Struct struct, short version) {
        super(version);
        Object[] topicPartitionsArray;
        this.transactionalId = struct.getString(TRANSACTIONAL_ID_KEY_NAME);
        this.consumerGroupId = struct.getString(CONSUMER_GROUP_ID_KEY_NAME);
        this.producerId = struct.getLong(PRODUCER_ID_KEY_NAME);
        this.producerEpoch = struct.getShort(PRODUCER_EPOCH_KEY_NAME);
        HashMap<TopicPartition, CommittedOffset> offsets = new HashMap<TopicPartition, CommittedOffset>();
        for (Object topicPartitionObj : topicPartitionsArray = struct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
            Struct topicPartitionStruct = (Struct)topicPartitionObj;
            String topic = topicPartitionStruct.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionStruct = (Struct)partitionObj;
                TopicPartition partition = new TopicPartition(topic, partitionStruct.getInt(PARTITION_KEY_NAME));
                long offset = partitionStruct.getLong(OFFSET_KEY_NAME);
                String metadata = partitionStruct.getString(METADATA_KEY_NAME);
                offsets.put(partition, new CommittedOffset(offset, metadata));
            }
        }
        this.offsets = offsets;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public String consumerGroupId() {
        return this.consumerGroupId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public Map<TopicPartition, CommittedOffset> offsets() {
        return this.offsets;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.TXN_OFFSET_COMMIT.requestSchema(this.version()));
        struct.set(TRANSACTIONAL_ID_KEY_NAME, (Object)this.transactionalId);
        struct.set(CONSUMER_GROUP_ID_KEY_NAME, (Object)this.consumerGroupId);
        struct.set(PRODUCER_ID_KEY_NAME, (Object)this.producerId);
        struct.set(PRODUCER_EPOCH_KEY_NAME, (Object)this.producerEpoch);
        Map<String, Map<Integer, CommittedOffset>> mappedPartitionOffsets = CollectionUtils.groupDataByTopic(this.offsets);
        Object[] partitionsArray = new Object[mappedPartitionOffsets.size()];
        int i = 0;
        for (Map.Entry<String, Map<Integer, CommittedOffset>> topicAndPartitions : mappedPartitionOffsets.entrySet()) {
            Struct topicPartitionsStruct = struct.instance(TOPIC_PARTITIONS_KEY_NAME);
            topicPartitionsStruct.set(TOPIC_KEY_NAME, (Object)topicAndPartitions.getKey());
            Map<Integer, CommittedOffset> partitionOffsets = topicAndPartitions.getValue();
            Object[] partitionOffsetsArray = new Object[partitionOffsets.size()];
            int j = 0;
            for (Map.Entry<Integer, CommittedOffset> partitionOffset : partitionOffsets.entrySet()) {
                Struct partitionOffsetStruct = topicPartitionsStruct.instance(PARTITIONS_KEY_NAME);
                partitionOffsetStruct.set(PARTITION_KEY_NAME, (Object)partitionOffset.getKey());
                CommittedOffset committedOffset = partitionOffset.getValue();
                partitionOffsetStruct.set(OFFSET_KEY_NAME, (Object)committedOffset.offset);
                partitionOffsetStruct.set(METADATA_KEY_NAME, (Object)committedOffset.metadata);
                partitionOffsetsArray[j++] = partitionOffsetStruct;
            }
            topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)partitionOffsetsArray);
            partitionsArray[i++] = topicPartitionsStruct;
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)partitionsArray);
        return struct;
    }

    @Override
    public TxnOffsetCommitResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>(this.offsets.size());
        for (TopicPartition partition : this.offsets.keySet()) {
            errors.put(partition, error);
        }
        return new TxnOffsetCommitResponse(throttleTimeMs, errors);
    }

    public static TxnOffsetCommitRequest parse(ByteBuffer buffer, short version) {
        return new TxnOffsetCommitRequest(ApiKeys.TXN_OFFSET_COMMIT.parseRequest(version, buffer), version);
    }

    public static class CommittedOffset {
        private final long offset;
        private final String metadata;

        public CommittedOffset(long offset, String metadata) {
            this.offset = offset;
            this.metadata = metadata;
        }

        public String toString() {
            return "CommittedOffset(offset=" + this.offset + ", metadata='" + this.metadata + "')";
        }

        public long offset() {
            return this.offset;
        }

        public String metadata() {
            return this.metadata;
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<TxnOffsetCommitRequest> {
        private final String transactionalId;
        private final String consumerGroupId;
        private final long producerId;
        private final short producerEpoch;
        private final Map<TopicPartition, CommittedOffset> offsets;

        public Builder(String transactionalId, String consumerGroupId, long producerId, short producerEpoch, Map<TopicPartition, CommittedOffset> offsets) {
            super(ApiKeys.TXN_OFFSET_COMMIT);
            this.transactionalId = transactionalId;
            this.consumerGroupId = consumerGroupId;
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.offsets = offsets;
        }

        public String consumerGroupId() {
            return this.consumerGroupId;
        }

        public Map<TopicPartition, CommittedOffset> offsets() {
            return this.offsets;
        }

        @Override
        public TxnOffsetCommitRequest build(short version) {
            return new TxnOffsetCommitRequest(version, this.transactionalId, this.consumerGroupId, this.producerId, this.producerEpoch, this.offsets);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=TxnOffsetCommitRequest").append(", transactionalId=").append(this.transactionalId).append(", producerId=").append(this.producerId).append(", producerEpoch=").append(this.producerEpoch).append(", consumerGroupId=").append(this.consumerGroupId).append(", offsets=").append(this.offsets).append(")");
            return bld.toString();
        }
    }
}

