/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.SchemaException;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Type;

public class Schema
extends Type {
    private final Field[] fields;
    private final Map<String, Field> fieldsByName;

    public Schema(Field ... fs) {
        this.fields = new Field[fs.length];
        this.fieldsByName = new HashMap<String, Field>();
        for (int i = 0; i < this.fields.length; ++i) {
            Field field = fs[i];
            if (this.fieldsByName.containsKey(field.name)) {
                throw new SchemaException("Schema contains a duplicate field: " + field.name);
            }
            this.fields[i] = new Field(i, field.name, field.type, field.doc, field.defaultValue, this);
            this.fieldsByName.put(fs[i].name, this.fields[i]);
        }
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        Struct r = (Struct)o;
        for (Field field : this.fields) {
            try {
                Object value = field.type().validate(r.get(field));
                field.type.write(buffer, value);
            }
            catch (Exception e) {
                throw new SchemaException("Error writing field '" + field.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
    }

    @Override
    public Struct read(ByteBuffer buffer) {
        Object[] objects = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                objects[i] = this.fields[i].type.read(buffer);
                continue;
            }
            catch (Exception e) {
                throw new SchemaException("Error reading field '" + this.fields[i].name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return new Struct(this, objects);
    }

    @Override
    public int sizeOf(Object o) {
        int size = 0;
        Struct r = (Struct)o;
        for (Field field : this.fields) {
            try {
                size += field.type.sizeOf(r.get(field));
            }
            catch (Exception e) {
                throw new SchemaException("Error computing size for field '" + field.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return size;
    }

    public int numFields() {
        return this.fields.length;
    }

    public Field get(int slot) {
        return this.fields[slot];
    }

    public Field get(String name) {
        return this.fieldsByName.get(name);
    }

    public Field[] fields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.fields.length; ++i) {
            b.append(this.fields[i].name);
            b.append(':');
            b.append(this.fields[i].type());
            if (i >= this.fields.length - 1) continue;
            b.append(',');
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public Struct validate(Object item) {
        try {
            Struct struct = (Struct)item;
            for (Field field : this.fields) {
                try {
                    field.type.validate(struct.get(field));
                }
                catch (SchemaException e) {
                    throw new SchemaException("Invalid value for field '" + field.name + "': " + e.getMessage());
                }
            }
            return struct;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not a Struct.");
        }
    }
}

