/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.metrics;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import shaded.alink.kafka011.org.apache.kafka.common.metrics.Quota;
import shaded.alink.kafka011.org.apache.kafka.common.metrics.Sensor;

public class MetricConfig {
    private Quota quota = null;
    private int samples = 2;
    private long eventWindow = Long.MAX_VALUE;
    private long timeWindowMs = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private Map<String, String> tags = new LinkedHashMap<String, String>();
    private Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;

    public Quota quota() {
        return this.quota;
    }

    public MetricConfig quota(Quota quota) {
        this.quota = quota;
        return this;
    }

    public long eventWindow() {
        return this.eventWindow;
    }

    public MetricConfig eventWindow(long window) {
        this.eventWindow = window;
        return this;
    }

    public long timeWindowMs() {
        return this.timeWindowMs;
    }

    public MetricConfig timeWindow(long window, TimeUnit unit) {
        this.timeWindowMs = TimeUnit.MILLISECONDS.convert(window, unit);
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public MetricConfig tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public int samples() {
        return this.samples;
    }

    public MetricConfig samples(int samples) {
        if (samples < 1) {
            throw new IllegalArgumentException("The number of samples must be at least 1.");
        }
        this.samples = samples;
        return this;
    }

    public Sensor.RecordingLevel recordLevel() {
        return this.recordingLevel;
    }

    public MetricConfig recordLevel(Sensor.RecordingLevel recordingLevel) {
        this.recordingLevel = recordingLevel;
        return this;
    }
}

