/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.record;

import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ByteBufferInputStream
extends DataInputStream {
    public ByteBufferInputStream(ByteBuffer buffer) {
        super(new UnderlyingInputStream(buffer));
    }

    private static final class UnderlyingInputStream
    extends InputStream {
        private final ByteBuffer buffer;

        public UnderlyingInputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() {
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
            return this.buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) {
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buffer.remaining());
            this.buffer.get(bytes, off, len);
            return len;
        }
    }
}

