/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.clients.producer.internals;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import shaded.alink.kafka010.org.apache.kafka.clients.producer.RecordMetadata;
import shaded.alink.kafka010.org.apache.kafka.clients.producer.internals.ProduceRequestResult;

public final class FutureRecordMetadata
implements Future<RecordMetadata> {
    private final ProduceRequestResult result;
    private final long relativeOffset;
    private final long createTimestamp;
    private final long checksum;
    private final int serializedKeySize;
    private final int serializedValueSize;

    public FutureRecordMetadata(ProduceRequestResult result, long relativeOffset, long createTimestamp, long checksum, int serializedKeySize, int serializedValueSize) {
        this.result = result;
        this.relativeOffset = relativeOffset;
        this.createTimestamp = createTimestamp;
        this.checksum = checksum;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
    }

    @Override
    public boolean cancel(boolean interrupt) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public RecordMetadata get() throws InterruptedException, ExecutionException {
        this.result.await();
        return this.valueOrError();
    }

    @Override
    public RecordMetadata get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean occurred = this.result.await(timeout, unit);
        if (!occurred) {
            throw new TimeoutException("Timeout after waiting for " + TimeUnit.MILLISECONDS.convert(timeout, unit) + " ms.");
        }
        return this.valueOrError();
    }

    RecordMetadata valueOrError() throws ExecutionException {
        if (this.result.error() != null) {
            throw new ExecutionException(this.result.error());
        }
        return this.value();
    }

    RecordMetadata value() {
        return new RecordMetadata(this.result.topicPartition(), this.result.baseOffset(), this.relativeOffset, this.timestamp(), this.checksum, this.serializedKeySize, this.serializedValueSize);
    }

    private long timestamp() {
        return this.result.hasLogAppendTime() ? this.result.logAppendTime() : this.createTimestamp;
    }

    @Override
    public boolean isDone() {
        return this.result.completed();
    }
}

