/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.clients;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import shaded.alink.kafka010.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ProtoUtils;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ApiVersionsResponse;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Utils;

public class NodeApiVersions {
    private static final short NODE_TOO_OLD = -1;
    private static final short NODE_TOO_NEW = -2;
    private final Collection<ApiVersionsResponse.ApiVersion> nodeApiVersions;
    private final Map<ApiKeys, Short> usableVersions = new EnumMap<ApiKeys, Short>(ApiKeys.class);

    public static NodeApiVersions create() {
        return NodeApiVersions.create(Collections.emptyList());
    }

    public static NodeApiVersions create(Collection<ApiVersionsResponse.ApiVersion> overrides) {
        LinkedList<ApiVersionsResponse.ApiVersion> apiVersions = new LinkedList<ApiVersionsResponse.ApiVersion>(overrides);
        for (ApiKeys apiKey : ApiKeys.values()) {
            boolean exists = false;
            for (ApiVersionsResponse.ApiVersion apiVersion : apiVersions) {
                if (apiVersion.apiKey != apiKey.id) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            apiVersions.add(new ApiVersionsResponse.ApiVersion(apiKey.id, ProtoUtils.oldestVersion(apiKey.id), ProtoUtils.latestVersion(apiKey.id)));
        }
        return new NodeApiVersions(apiVersions);
    }

    public NodeApiVersions(Collection<ApiVersionsResponse.ApiVersion> nodeApiVersions) {
        this.nodeApiVersions = nodeApiVersions;
        for (ApiVersionsResponse.ApiVersion nodeApiVersion : nodeApiVersions) {
            short nodeApiKey = nodeApiVersion.apiKey;
            if (!ApiKeys.hasId(nodeApiKey)) continue;
            short v = Utils.min(ProtoUtils.latestVersion(nodeApiKey), nodeApiVersion.maxVersion);
            if (v < nodeApiVersion.minVersion) {
                this.usableVersions.put(ApiKeys.forId(nodeApiKey), (short)-2);
                continue;
            }
            if (v < ProtoUtils.oldestVersion(nodeApiKey)) {
                this.usableVersions.put(ApiKeys.forId(nodeApiKey), (short)-1);
                continue;
            }
            this.usableVersions.put(ApiKeys.forId(nodeApiKey), v);
        }
    }

    public short usableVersion(ApiKeys apiKey) {
        Short usableVersion = this.usableVersions.get((Object)apiKey);
        if (usableVersion == null) {
            throw new UnsupportedVersionException("The broker does not support " + (Object)((Object)apiKey));
        }
        if (usableVersion == -1) {
            throw new UnsupportedVersionException("The broker is too old to support " + (Object)((Object)apiKey) + " version " + ProtoUtils.oldestVersion(apiKey.id));
        }
        if (usableVersion == -2) {
            throw new UnsupportedVersionException("The broker is too new to support " + (Object)((Object)apiKey) + " version " + ProtoUtils.latestVersion(apiKey.id));
        }
        return usableVersion;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lineBreaks) {
        TreeMap<Short, String> apiKeysText = new TreeMap<Short, String>();
        for (ApiVersionsResponse.ApiVersion apiVersion : this.nodeApiVersions) {
            apiKeysText.put(apiVersion.apiKey, this.apiVersionToText(apiVersion));
        }
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKeysText.containsKey(apiKey.id)) continue;
            StringBuilder bld = new StringBuilder();
            bld.append(apiKey.name).append("(").append(apiKey.id).append("): ").append("UNSUPPORTED");
            apiKeysText.put(apiKey.id, bld.toString());
        }
        String separator = lineBreaks ? ",\n\t" : ", ";
        StringBuilder bld = new StringBuilder();
        bld.append("(");
        if (lineBreaks) {
            bld.append("\n\t");
        }
        bld.append(Utils.join(apiKeysText.values(), separator));
        if (lineBreaks) {
            bld.append("\n");
        }
        bld.append(")");
        return bld.toString();
    }

    private String apiVersionToText(ApiVersionsResponse.ApiVersion apiVersion) {
        StringBuilder bld = new StringBuilder();
        ApiKeys apiKey = null;
        if (ApiKeys.hasId(apiVersion.apiKey)) {
            apiKey = ApiKeys.forId(apiVersion.apiKey);
            bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
        } else {
            bld.append("UNKNOWN(").append(apiVersion.apiKey).append("): ");
        }
        if (apiVersion.minVersion == apiVersion.maxVersion) {
            bld.append(apiVersion.minVersion);
        } else {
            bld.append(apiVersion.minVersion).append(" to ").append(apiVersion.maxVersion);
        }
        if (apiKey != null) {
            Short usableVersion = this.usableVersions.get((Object)apiKey);
            if (usableVersion == -1) {
                bld.append(" [unusable: node too old]");
            } else if (usableVersion == -2) {
                bld.append(" [unusable: node too new]");
            } else {
                bld.append(" [usable: ").append(usableVersion).append("]");
            }
        }
        return bld.toString();
    }

    public ApiVersionsResponse.ApiVersion apiVersion(ApiKeys apiKey) {
        for (ApiVersionsResponse.ApiVersion nodeApiVersion : this.nodeApiVersions) {
            if (nodeApiVersion.apiKey != apiKey.id) continue;
            return nodeApiVersion;
        }
        throw new NoSuchElementException();
    }
}

