/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.ratelimiting.FlinkConnectorRateLimiter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internal.Handover;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internal.KafkaConsumerCallBridge09;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internal.KafkaConsumerThread;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.AbstractFetcher;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaCommitCallback;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionState;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.ConsumerRecord;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.ConsumerRecords;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import shaded.alink.kafka010.org.apache.kafka.common.TopicPartition;

@Internal
public class Kafka09Fetcher<T>
extends AbstractFetcher<T, TopicPartition> {
    private static final Logger LOG = LoggerFactory.getLogger(Kafka09Fetcher.class);
    private final KafkaDeserializationSchema<T> deserializer;
    private final Handover handover;
    private final KafkaConsumerThread consumerThread;
    private volatile boolean running = true;

    public Kafka09Fetcher(SourceFunction.SourceContext<T> sourceContext, Map<KafkaTopicPartition, Long> assignedPartitionsWithInitialOffsets, SerializedValue<AssignerWithPeriodicWatermarks<T>> watermarksPeriodic, SerializedValue<AssignerWithPunctuatedWatermarks<T>> watermarksPunctuated, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, String taskNameWithSubtasks, KafkaDeserializationSchema<T> deserializer, Properties kafkaProperties, long pollTimeout, MetricGroup subtaskMetricGroup, MetricGroup consumerMetricGroup, boolean useMetrics, FlinkConnectorRateLimiter rateLimiter) throws Exception {
        super(sourceContext, assignedPartitionsWithInitialOffsets, watermarksPeriodic, watermarksPunctuated, processingTimeProvider, autoWatermarkInterval, userCodeClassLoader, consumerMetricGroup, useMetrics);
        this.deserializer = deserializer;
        this.handover = new Handover();
        this.consumerThread = new KafkaConsumerThread(LOG, this.handover, kafkaProperties, this.unassignedPartitionsQueue, this.createCallBridge(), this.getFetcherName() + " for " + taskNameWithSubtasks, pollTimeout, useMetrics, consumerMetricGroup, subtaskMetricGroup, rateLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runFetchLoop() throws Exception {
        try {
            Handover handover = this.handover;
            this.consumerThread.start();
            while (this.running) {
                ConsumerRecords<byte[], byte[]> records = handover.pollNext();
                block6: for (KafkaTopicPartitionState<TopicPartition> kafkaTopicPartitionState : this.subscribedPartitionStates()) {
                    List<ConsumerRecord<byte[], byte[]>> partitionRecords = records.records((TopicPartition)kafkaTopicPartitionState.getKafkaPartitionHandle());
                    for (ConsumerRecord<byte[], byte[]> record : partitionRecords) {
                        T value = this.deserializer.deserialize(record);
                        if (this.deserializer.isEndOfStream(value)) {
                            this.running = false;
                            continue block6;
                        }
                        this.emitRecord(value, kafkaTopicPartitionState, record.offset(), record);
                    }
                }
            }
        }
        finally {
            this.consumerThread.shutdown();
        }
        try {
            this.consumerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        this.handover.close();
        this.consumerThread.shutdown();
    }

    protected void emitRecord(T record, KafkaTopicPartitionState<TopicPartition> partition, long offset, ConsumerRecord<?, ?> consumerRecord) throws Exception {
        this.emitRecord(record, partition, offset);
    }

    protected String getFetcherName() {
        return "Kafka 0.9 Fetcher";
    }

    protected KafkaConsumerCallBridge09 createCallBridge() {
        return new KafkaConsumerCallBridge09();
    }

    @Override
    public TopicPartition createKafkaPartitionHandle(KafkaTopicPartition partition) {
        return new TopicPartition(partition.getTopic(), partition.getPartition());
    }

    @Override
    protected void doCommitInternalOffsetsToKafka(Map<KafkaTopicPartition, Long> offsets, @Nonnull KafkaCommitCallback commitCallback) throws Exception {
        List partitions = this.subscribedPartitionStates();
        HashMap<TopicPartition, OffsetAndMetadata> offsetsToCommit = new HashMap<TopicPartition, OffsetAndMetadata>(partitions.size());
        for (KafkaTopicPartitionState partition : partitions) {
            Long lastProcessedOffset = offsets.get(partition.getKafkaTopicPartition());
            if (lastProcessedOffset == null) continue;
            Preconditions.checkState((lastProcessedOffset >= 0L ? 1 : 0) != 0, (Object)"Illegal offset value to commit");
            long offsetToCommit = lastProcessedOffset + 1L;
            offsetsToCommit.put((TopicPartition)partition.getKafkaPartitionHandle(), new OffsetAndMetadata(offsetToCommit));
            partition.setCommittedOffset(offsetToCommit);
        }
        this.consumerThread.setOffsetsToCommit(offsetsToCommit, commitCallback);
    }
}

