/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.SaslAuthenticateResponse;

public class SaslAuthenticateRequest
extends AbstractRequest {
    private static final String SASL_AUTH_BYTES_KEY_NAME = "sasl_auth_bytes";
    private static final Schema SASL_AUTHENTICATE_REQUEST_V0;
    private static final Schema SASL_AUTHENTICATE_REQUEST_V1;
    private final ByteBuffer saslAuthBytes;

    public static Schema[] schemaVersions() {
        return new Schema[]{SASL_AUTHENTICATE_REQUEST_V0, SASL_AUTHENTICATE_REQUEST_V1};
    }

    public SaslAuthenticateRequest(ByteBuffer saslAuthBytes) {
        this(saslAuthBytes, ApiKeys.SASL_AUTHENTICATE.latestVersion());
    }

    public SaslAuthenticateRequest(ByteBuffer saslAuthBytes, short version) {
        super(ApiKeys.SASL_AUTHENTICATE, version);
        this.saslAuthBytes = saslAuthBytes;
    }

    public SaslAuthenticateRequest(Struct struct, short version) {
        super(ApiKeys.SASL_AUTHENTICATE, version);
        this.saslAuthBytes = struct.getBytes(SASL_AUTH_BYTES_KEY_NAME);
    }

    public ByteBuffer saslAuthBytes() {
        return this.saslAuthBytes;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new SaslAuthenticateResponse(Errors.forException(e), e.getMessage());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.SASL_AUTHENTICATE.latestVersion()));
    }

    public static SaslAuthenticateRequest parse(ByteBuffer buffer, short version) {
        return new SaslAuthenticateRequest(ApiKeys.SASL_AUTHENTICATE.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.SASL_AUTHENTICATE.requestSchema(this.version()));
        struct.set(SASL_AUTH_BYTES_KEY_NAME, (Object)this.saslAuthBytes);
        return struct;
    }

    static {
        SASL_AUTHENTICATE_REQUEST_V1 = SASL_AUTHENTICATE_REQUEST_V0 = new Schema(new Field(SASL_AUTH_BYTES_KEY_NAME, Type.BYTES, "SASL authentication bytes from client as defined by the SASL mechanism."));
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslAuthenticateRequest> {
        private final ByteBuffer saslAuthBytes;

        public Builder(ByteBuffer saslAuthBytes) {
            super(ApiKeys.SASL_AUTHENTICATE);
            this.saslAuthBytes = saslAuthBytes;
        }

        @Override
        public SaslAuthenticateRequest build(short version) {
            return new SaslAuthenticateRequest(this.saslAuthBytes, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=SaslAuthenticateRequest)");
            return bld.toString();
        }
    }
}

