/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import shaded.alink.kafka.org.apache.kafka.common.message.LeaveGroupRequestData;
import shaded.alink.kafka.org.apache.kafka.common.message.LeaveGroupResponseData;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.LeaveGroupResponse;

public class LeaveGroupRequest
extends AbstractRequest {
    private final LeaveGroupRequestData data;
    private final short version;

    private LeaveGroupRequest(LeaveGroupRequestData data, short version) {
        super(ApiKeys.LEAVE_GROUP, version);
        this.data = data;
        this.version = version;
    }

    public LeaveGroupRequest(Struct struct, short version) {
        super(ApiKeys.LEAVE_GROUP, version);
        this.data = new LeaveGroupRequestData(struct, version);
        this.version = version;
    }

    public LeaveGroupRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        LeaveGroupResponseData response = new LeaveGroupResponseData();
        if (this.version() >= 2) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        return new LeaveGroupResponse(response);
    }

    public static LeaveGroupRequest parse(ByteBuffer buffer, short version) {
        return new LeaveGroupRequest(ApiKeys.LEAVE_GROUP.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public static class Builder
    extends AbstractRequest.Builder<LeaveGroupRequest> {
        private final LeaveGroupRequestData data;

        public Builder(LeaveGroupRequestData data) {
            super(ApiKeys.LEAVE_GROUP);
            this.data = data;
        }

        @Override
        public LeaveGroupRequest build(short version) {
            return new LeaveGroupRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

