/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.ControlledShutdownResponse;

public class ControlledShutdownRequest
extends AbstractRequest {
    private static final String BROKER_ID_KEY_NAME = "broker_id";
    private static final String BROKER_EPOCH_KEY_NAME = "broker_epoch";
    private static final Schema CONTROLLED_SHUTDOWN_REQUEST_V0;
    private static final Schema CONTROLLED_SHUTDOWN_REQUEST_V1;
    private static final Schema CONTROLLED_SHUTDOWN_REQUEST_V2;
    private final int brokerId;
    private final long brokerEpoch;

    public static Schema[] schemaVersions() {
        return new Schema[]{CONTROLLED_SHUTDOWN_REQUEST_V0, CONTROLLED_SHUTDOWN_REQUEST_V1, CONTROLLED_SHUTDOWN_REQUEST_V2};
    }

    private ControlledShutdownRequest(int brokerId, long brokerEpoch, short version) {
        super(ApiKeys.CONTROLLED_SHUTDOWN, version);
        this.brokerId = brokerId;
        this.brokerEpoch = brokerEpoch;
    }

    public ControlledShutdownRequest(Struct struct, short version) {
        super(ApiKeys.CONTROLLED_SHUTDOWN, version);
        this.brokerId = struct.getInt(BROKER_ID_KEY_NAME);
        this.brokerEpoch = struct.hasField(BROKER_EPOCH_KEY_NAME) ? struct.getLong(BROKER_EPOCH_KEY_NAME) : -1L;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new ControlledShutdownResponse(Errors.forException(e), Collections.emptySet());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()));
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownRequest(ApiKeys.CONTROLLED_SHUTDOWN.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.CONTROLLED_SHUTDOWN.requestSchema(this.version()));
        struct.set(BROKER_ID_KEY_NAME, (Object)this.brokerId);
        struct.setIfExists(BROKER_EPOCH_KEY_NAME, (Object)this.brokerEpoch);
        return struct;
    }

    static {
        CONTROLLED_SHUTDOWN_REQUEST_V1 = CONTROLLED_SHUTDOWN_REQUEST_V0 = new Schema(new Field(BROKER_ID_KEY_NAME, Type.INT32, "The id of the broker for which controlled shutdown has been requested."));
        CONTROLLED_SHUTDOWN_REQUEST_V2 = new Schema(new Field(BROKER_ID_KEY_NAME, Type.INT32, "The id of the broker for which controlled shutdown has been requested."), new Field(BROKER_EPOCH_KEY_NAME, Type.INT64, "The broker epoch"));
    }

    public static class Builder
    extends AbstractRequest.Builder<ControlledShutdownRequest> {
        private final int brokerId;
        private final long brokerEpoch;

        public Builder(int brokerId, long brokerEpoch, short desiredVersion) {
            super(ApiKeys.CONTROLLED_SHUTDOWN, desiredVersion);
            this.brokerId = brokerId;
            this.brokerEpoch = brokerEpoch;
        }

        @Override
        public ControlledShutdownRequest build(short version) {
            return new ControlledShutdownRequest(this.brokerId, this.brokerEpoch, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ControlledShutdownRequest").append(", brokerId=").append(this.brokerId).append(", brokerEpoch=").append(this.brokerEpoch).append(")");
            return bld.toString();
        }
    }
}

