/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import shaded.alink.kafka.org.apache.kafka.common.errors.AuthenticationException;
import shaded.alink.kafka.org.apache.kafka.common.memory.MemoryPool;
import shaded.alink.kafka.org.apache.kafka.common.network.Authenticator;
import shaded.alink.kafka.org.apache.kafka.common.network.ChannelState;
import shaded.alink.kafka.org.apache.kafka.common.network.DelayedResponseAuthenticationException;
import shaded.alink.kafka.org.apache.kafka.common.network.NetworkReceive;
import shaded.alink.kafka.org.apache.kafka.common.network.ReauthenticationContext;
import shaded.alink.kafka.org.apache.kafka.common.network.Send;
import shaded.alink.kafka.org.apache.kafka.common.network.TransportLayer;
import shaded.alink.kafka.org.apache.kafka.common.security.auth.KafkaPrincipal;
import shaded.alink.kafka.org.apache.kafka.common.utils.Utils;

public class KafkaChannel
implements AutoCloseable {
    private static final long MIN_REAUTH_INTERVAL_ONE_SECOND_NANOS = 1000000000L;
    private final String id;
    private final TransportLayer transportLayer;
    private final Supplier<Authenticator> authenticatorCreator;
    private Authenticator authenticator;
    private long networkThreadTimeNanos;
    private final int maxReceiveSize;
    private final MemoryPool memoryPool;
    private NetworkReceive receive;
    private Send send;
    private boolean disconnected;
    private ChannelMuteState muteState;
    private ChannelState state;
    private SocketAddress remoteAddress;
    private int successfulAuthentications;
    private boolean midWrite;
    private long lastReauthenticationStartNanos;

    public KafkaChannel(String id, TransportLayer transportLayer, Supplier<Authenticator> authenticatorCreator, int maxReceiveSize, MemoryPool memoryPool) {
        this.id = id;
        this.transportLayer = transportLayer;
        this.authenticatorCreator = authenticatorCreator;
        this.authenticator = authenticatorCreator.get();
        this.networkThreadTimeNanos = 0L;
        this.maxReceiveSize = maxReceiveSize;
        this.memoryPool = memoryPool;
        this.disconnected = false;
        this.muteState = ChannelMuteState.NOT_MUTED;
        this.state = ChannelState.NOT_CONNECTED;
    }

    @Override
    public void close() throws IOException {
        this.disconnected = true;
        Utils.closeAll(this.transportLayer, this.authenticator, this.receive);
    }

    public KafkaPrincipal principal() {
        return this.authenticator.principal();
    }

    public void prepare() throws AuthenticationException, IOException {
        boolean authenticating = false;
        try {
            if (!this.transportLayer.ready()) {
                this.transportLayer.handshake();
            }
            if (this.transportLayer.ready() && !this.authenticator.complete()) {
                authenticating = true;
                this.authenticator.authenticate();
            }
        }
        catch (AuthenticationException e) {
            String remoteDesc = this.remoteAddress != null ? this.remoteAddress.toString() : null;
            this.state = new ChannelState(ChannelState.State.AUTHENTICATION_FAILED, e, remoteDesc);
            if (authenticating) {
                this.delayCloseOnAuthenticationFailure();
                throw new DelayedResponseAuthenticationException(e);
            }
            throw e;
        }
        if (this.ready()) {
            ++this.successfulAuthentications;
            this.state = ChannelState.READY;
        }
    }

    public void disconnect() {
        this.disconnected = true;
        if (this.state == ChannelState.NOT_CONNECTED && this.remoteAddress != null) {
            this.state = new ChannelState(ChannelState.State.NOT_CONNECTED, this.remoteAddress.toString());
        }
        this.transportLayer.disconnect();
    }

    public void state(ChannelState state) {
        this.state = state;
    }

    public ChannelState state() {
        return this.state;
    }

    public boolean finishConnect() throws IOException {
        boolean connected;
        SocketChannel socketChannel = this.transportLayer.socketChannel();
        if (socketChannel != null) {
            this.remoteAddress = socketChannel.getRemoteAddress();
        }
        if (connected = this.transportLayer.finishConnect()) {
            this.state = this.ready() ? ChannelState.READY : (this.remoteAddress != null ? new ChannelState(ChannelState.State.AUTHENTICATE, this.remoteAddress.toString()) : ChannelState.AUTHENTICATE);
        }
        return connected;
    }

    public boolean isConnected() {
        return this.transportLayer.isConnected();
    }

    public String id() {
        return this.id;
    }

    public SelectionKey selectionKey() {
        return this.transportLayer.selectionKey();
    }

    void mute() {
        if (this.muteState == ChannelMuteState.NOT_MUTED) {
            if (!this.disconnected) {
                this.transportLayer.removeInterestOps(1);
            }
            this.muteState = ChannelMuteState.MUTED;
        }
    }

    boolean maybeUnmute() {
        if (this.muteState == ChannelMuteState.MUTED) {
            if (!this.disconnected) {
                this.transportLayer.addInterestOps(1);
            }
            this.muteState = ChannelMuteState.NOT_MUTED;
        }
        return this.muteState == ChannelMuteState.NOT_MUTED;
    }

    public void handleChannelMuteEvent(ChannelMuteEvent event) {
        boolean stateChanged = false;
        switch (event) {
            case REQUEST_RECEIVED: {
                if (this.muteState != ChannelMuteState.MUTED) break;
                this.muteState = ChannelMuteState.MUTED_AND_RESPONSE_PENDING;
                stateChanged = true;
                break;
            }
            case RESPONSE_SENT: {
                if (this.muteState == ChannelMuteState.MUTED_AND_RESPONSE_PENDING) {
                    this.muteState = ChannelMuteState.MUTED;
                    stateChanged = true;
                }
                if (this.muteState != ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_THROTTLED;
                stateChanged = true;
                break;
            }
            case THROTTLE_STARTED: {
                if (this.muteState != ChannelMuteState.MUTED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING;
                stateChanged = true;
                break;
            }
            case THROTTLE_ENDED: {
                if (this.muteState == ChannelMuteState.MUTED_AND_THROTTLED) {
                    this.muteState = ChannelMuteState.MUTED;
                    stateChanged = true;
                }
                if (this.muteState != ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_RESPONSE_PENDING;
                stateChanged = true;
            }
        }
        if (!stateChanged) {
            throw new IllegalStateException("Cannot transition from " + this.muteState.name() + " for " + event.name());
        }
    }

    public ChannelMuteState muteState() {
        return this.muteState;
    }

    private void delayCloseOnAuthenticationFailure() {
        this.transportLayer.removeInterestOps(4);
    }

    void completeCloseOnAuthenticationFailure() throws IOException {
        this.transportLayer.addInterestOps(4);
        this.authenticator.handleAuthenticationFailure();
    }

    public boolean isMute() {
        return this.muteState != ChannelMuteState.NOT_MUTED;
    }

    public boolean isInMutableState() {
        if (this.receive == null || this.receive.memoryAllocated()) {
            return false;
        }
        return this.transportLayer.ready();
    }

    public boolean ready() {
        return this.transportLayer.ready() && this.authenticator.complete();
    }

    public boolean hasSend() {
        return this.send != null;
    }

    public InetAddress socketAddress() {
        return this.transportLayer.socketChannel().socket().getInetAddress();
    }

    public String socketDescription() {
        Socket socket = this.transportLayer.socketChannel().socket();
        if (socket.getInetAddress() == null) {
            return socket.getLocalAddress().toString();
        }
        return socket.getInetAddress().toString();
    }

    public void setSend(Send send) {
        if (this.send != null) {
            throw new IllegalStateException("Attempt to begin a send operation with prior send operation still in progress, connection id is " + this.id);
        }
        this.send = send;
        this.transportLayer.addInterestOps(4);
    }

    public NetworkReceive read() throws IOException {
        NetworkReceive result = null;
        if (this.receive == null) {
            this.receive = new NetworkReceive(this.maxReceiveSize, this.id, this.memoryPool);
        }
        this.receive(this.receive);
        if (this.receive.complete()) {
            this.receive.payload().rewind();
            result = this.receive;
            this.receive = null;
        } else if (this.receive.requiredMemoryAmountKnown() && !this.receive.memoryAllocated() && this.isInMutableState()) {
            this.mute();
        }
        return result;
    }

    public Send write() throws IOException {
        Send result = null;
        if (this.send != null && this.send(this.send)) {
            result = this.send;
            this.send = null;
        }
        return result;
    }

    public void addNetworkThreadTimeNanos(long nanos) {
        this.networkThreadTimeNanos += nanos;
    }

    public long getAndResetNetworkThreadTimeNanos() {
        long current = this.networkThreadTimeNanos;
        this.networkThreadTimeNanos = 0L;
        return current;
    }

    private long receive(NetworkReceive receive) throws IOException {
        return receive.readFrom(this.transportLayer);
    }

    private boolean send(Send send) throws IOException {
        this.midWrite = true;
        send.writeTo(this.transportLayer);
        if (send.completed()) {
            this.midWrite = false;
            this.transportLayer.removeInterestOps(4);
        }
        return send.completed();
    }

    public boolean hasBytesBuffered() {
        return this.transportLayer.hasBytesBuffered();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaChannel that = (KafkaChannel)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return super.toString() + " id=" + this.id;
    }

    public int successfulAuthentications() {
        return this.successfulAuthentications;
    }

    public boolean maybeBeginServerReauthentication(NetworkReceive saslHandshakeNetworkReceive, Supplier<Long> nowNanosSupplier) throws AuthenticationException, IOException {
        if (!this.ready()) {
            throw new IllegalStateException("KafkaChannel should be \"ready\" when processing SASL Handshake for potential re-authentication");
        }
        if (this.authenticator.serverSessionExpirationTimeNanos() == null) {
            return false;
        }
        long nowNanos = nowNanosSupplier.get();
        if (this.lastReauthenticationStartNanos != 0L && nowNanos - this.lastReauthenticationStartNanos < 1000000000L) {
            return false;
        }
        this.lastReauthenticationStartNanos = nowNanos;
        this.swapAuthenticatorsAndBeginReauthentication(new ReauthenticationContext(this.authenticator, saslHandshakeNetworkReceive, nowNanos));
        return true;
    }

    public boolean maybeBeginClientReauthentication(Supplier<Long> nowNanosSupplier) throws AuthenticationException, IOException {
        if (!this.ready()) {
            throw new IllegalStateException("KafkaChannel should always be \"ready\" when it is checked for possible re-authentication");
        }
        if (this.muteState != ChannelMuteState.NOT_MUTED || this.midWrite || this.authenticator.clientSessionReauthenticationTimeNanos() == null) {
            return false;
        }
        long nowNanos = nowNanosSupplier.get();
        if (nowNanos < this.authenticator.clientSessionReauthenticationTimeNanos()) {
            return false;
        }
        this.swapAuthenticatorsAndBeginReauthentication(new ReauthenticationContext(this.authenticator, this.receive, nowNanos));
        this.receive = null;
        return true;
    }

    public Long reauthenticationLatencyMs() {
        return this.authenticator.reauthenticationLatencyMs();
    }

    public boolean serverAuthenticationSessionExpired(long nowNanos) {
        Long serverSessionExpirationTimeNanos = this.authenticator.serverSessionExpirationTimeNanos();
        return serverSessionExpirationTimeNanos != null && nowNanos - serverSessionExpirationTimeNanos > 0L;
    }

    public List<NetworkReceive> getAndClearResponsesReceivedDuringReauthentication() {
        return this.authenticator.getAndClearResponsesReceivedDuringReauthentication();
    }

    boolean connectedClientSupportsReauthentication() {
        return this.authenticator.connectedClientSupportsReauthentication();
    }

    private void swapAuthenticatorsAndBeginReauthentication(ReauthenticationContext reauthenticationContext) throws IOException {
        this.authenticator = this.authenticatorCreator.get();
        this.authenticator.reauthenticate(reauthenticationContext);
    }

    public static enum ChannelMuteEvent {
        REQUEST_RECEIVED,
        RESPONSE_SENT,
        THROTTLE_STARTED,
        THROTTLE_ENDED;

    }

    public static enum ChannelMuteState {
        NOT_MUTED,
        MUTED,
        MUTED_AND_RESPONSE_PENDING,
        MUTED_AND_THROTTLED,
        MUTED_AND_THROTTLED_AND_RESPONSE_PENDING;

    }
}

