/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Message;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;

public class OffsetFetchRequestData
implements ApiMessage {
    private String groupId;
    private List<OffsetFetchRequestTopic> topics;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public OffsetFetchRequestData(Readable readable, short version) {
        this.topics = new ArrayList<OffsetFetchRequestTopic>();
        this.read(readable, version);
    }

    public OffsetFetchRequestData(Struct struct, short version) {
        this.topics = new ArrayList<OffsetFetchRequestTopic>();
        this.fromStruct(struct, version);
    }

    public OffsetFetchRequestData() {
        this.groupId = "";
        this.topics = new ArrayList<OffsetFetchRequestTopic>();
    }

    @Override
    public short apiKey() {
        return 9;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable readable, short version) {
        this.groupId = readable.readNullableString();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new OffsetFetchRequestTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.groupId);
        if (this.topics == null) {
            writable.writeInt(-1);
        } else {
            writable.writeInt(this.topics.size());
            for (OffsetFetchRequestTopic element : this.topics) {
                element.write(writable, version);
            }
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.groupId = struct.getString("group_id");
        Object[] nestedObjects = struct.getArray("topics");
        if (nestedObjects == null) {
            this.topics = null;
        } else {
            this.topics = new ArrayList<OffsetFetchRequestTopic>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new OffsetFetchRequestTopic((Struct)nestedObject, version));
            }
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("group_id", (Object)this.groupId);
        if (this.topics == null) {
            struct.set("topics", null);
        } else {
            Struct[] nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (OffsetFetchRequestTopic element : this.topics) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.groupId);
        if (this.topics == null) {
            size += 4;
        } else {
            size += 4;
            for (OffsetFetchRequestTopic element : this.topics) {
                size += element.size(version);
            }
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetFetchRequestData)) {
            return false;
        }
        OffsetFetchRequestData other = (OffsetFetchRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "OffsetFetchRequestData(groupId='" + this.groupId + "', topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public List<OffsetFetchRequestTopic> topics() {
        return this.topics;
    }

    public OffsetFetchRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public OffsetFetchRequestData setTopics(List<OffsetFetchRequestTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The group to fetch offsets for."), new Field("topics", new ArrayOf(OffsetFetchRequestTopic.SCHEMA_0), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."));
        SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("group_id", Type.STRING, "The group to fetch offsets for."), new Field("topics", ArrayOf.nullable(OffsetFetchRequestTopic.SCHEMA_0), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."))));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class OffsetFetchRequestTopic
    implements Message {
        private String name;
        private List<Integer> partitionIndexes;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public OffsetFetchRequestTopic(Readable readable, short version) {
            this.partitionIndexes = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public OffsetFetchRequestTopic(Struct struct, short version) {
            this.partitionIndexes = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public OffsetFetchRequestTopic() {
            this.name = "";
            this.partitionIndexes = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionIndexes.clear();
            } else {
                this.partitionIndexes.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitionIndexes.add(readable.readInt());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitionIndexes.size());
            for (Integer element : this.partitionIndexes) {
                writable.writeInt(element);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partition_indexes");
            this.partitionIndexes = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionIndexes.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Integer[] nestedObjects = new Integer[this.partitionIndexes.size()];
            int i = 0;
            for (Integer element : this.partitionIndexes) {
                nestedObjects[i++] = element;
            }
            struct.set("partition_indexes", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            return size += this.partitionIndexes.size() * 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchRequestTopic)) {
                return false;
            }
            OffsetFetchRequestTopic other = (OffsetFetchRequestTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitionIndexes == null ? other.partitionIndexes != null : !this.partitionIndexes.equals(other.partitionIndexes));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndexes == null ? 0 : this.partitionIndexes.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetFetchRequestTopic(name='" + this.name + "', partitionIndexes=" + MessageUtil.deepToString(this.partitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitionIndexes() {
            return this.partitionIndexes;
        }

        public OffsetFetchRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetFetchRequestTopic setPartitionIndexes(List<Integer> v) {
            this.partitionIndexes = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, ""), new Field("partition_indexes", new ArrayOf(Type.INT32), "The partition indexes we would like to fetch offsets for."))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

