# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/02_transform.core.ipynb.

# %% auto 0
__all__ = ['interp']

# %% ../../nbs/02_transform.core.ipynb 3
from ..data.core import read_opus
import numpy as np
import matplotlib.pyplot as plt
from scipy import interpolate
from typing import Tuple

import numpy as np

# %% ../../nbs/02_transform.core.ipynb 4
def interp(
    x:Tuple[np.ndarray,np.ndarray], #(spectrum, wavenumbers)
    between:Tuple=(4000, 600), # wavenumbers range of interest
    res:int=2, # wavenumbers resolution
    kind:str='linear', # interpolation type (ref. scipy)
) -> Tuple: # (spectrum, wavenumbers) as `np.ndarray`
    "Interpolate spectra within the proper range and at resolution of interest" 
    spectrum, wn = x
    mask = np.logical_and(wn >= between[1], wn <= between[0])
    f = interpolate.interp1d(wn[mask], spectrum[mask], kind=kind, fill_value="extrapolate")
    wn_new = np.arange(between[0], between[1], -res, dtype=int)
    return f(wn_new), wn_new
