# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/03_data.load.ipynb.

# %% auto 0
__all__ = ['get_spectra_files', 'SpectraSetup', 'get_target', 'SpectraBlock', 'random_weighted_avg']

# %% ../../nbs/03_data.load.ipynb 3
from fastai.vision.all import *
from fastai.data.all import *
from pathlib import Path
import pandas as pd

# %% ../../nbs/03_data.load.ipynb 5
def get_spectra_files(path):
    "Return paths of spectra `.csv` files in path"
    return [f for f in path.ls() if re.match('\d', f.name)]

# %% ../../nbs/03_data.load.ipynb 8
class SpectraSetup(Transform):
    "Transform that converts to numpy arrays"
    def __init__(self):
        pass
    def encodes(self, fnames):
        n = pd.read_csv(fnames[0]).shape[0]
        m = len(fnames)
        x = np.empty((m,n))
        for i, fname in enumerate(fnames):
            x[i,:] = pd.read_csv(fname)['absorbance'].values
        return tensor(x)

# %% ../../nbs/03_data.load.ipynb 9
def get_target(path, analytes=None):
    path_target = [f for f in path.ls() if re.match('target', f.name)][0]
    df = pd.read_csv(path_target)
    if analytes:
        df = df[df.analyte.isin(analytes)]
    return df['value'].values

# %% ../../nbs/03_data.load.ipynb 11
def SpectraBlock():
    return TransformBlock(type_tfms=SpectraSetup())

# %% ../../nbs/03_data.load.ipynb 12
def random_weighted_avg(x):
    "Transform spectra replicates taking their random weighted averages"
    n = len(x)
    def weights(n):
        weights = torch.rand(n)
        return (weights/weights.sum()).unsqueeze(dim=0)
    return torch.matmul(weights(n), x)
