# Generated by Django 4.1.4 on 2022-12-12 11:12

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Metadata',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('coins', models.JSONField(default=dict, max_length=5048)),
                ('last_updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Meta Data',
                'verbose_name_plural': 'Meta Data',
            },
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('value_paid', models.DecimalField(decimal_places=0, default=0, max_digits=65, verbose_name='Value Paid')),
                ('value_received', models.DecimalField(decimal_places=0, default=0, max_digits=65, verbose_name='Value Received')),
                ('value_paid_coin', models.DecimalField(decimal_places=18, default=0, max_digits=65, verbose_name='Value Paid Coin')),
                ('value_received_coin', models.DecimalField(decimal_places=18, default=0, max_digits=65, verbose_name='Value Received Coin')),
                ('txid_in', models.CharField(default='', max_length=256, verbose_name='TXID in')),
                ('txid_out', models.CharField(default='', max_length=256, verbose_name='TXID out')),
                ('pending', models.BooleanField(default=True)),
                ('confirmations', models.IntegerField(default=0)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Provider',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('coin', models.CharField(max_length=16, unique=True, verbose_name='Coin')),
                ('cold_wallet', models.CharField(max_length=128, verbose_name='Cold Wallet')),
                ('active', models.BooleanField(default=True, verbose_name='Active')),
                ('last_updated', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('order_id', models.CharField(default='', max_length=128, verbose_name='Order ID')),
                ('nonce', models.CharField(default='', max_length=32, verbose_name='Nonce')),
                ('address_in', models.CharField(default='', max_length=128, null=True, verbose_name='Payment Address')),
                ('address_out', models.CharField(default='', max_length=128, null=True, verbose_name='Receiving Address')),
                ('value_requested', models.DecimalField(decimal_places=18, default=0, max_digits=65, verbose_name='Value Requested')),
                ('status', models.CharField(choices=[('created', 'Created'), ('pending', 'Pending'), ('insufficient', 'Payment Insufficient'), ('received', 'Received'), ('done', 'Done')], default='', max_length=16, null=True, verbose_name='Status')),
                ('raw_request_url', models.CharField(default='', max_length=8192, null=True, verbose_name='Request URL')),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('provider', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='blockbee.provider')),
            ],
            options={
                'unique_together': {('provider', 'order_id')},
            },
        ),
        migrations.CreateModel(
            name='RequestLog',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('raw_data', models.CharField(max_length=8192)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='blockbee.request')),
            ],
        ),
        migrations.CreateModel(
            name='PaymentLog',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('raw_data', models.CharField(max_length=8192)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('payment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='blockbee.payment')),
            ],
        ),
        migrations.AddField(
            model_name='payment',
            name='request',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='blockbee.request'),
        ),
    ]
