# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetEntityResult',
    'AwaitableGetEntityResult',
    'get_entity',
    'get_entity_output',
]

@pulumi.output_type
class GetEntityResult:
    def __init__(__self__, arn=None, components=None, creation_date_time=None, description=None, entity_name=None, has_child_entities=None, parent_entity_id=None, status=None, tags=None, update_date_time=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if components and not isinstance(components, dict):
            raise TypeError("Expected argument 'components' to be a dict")
        pulumi.set(__self__, "components", components)
        if creation_date_time and not isinstance(creation_date_time, str):
            raise TypeError("Expected argument 'creation_date_time' to be a str")
        pulumi.set(__self__, "creation_date_time", creation_date_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entity_name and not isinstance(entity_name, str):
            raise TypeError("Expected argument 'entity_name' to be a str")
        pulumi.set(__self__, "entity_name", entity_name)
        if has_child_entities and not isinstance(has_child_entities, bool):
            raise TypeError("Expected argument 'has_child_entities' to be a bool")
        pulumi.set(__self__, "has_child_entities", has_child_entities)
        if parent_entity_id and not isinstance(parent_entity_id, str):
            raise TypeError("Expected argument 'parent_entity_id' to be a str")
        pulumi.set(__self__, "parent_entity_id", parent_entity_id)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if update_date_time and not isinstance(update_date_time, str):
            raise TypeError("Expected argument 'update_date_time' to be a str")
        pulumi.set(__self__, "update_date_time", update_date_time)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the entity.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def components(self) -> Optional[Any]:
        """
        A map that sets information about a component type.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter(name="creationDateTime")
    def creation_date_time(self) -> Optional[str]:
        """
        The date and time when the entity was created.
        """
        return pulumi.get(self, "creation_date_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the entity.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> Optional[str]:
        """
        The name of the entity.
        """
        return pulumi.get(self, "entity_name")

    @property
    @pulumi.getter(name="hasChildEntities")
    def has_child_entities(self) -> Optional[bool]:
        """
        A Boolean value that specifies whether the entity has child entities or not.
        """
        return pulumi.get(self, "has_child_entities")

    @property
    @pulumi.getter(name="parentEntityId")
    def parent_entity_id(self) -> Optional[str]:
        """
        The ID of the parent entity.
        """
        return pulumi.get(self, "parent_entity_id")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.EntityStatus']:
        """
        The current status of the entity.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateDateTime")
    def update_date_time(self) -> Optional[str]:
        """
        The last date and time when the entity was updated.
        """
        return pulumi.get(self, "update_date_time")


class AwaitableGetEntityResult(GetEntityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntityResult(
            arn=self.arn,
            components=self.components,
            creation_date_time=self.creation_date_time,
            description=self.description,
            entity_name=self.entity_name,
            has_child_entities=self.has_child_entities,
            parent_entity_id=self.parent_entity_id,
            status=self.status,
            tags=self.tags,
            update_date_time=self.update_date_time)


def get_entity(entity_id: Optional[str] = None,
               workspace_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntityResult:
    """
    Resource schema for AWS::IoTTwinMaker::Entity


    :param str entity_id: The ID of the entity.
    :param str workspace_id: The ID of the workspace.
    """
    __args__ = dict()
    __args__['entityId'] = entity_id
    __args__['workspaceId'] = workspace_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:iottwinmaker:getEntity', __args__, opts=opts, typ=GetEntityResult).value

    return AwaitableGetEntityResult(
        arn=__ret__.arn,
        components=__ret__.components,
        creation_date_time=__ret__.creation_date_time,
        description=__ret__.description,
        entity_name=__ret__.entity_name,
        has_child_entities=__ret__.has_child_entities,
        parent_entity_id=__ret__.parent_entity_id,
        status=__ret__.status,
        tags=__ret__.tags,
        update_date_time=__ret__.update_date_time)


@_utilities.lift_output_func(get_entity)
def get_entity_output(entity_id: Optional[pulumi.Input[str]] = None,
                      workspace_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEntityResult]:
    """
    Resource schema for AWS::IoTTwinMaker::Entity


    :param str entity_id: The ID of the entity.
    :param str workspace_id: The ID of the workspace.
    """
    ...
