"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-kinesis';
// Definitions
const props = {
    apiGatewayProps: {
        restApiName: 'my-api',
        deployOptions: {
            methodOptions: {
                '/*/*': {
                    throttlingRateLimit: 100,
                    throttlingBurstLimit: 25
                }
            }
        }
    },
    kinesisStreamProps: {
        shardCount: 1,
        retentionPeriod: aws_cdk_lib_1.Duration.days(4)
    },
    putRecordRequestTemplate: `{ "StreamName": "\${StreamName}", "Data": "$util.base64Encode($input.json('$.foo'))", "PartitionKey": "$input.path('$.bar')" }`,
    putRecordRequestModel: { schema: {} },
    putRecordsRequestTemplate: `{ "StreamName": "\${StreamName}", "Records": [ #foreach($elem in $input.path('$.records')) { "Data": "$util.base64Encode($elem.foo)", "PartitionKey": "$elem.bar"}#if($foreach.hasNext),#end #end ] }`,
    putRecordsRequestModel: { schema: {} }
};
new lib_1.ApiGatewayToKinesisStreams(stack, 'test-apigateway-kinesis-overwrite', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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