"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 */
class ScheduledFargateTask extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.scheduledFargateTaskDefinitionOptions && props.scheduledFargateTaskImageOptions) {
            throw new Error('You must specify either a scheduledFargateTaskDefinitionOptions or scheduledFargateTaskOptions, not both.');
        }
        else if (props.scheduledFargateTaskDefinitionOptions) {
            this.taskDefinition = props.scheduledFargateTaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledFargateTaskImageOptions) {
            const taskImageOptions = props.scheduledFargateTaskImageOptions;
            this.taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'ScheduledTaskDef', {
                memoryLimitMiB: taskImageOptions.memoryLimitMiB || 512,
                cpu: taskImageOptions.cpu || 256,
            });
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: taskImageOptions.logDriver !== undefined ? taskImageOptions.logDriver : this.createAWSLogDriver(this.node.id)
            });
        }
        else {
            throw new Error('You must specify one of: taskDefinition or image');
        }
        this.addTaskDefinitionToEventTarget(this.taskDefinition);
    }
}
exports.ScheduledFargateTask = ScheduledFargateTask;
//# sourceMappingURL=data:application/json;base64,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