# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ConsulClusterArgs', 'ConsulCluster']

@pulumi.input_type
class ConsulClusterArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 hvn_id: pulumi.Input[str],
                 tier: pulumi.Input[str],
                 auto_hvn_to_hvn_peering: Optional[pulumi.Input[bool]] = None,
                 connect_enabled: Optional[pulumi.Input[bool]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 min_consul_version: Optional[pulumi.Input[str]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 size: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConsulCluster resource.
        :param pulumi.Input[str] cluster_id: The ID of the HCP Consul cluster.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Consul cluster is associated to.
        :param pulumi.Input[str] tier: The tier that the HCP Consul cluster will be provisioned as. Only `development`, `standard` and `plus` are available at
               this time. See [pricing information](https://cloud.hashicorp.com/pricing/consul).
        :param pulumi.Input[bool] auto_hvn_to_hvn_peering: Enables automatic HVN to HVN peering when creating a secondary cluster in a federation. The alternative to using the
               auto-accept feature is to create an [`hcp_hvn_peering_connection`](hvn_peering_connection.md) resource that explicitly
               defines the HVN resources that are allowed to communicate with each other.
        :param pulumi.Input[bool] connect_enabled: Denotes the Consul connect feature should be enabled for this cluster. Default to true.
        :param pulumi.Input[str] datacenter: The Consul data center name of the cluster. If not specified, it is defaulted to the value of `cluster_id`.
        :param pulumi.Input[str] min_consul_version: The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently
               recommended by HCP.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Consul cluster which is the primary in the federation setup with this HCP Consul cluster. If
               not specified, it is a standalone cluster.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint for the Consul UI. Defaults to false.
        :param pulumi.Input[str] size: The t-shirt size representation of each server VM that this Consul cluster is provisioned with. Valid option for
               development tier - `x_small`. Valid options for other tiers - `small`, `medium`, `large`. For more details -
               https://cloud.hashicorp.com/pricing/consul. Upgrading the size of a cluster after creation is allowed.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "hvn_id", hvn_id)
        pulumi.set(__self__, "tier", tier)
        if auto_hvn_to_hvn_peering is not None:
            pulumi.set(__self__, "auto_hvn_to_hvn_peering", auto_hvn_to_hvn_peering)
        if connect_enabled is not None:
            pulumi.set(__self__, "connect_enabled", connect_enabled)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if min_consul_version is not None:
            pulumi.set(__self__, "min_consul_version", min_consul_version)
        if primary_link is not None:
            pulumi.set(__self__, "primary_link", primary_link)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the HCP Consul cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="hvnId")
    def hvn_id(self) -> pulumi.Input[str]:
        """
        The ID of the HVN this HCP Consul cluster is associated to.
        """
        return pulumi.get(self, "hvn_id")

    @hvn_id.setter
    def hvn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "hvn_id", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[str]:
        """
        The tier that the HCP Consul cluster will be provisioned as. Only `development`, `standard` and `plus` are available at
        this time. See [pricing information](https://cloud.hashicorp.com/pricing/consul).
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="autoHvnToHvnPeering")
    def auto_hvn_to_hvn_peering(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automatic HVN to HVN peering when creating a secondary cluster in a federation. The alternative to using the
        auto-accept feature is to create an [`hcp_hvn_peering_connection`](hvn_peering_connection.md) resource that explicitly
        defines the HVN resources that are allowed to communicate with each other.
        """
        return pulumi.get(self, "auto_hvn_to_hvn_peering")

    @auto_hvn_to_hvn_peering.setter
    def auto_hvn_to_hvn_peering(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_hvn_to_hvn_peering", value)

    @property
    @pulumi.getter(name="connectEnabled")
    def connect_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes the Consul connect feature should be enabled for this cluster. Default to true.
        """
        return pulumi.get(self, "connect_enabled")

    @connect_enabled.setter
    def connect_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connect_enabled", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        The Consul data center name of the cluster. If not specified, it is defaulted to the value of `cluster_id`.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter(name="minConsulVersion")
    def min_consul_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently
        recommended by HCP.
        """
        return pulumi.get(self, "min_consul_version")

    @min_consul_version.setter
    def min_consul_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_consul_version", value)

    @property
    @pulumi.getter(name="primaryLink")
    def primary_link(self) -> Optional[pulumi.Input[str]]:
        """
        The `self_link` of the HCP Consul cluster which is the primary in the federation setup with this HCP Consul cluster. If
        not specified, it is a standalone cluster.
        """
        return pulumi.get(self, "primary_link")

    @primary_link.setter
    def primary_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_link", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes that the cluster has a public endpoint for the Consul UI. Defaults to false.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The t-shirt size representation of each server VM that this Consul cluster is provisioned with. Valid option for
        development tier - `x_small`. Valid options for other tiers - `small`, `medium`, `large`. For more details -
        https://cloud.hashicorp.com/pricing/consul. Upgrading the size of a cluster after creation is allowed.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class _ConsulClusterState:
    def __init__(__self__, *,
                 auto_hvn_to_hvn_peering: Optional[pulumi.Input[bool]] = None,
                 cloud_provider: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 connect_enabled: Optional[pulumi.Input[bool]] = None,
                 consul_automatic_upgrades: Optional[pulumi.Input[bool]] = None,
                 consul_ca_file: Optional[pulumi.Input[str]] = None,
                 consul_config_file: Optional[pulumi.Input[str]] = None,
                 consul_private_endpoint_url: Optional[pulumi.Input[str]] = None,
                 consul_public_endpoint_url: Optional[pulumi.Input[str]] = None,
                 consul_root_token_accessor_id: Optional[pulumi.Input[str]] = None,
                 consul_root_token_secret_id: Optional[pulumi.Input[str]] = None,
                 consul_snapshot_interval: Optional[pulumi.Input[str]] = None,
                 consul_snapshot_retention: Optional[pulumi.Input[str]] = None,
                 consul_version: Optional[pulumi.Input[str]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 hvn_id: Optional[pulumi.Input[str]] = None,
                 min_consul_version: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input[int]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConsulCluster resources.
        :param pulumi.Input[bool] auto_hvn_to_hvn_peering: Enables automatic HVN to HVN peering when creating a secondary cluster in a federation. The alternative to using the
               auto-accept feature is to create an [`hcp_hvn_peering_connection`](hvn_peering_connection.md) resource that explicitly
               defines the HVN resources that are allowed to communicate with each other.
        :param pulumi.Input[str] cloud_provider: The provider where the HCP Consul cluster is located.
        :param pulumi.Input[str] cluster_id: The ID of the HCP Consul cluster.
        :param pulumi.Input[bool] connect_enabled: Denotes the Consul connect feature should be enabled for this cluster. Default to true.
        :param pulumi.Input[bool] consul_automatic_upgrades: Denotes that automatic Consul upgrades are enabled.
        :param pulumi.Input[str] consul_ca_file: The cluster CA file encoded as a Base64 string.
        :param pulumi.Input[str] consul_config_file: The cluster config encoded as a Base64 string.
        :param pulumi.Input[str] consul_private_endpoint_url: The private URL for the Consul UI.
        :param pulumi.Input[str] consul_public_endpoint_url: The public URL for the Consul UI. This will be empty if `public_endpoint` is `false`.
        :param pulumi.Input[str] consul_root_token_accessor_id: The accessor ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using
               the `hcp_consul_root_token` resource, this field is no longer valid.
        :param pulumi.Input[str] consul_root_token_secret_id: The secret ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using the
               `hcp_consul_root_token` resource, this field is no longer valid.
        :param pulumi.Input[str] consul_snapshot_interval: The Consul snapshot interval.
        :param pulumi.Input[str] consul_snapshot_retention: The retention policy for Consul snapshots.
        :param pulumi.Input[str] consul_version: The Consul version of the cluster.
        :param pulumi.Input[str] datacenter: The Consul data center name of the cluster. If not specified, it is defaulted to the value of `cluster_id`.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Consul cluster is associated to.
        :param pulumi.Input[str] min_consul_version: The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently
               recommended by HCP.
        :param pulumi.Input[str] organization_id: The ID of the organization this HCP Consul cluster is located in.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Consul cluster which is the primary in the federation setup with this HCP Consul cluster. If
               not specified, it is a standalone cluster.
        :param pulumi.Input[str] project_id: The ID of the project this HCP Consul cluster is located in.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint for the Consul UI. Defaults to false.
        :param pulumi.Input[str] region: The region where the HCP Consul cluster is located.
        :param pulumi.Input[int] scale: The number of Consul server nodes in the cluster.
        :param pulumi.Input[str] self_link: A unique URL identifying the HCP Consul cluster.
        :param pulumi.Input[str] size: The t-shirt size representation of each server VM that this Consul cluster is provisioned with. Valid option for
               development tier - `x_small`. Valid options for other tiers - `small`, `medium`, `large`. For more details -
               https://cloud.hashicorp.com/pricing/consul. Upgrading the size of a cluster after creation is allowed.
        :param pulumi.Input[str] state: The state of the HCP Consul cluster.
        :param pulumi.Input[str] tier: The tier that the HCP Consul cluster will be provisioned as. Only `development`, `standard` and `plus` are available at
               this time. See [pricing information](https://cloud.hashicorp.com/pricing/consul).
        """
        if auto_hvn_to_hvn_peering is not None:
            pulumi.set(__self__, "auto_hvn_to_hvn_peering", auto_hvn_to_hvn_peering)
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if connect_enabled is not None:
            pulumi.set(__self__, "connect_enabled", connect_enabled)
        if consul_automatic_upgrades is not None:
            pulumi.set(__self__, "consul_automatic_upgrades", consul_automatic_upgrades)
        if consul_ca_file is not None:
            pulumi.set(__self__, "consul_ca_file", consul_ca_file)
        if consul_config_file is not None:
            pulumi.set(__self__, "consul_config_file", consul_config_file)
        if consul_private_endpoint_url is not None:
            pulumi.set(__self__, "consul_private_endpoint_url", consul_private_endpoint_url)
        if consul_public_endpoint_url is not None:
            pulumi.set(__self__, "consul_public_endpoint_url", consul_public_endpoint_url)
        if consul_root_token_accessor_id is not None:
            pulumi.set(__self__, "consul_root_token_accessor_id", consul_root_token_accessor_id)
        if consul_root_token_secret_id is not None:
            pulumi.set(__self__, "consul_root_token_secret_id", consul_root_token_secret_id)
        if consul_snapshot_interval is not None:
            pulumi.set(__self__, "consul_snapshot_interval", consul_snapshot_interval)
        if consul_snapshot_retention is not None:
            pulumi.set(__self__, "consul_snapshot_retention", consul_snapshot_retention)
        if consul_version is not None:
            pulumi.set(__self__, "consul_version", consul_version)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if hvn_id is not None:
            pulumi.set(__self__, "hvn_id", hvn_id)
        if min_consul_version is not None:
            pulumi.set(__self__, "min_consul_version", min_consul_version)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if primary_link is not None:
            pulumi.set(__self__, "primary_link", primary_link)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="autoHvnToHvnPeering")
    def auto_hvn_to_hvn_peering(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automatic HVN to HVN peering when creating a secondary cluster in a federation. The alternative to using the
        auto-accept feature is to create an [`hcp_hvn_peering_connection`](hvn_peering_connection.md) resource that explicitly
        defines the HVN resources that are allowed to communicate with each other.
        """
        return pulumi.get(self, "auto_hvn_to_hvn_peering")

    @auto_hvn_to_hvn_peering.setter
    def auto_hvn_to_hvn_peering(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_hvn_to_hvn_peering", value)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The provider where the HCP Consul cluster is located.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_provider", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the HCP Consul cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="connectEnabled")
    def connect_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes the Consul connect feature should be enabled for this cluster. Default to true.
        """
        return pulumi.get(self, "connect_enabled")

    @connect_enabled.setter
    def connect_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connect_enabled", value)

    @property
    @pulumi.getter(name="consulAutomaticUpgrades")
    def consul_automatic_upgrades(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes that automatic Consul upgrades are enabled.
        """
        return pulumi.get(self, "consul_automatic_upgrades")

    @consul_automatic_upgrades.setter
    def consul_automatic_upgrades(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consul_automatic_upgrades", value)

    @property
    @pulumi.getter(name="consulCaFile")
    def consul_ca_file(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster CA file encoded as a Base64 string.
        """
        return pulumi.get(self, "consul_ca_file")

    @consul_ca_file.setter
    def consul_ca_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_ca_file", value)

    @property
    @pulumi.getter(name="consulConfigFile")
    def consul_config_file(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster config encoded as a Base64 string.
        """
        return pulumi.get(self, "consul_config_file")

    @consul_config_file.setter
    def consul_config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_config_file", value)

    @property
    @pulumi.getter(name="consulPrivateEndpointUrl")
    def consul_private_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The private URL for the Consul UI.
        """
        return pulumi.get(self, "consul_private_endpoint_url")

    @consul_private_endpoint_url.setter
    def consul_private_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_private_endpoint_url", value)

    @property
    @pulumi.getter(name="consulPublicEndpointUrl")
    def consul_public_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The public URL for the Consul UI. This will be empty if `public_endpoint` is `false`.
        """
        return pulumi.get(self, "consul_public_endpoint_url")

    @consul_public_endpoint_url.setter
    def consul_public_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_public_endpoint_url", value)

    @property
    @pulumi.getter(name="consulRootTokenAccessorId")
    def consul_root_token_accessor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The accessor ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using
        the `hcp_consul_root_token` resource, this field is no longer valid.
        """
        return pulumi.get(self, "consul_root_token_accessor_id")

    @consul_root_token_accessor_id.setter
    def consul_root_token_accessor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_root_token_accessor_id", value)

    @property
    @pulumi.getter(name="consulRootTokenSecretId")
    def consul_root_token_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The secret ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using the
        `hcp_consul_root_token` resource, this field is no longer valid.
        """
        return pulumi.get(self, "consul_root_token_secret_id")

    @consul_root_token_secret_id.setter
    def consul_root_token_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_root_token_secret_id", value)

    @property
    @pulumi.getter(name="consulSnapshotInterval")
    def consul_snapshot_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The Consul snapshot interval.
        """
        return pulumi.get(self, "consul_snapshot_interval")

    @consul_snapshot_interval.setter
    def consul_snapshot_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_snapshot_interval", value)

    @property
    @pulumi.getter(name="consulSnapshotRetention")
    def consul_snapshot_retention(self) -> Optional[pulumi.Input[str]]:
        """
        The retention policy for Consul snapshots.
        """
        return pulumi.get(self, "consul_snapshot_retention")

    @consul_snapshot_retention.setter
    def consul_snapshot_retention(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_snapshot_retention", value)

    @property
    @pulumi.getter(name="consulVersion")
    def consul_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Consul version of the cluster.
        """
        return pulumi.get(self, "consul_version")

    @consul_version.setter
    def consul_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_version", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        The Consul data center name of the cluster. If not specified, it is defaulted to the value of `cluster_id`.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter(name="hvnId")
    def hvn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the HVN this HCP Consul cluster is associated to.
        """
        return pulumi.get(self, "hvn_id")

    @hvn_id.setter
    def hvn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hvn_id", value)

    @property
    @pulumi.getter(name="minConsulVersion")
    def min_consul_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently
        recommended by HCP.
        """
        return pulumi.get(self, "min_consul_version")

    @min_consul_version.setter
    def min_consul_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_consul_version", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the organization this HCP Consul cluster is located in.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="primaryLink")
    def primary_link(self) -> Optional[pulumi.Input[str]]:
        """
        The `self_link` of the HCP Consul cluster which is the primary in the federation setup with this HCP Consul cluster. If
        not specified, it is a standalone cluster.
        """
        return pulumi.get(self, "primary_link")

    @primary_link.setter
    def primary_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_link", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project this HCP Consul cluster is located in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes that the cluster has a public endpoint for the Consul UI. Defaults to false.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region where the HCP Consul cluster is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Consul server nodes in the cluster.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        A unique URL identifying the HCP Consul cluster.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The t-shirt size representation of each server VM that this Consul cluster is provisioned with. Valid option for
        development tier - `x_small`. Valid options for other tiers - `small`, `medium`, `large`. For more details -
        https://cloud.hashicorp.com/pricing/consul. Upgrading the size of a cluster after creation is allowed.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the HCP Consul cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier that the HCP Consul cluster will be provisioned as. Only `development`, `standard` and `plus` are available at
        this time. See [pricing information](https://cloud.hashicorp.com/pricing/consul).
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


class ConsulCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_hvn_to_hvn_peering: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 connect_enabled: Optional[pulumi.Input[bool]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 hvn_id: Optional[pulumi.Input[str]] = None,
                 min_consul_version: Optional[pulumi.Input[str]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        > Consul on Azure is now available in public beta. [Get started with end-to-end deployment configuration](https://learn.hashicorp.com/tutorials/cloud/consul-end-to-end-overview).

        The Consul cluster resource allows you to manage an HCP Consul cluster.

        ## Import

        # The import ID is {cluster_id}

        ```sh
         $ pulumi import hcp:index/consulCluster:ConsulCluster example consul-cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_hvn_to_hvn_peering: Enables automatic HVN to HVN peering when creating a secondary cluster in a federation. The alternative to using the
               auto-accept feature is to create an [`hcp_hvn_peering_connection`](hvn_peering_connection.md) resource that explicitly
               defines the HVN resources that are allowed to communicate with each other.
        :param pulumi.Input[str] cluster_id: The ID of the HCP Consul cluster.
        :param pulumi.Input[bool] connect_enabled: Denotes the Consul connect feature should be enabled for this cluster. Default to true.
        :param pulumi.Input[str] datacenter: The Consul data center name of the cluster. If not specified, it is defaulted to the value of `cluster_id`.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Consul cluster is associated to.
        :param pulumi.Input[str] min_consul_version: The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently
               recommended by HCP.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Consul cluster which is the primary in the federation setup with this HCP Consul cluster. If
               not specified, it is a standalone cluster.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint for the Consul UI. Defaults to false.
        :param pulumi.Input[str] size: The t-shirt size representation of each server VM that this Consul cluster is provisioned with. Valid option for
               development tier - `x_small`. Valid options for other tiers - `small`, `medium`, `large`. For more details -
               https://cloud.hashicorp.com/pricing/consul. Upgrading the size of a cluster after creation is allowed.
        :param pulumi.Input[str] tier: The tier that the HCP Consul cluster will be provisioned as. Only `development`, `standard` and `plus` are available at
               this time. See [pricing information](https://cloud.hashicorp.com/pricing/consul).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConsulClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > Consul on Azure is now available in public beta. [Get started with end-to-end deployment configuration](https://learn.hashicorp.com/tutorials/cloud/consul-end-to-end-overview).

        The Consul cluster resource allows you to manage an HCP Consul cluster.

        ## Import

        # The import ID is {cluster_id}

        ```sh
         $ pulumi import hcp:index/consulCluster:ConsulCluster example consul-cluster
        ```

        :param str resource_name: The name of the resource.
        :param ConsulClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsulClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_hvn_to_hvn_peering: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 connect_enabled: Optional[pulumi.Input[bool]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 hvn_id: Optional[pulumi.Input[str]] = None,
                 min_consul_version: Optional[pulumi.Input[str]] = None,
                 primary_link: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[bool]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsulClusterArgs.__new__(ConsulClusterArgs)

            __props__.__dict__["auto_hvn_to_hvn_peering"] = auto_hvn_to_hvn_peering
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["connect_enabled"] = connect_enabled
            __props__.__dict__["datacenter"] = datacenter
            if hvn_id is None and not opts.urn:
                raise TypeError("Missing required property 'hvn_id'")
            __props__.__dict__["hvn_id"] = hvn_id
            __props__.__dict__["min_consul_version"] = min_consul_version
            __props__.__dict__["primary_link"] = primary_link
            __props__.__dict__["public_endpoint"] = public_endpoint
            __props__.__dict__["size"] = size
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["cloud_provider"] = None
            __props__.__dict__["consul_automatic_upgrades"] = None
            __props__.__dict__["consul_ca_file"] = None
            __props__.__dict__["consul_config_file"] = None
            __props__.__dict__["consul_private_endpoint_url"] = None
            __props__.__dict__["consul_public_endpoint_url"] = None
            __props__.__dict__["consul_root_token_accessor_id"] = None
            __props__.__dict__["consul_root_token_secret_id"] = None
            __props__.__dict__["consul_snapshot_interval"] = None
            __props__.__dict__["consul_snapshot_retention"] = None
            __props__.__dict__["consul_version"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["scale"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
        super(ConsulCluster, __self__).__init__(
            'hcp:index/consulCluster:ConsulCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_hvn_to_hvn_peering: Optional[pulumi.Input[bool]] = None,
            cloud_provider: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            connect_enabled: Optional[pulumi.Input[bool]] = None,
            consul_automatic_upgrades: Optional[pulumi.Input[bool]] = None,
            consul_ca_file: Optional[pulumi.Input[str]] = None,
            consul_config_file: Optional[pulumi.Input[str]] = None,
            consul_private_endpoint_url: Optional[pulumi.Input[str]] = None,
            consul_public_endpoint_url: Optional[pulumi.Input[str]] = None,
            consul_root_token_accessor_id: Optional[pulumi.Input[str]] = None,
            consul_root_token_secret_id: Optional[pulumi.Input[str]] = None,
            consul_snapshot_interval: Optional[pulumi.Input[str]] = None,
            consul_snapshot_retention: Optional[pulumi.Input[str]] = None,
            consul_version: Optional[pulumi.Input[str]] = None,
            datacenter: Optional[pulumi.Input[str]] = None,
            hvn_id: Optional[pulumi.Input[str]] = None,
            min_consul_version: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            primary_link: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            public_endpoint: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            scale: Optional[pulumi.Input[int]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tier: Optional[pulumi.Input[str]] = None) -> 'ConsulCluster':
        """
        Get an existing ConsulCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_hvn_to_hvn_peering: Enables automatic HVN to HVN peering when creating a secondary cluster in a federation. The alternative to using the
               auto-accept feature is to create an [`hcp_hvn_peering_connection`](hvn_peering_connection.md) resource that explicitly
               defines the HVN resources that are allowed to communicate with each other.
        :param pulumi.Input[str] cloud_provider: The provider where the HCP Consul cluster is located.
        :param pulumi.Input[str] cluster_id: The ID of the HCP Consul cluster.
        :param pulumi.Input[bool] connect_enabled: Denotes the Consul connect feature should be enabled for this cluster. Default to true.
        :param pulumi.Input[bool] consul_automatic_upgrades: Denotes that automatic Consul upgrades are enabled.
        :param pulumi.Input[str] consul_ca_file: The cluster CA file encoded as a Base64 string.
        :param pulumi.Input[str] consul_config_file: The cluster config encoded as a Base64 string.
        :param pulumi.Input[str] consul_private_endpoint_url: The private URL for the Consul UI.
        :param pulumi.Input[str] consul_public_endpoint_url: The public URL for the Consul UI. This will be empty if `public_endpoint` is `false`.
        :param pulumi.Input[str] consul_root_token_accessor_id: The accessor ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using
               the `hcp_consul_root_token` resource, this field is no longer valid.
        :param pulumi.Input[str] consul_root_token_secret_id: The secret ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using the
               `hcp_consul_root_token` resource, this field is no longer valid.
        :param pulumi.Input[str] consul_snapshot_interval: The Consul snapshot interval.
        :param pulumi.Input[str] consul_snapshot_retention: The retention policy for Consul snapshots.
        :param pulumi.Input[str] consul_version: The Consul version of the cluster.
        :param pulumi.Input[str] datacenter: The Consul data center name of the cluster. If not specified, it is defaulted to the value of `cluster_id`.
        :param pulumi.Input[str] hvn_id: The ID of the HVN this HCP Consul cluster is associated to.
        :param pulumi.Input[str] min_consul_version: The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently
               recommended by HCP.
        :param pulumi.Input[str] organization_id: The ID of the organization this HCP Consul cluster is located in.
        :param pulumi.Input[str] primary_link: The `self_link` of the HCP Consul cluster which is the primary in the federation setup with this HCP Consul cluster. If
               not specified, it is a standalone cluster.
        :param pulumi.Input[str] project_id: The ID of the project this HCP Consul cluster is located in.
        :param pulumi.Input[bool] public_endpoint: Denotes that the cluster has a public endpoint for the Consul UI. Defaults to false.
        :param pulumi.Input[str] region: The region where the HCP Consul cluster is located.
        :param pulumi.Input[int] scale: The number of Consul server nodes in the cluster.
        :param pulumi.Input[str] self_link: A unique URL identifying the HCP Consul cluster.
        :param pulumi.Input[str] size: The t-shirt size representation of each server VM that this Consul cluster is provisioned with. Valid option for
               development tier - `x_small`. Valid options for other tiers - `small`, `medium`, `large`. For more details -
               https://cloud.hashicorp.com/pricing/consul. Upgrading the size of a cluster after creation is allowed.
        :param pulumi.Input[str] state: The state of the HCP Consul cluster.
        :param pulumi.Input[str] tier: The tier that the HCP Consul cluster will be provisioned as. Only `development`, `standard` and `plus` are available at
               this time. See [pricing information](https://cloud.hashicorp.com/pricing/consul).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConsulClusterState.__new__(_ConsulClusterState)

        __props__.__dict__["auto_hvn_to_hvn_peering"] = auto_hvn_to_hvn_peering
        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["connect_enabled"] = connect_enabled
        __props__.__dict__["consul_automatic_upgrades"] = consul_automatic_upgrades
        __props__.__dict__["consul_ca_file"] = consul_ca_file
        __props__.__dict__["consul_config_file"] = consul_config_file
        __props__.__dict__["consul_private_endpoint_url"] = consul_private_endpoint_url
        __props__.__dict__["consul_public_endpoint_url"] = consul_public_endpoint_url
        __props__.__dict__["consul_root_token_accessor_id"] = consul_root_token_accessor_id
        __props__.__dict__["consul_root_token_secret_id"] = consul_root_token_secret_id
        __props__.__dict__["consul_snapshot_interval"] = consul_snapshot_interval
        __props__.__dict__["consul_snapshot_retention"] = consul_snapshot_retention
        __props__.__dict__["consul_version"] = consul_version
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["hvn_id"] = hvn_id
        __props__.__dict__["min_consul_version"] = min_consul_version
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["primary_link"] = primary_link
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_endpoint"] = public_endpoint
        __props__.__dict__["region"] = region
        __props__.__dict__["scale"] = scale
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["size"] = size
        __props__.__dict__["state"] = state
        __props__.__dict__["tier"] = tier
        return ConsulCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoHvnToHvnPeering")
    def auto_hvn_to_hvn_peering(self) -> pulumi.Output[bool]:
        """
        Enables automatic HVN to HVN peering when creating a secondary cluster in a federation. The alternative to using the
        auto-accept feature is to create an [`hcp_hvn_peering_connection`](hvn_peering_connection.md) resource that explicitly
        defines the HVN resources that are allowed to communicate with each other.
        """
        return pulumi.get(self, "auto_hvn_to_hvn_peering")

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[str]:
        """
        The provider where the HCP Consul cluster is located.
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the HCP Consul cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="connectEnabled")
    def connect_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Denotes the Consul connect feature should be enabled for this cluster. Default to true.
        """
        return pulumi.get(self, "connect_enabled")

    @property
    @pulumi.getter(name="consulAutomaticUpgrades")
    def consul_automatic_upgrades(self) -> pulumi.Output[bool]:
        """
        Denotes that automatic Consul upgrades are enabled.
        """
        return pulumi.get(self, "consul_automatic_upgrades")

    @property
    @pulumi.getter(name="consulCaFile")
    def consul_ca_file(self) -> pulumi.Output[str]:
        """
        The cluster CA file encoded as a Base64 string.
        """
        return pulumi.get(self, "consul_ca_file")

    @property
    @pulumi.getter(name="consulConfigFile")
    def consul_config_file(self) -> pulumi.Output[str]:
        """
        The cluster config encoded as a Base64 string.
        """
        return pulumi.get(self, "consul_config_file")

    @property
    @pulumi.getter(name="consulPrivateEndpointUrl")
    def consul_private_endpoint_url(self) -> pulumi.Output[str]:
        """
        The private URL for the Consul UI.
        """
        return pulumi.get(self, "consul_private_endpoint_url")

    @property
    @pulumi.getter(name="consulPublicEndpointUrl")
    def consul_public_endpoint_url(self) -> pulumi.Output[str]:
        """
        The public URL for the Consul UI. This will be empty if `public_endpoint` is `false`.
        """
        return pulumi.get(self, "consul_public_endpoint_url")

    @property
    @pulumi.getter(name="consulRootTokenAccessorId")
    def consul_root_token_accessor_id(self) -> pulumi.Output[str]:
        """
        The accessor ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using
        the `hcp_consul_root_token` resource, this field is no longer valid.
        """
        return pulumi.get(self, "consul_root_token_accessor_id")

    @property
    @pulumi.getter(name="consulRootTokenSecretId")
    def consul_root_token_secret_id(self) -> pulumi.Output[str]:
        """
        The secret ID of the root ACL token that is generated upon cluster creation. If a new root token is generated using the
        `hcp_consul_root_token` resource, this field is no longer valid.
        """
        return pulumi.get(self, "consul_root_token_secret_id")

    @property
    @pulumi.getter(name="consulSnapshotInterval")
    def consul_snapshot_interval(self) -> pulumi.Output[str]:
        """
        The Consul snapshot interval.
        """
        return pulumi.get(self, "consul_snapshot_interval")

    @property
    @pulumi.getter(name="consulSnapshotRetention")
    def consul_snapshot_retention(self) -> pulumi.Output[str]:
        """
        The retention policy for Consul snapshots.
        """
        return pulumi.get(self, "consul_snapshot_retention")

    @property
    @pulumi.getter(name="consulVersion")
    def consul_version(self) -> pulumi.Output[str]:
        """
        The Consul version of the cluster.
        """
        return pulumi.get(self, "consul_version")

    @property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[str]:
        """
        The Consul data center name of the cluster. If not specified, it is defaulted to the value of `cluster_id`.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="hvnId")
    def hvn_id(self) -> pulumi.Output[str]:
        """
        The ID of the HVN this HCP Consul cluster is associated to.
        """
        return pulumi.get(self, "hvn_id")

    @property
    @pulumi.getter(name="minConsulVersion")
    def min_consul_version(self) -> pulumi.Output[Optional[str]]:
        """
        The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently
        recommended by HCP.
        """
        return pulumi.get(self, "min_consul_version")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The ID of the organization this HCP Consul cluster is located in.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="primaryLink")
    def primary_link(self) -> pulumi.Output[Optional[str]]:
        """
        The `self_link` of the HCP Consul cluster which is the primary in the federation setup with this HCP Consul cluster. If
        not specified, it is a standalone cluster.
        """
        return pulumi.get(self, "primary_link")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project this HCP Consul cluster is located in.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> pulumi.Output[Optional[bool]]:
        """
        Denotes that the cluster has a public endpoint for the Consul UI. Defaults to false.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region where the HCP Consul cluster is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def scale(self) -> pulumi.Output[int]:
        """
        The number of Consul server nodes in the cluster.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        A unique URL identifying the HCP Consul cluster.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The t-shirt size representation of each server VM that this Consul cluster is provisioned with. Valid option for
        development tier - `x_small`. Valid options for other tiers - `small`, `medium`, `large`. For more details -
        https://cloud.hashicorp.com/pricing/consul. Upgrading the size of a cluster after creation is allowed.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the HCP Consul cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[str]:
        """
        The tier that the HCP Consul cluster will be provisioned as. Only `development`, `standard` and `plus` are available at
        this time. See [pricing information](https://cloud.hashicorp.com/pricing/consul).
        """
        return pulumi.get(self, "tier")

