# generated by datamodel-codegen:
#   filename:  partner_inbound_api.yaml
#   timestamp: 2022-02-24T15:29:28+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Field


class CustomParameters(BaseModel):
    """
    A JSON object depicting custom information sent by the merchant and Peach. This needs to be echoed back in the response
    """

    __root__: Optional[dict] = None


class ResultDetails(BaseModel):
    """
    Details that can help understanding the reason for error, can be empty for successful transactions.
    """

    __root__: Optional[dict] = None


class ParameterError(BaseModel):
    value: Any = Field(
        ...,
        description=(
            "The value of the parameter which failed validation. Can be any value - string, number, boolean, array or"
            " object."
        ),
    )
    name: str = Field(..., description="The name of the parameter.")
    message: str = Field(..., description="A message describing the error")


class ParameterErrors(BaseModel):
    """
    Error details of the request parameters which failed validation
    """

    __root__: List[ParameterError] = Field(
        ...,
        description="Error details of the request parameters which failed validation",
        example=[
            {"value": "null", "name": "authenticationValue", "message": "Partner API requires authenticationValue"}
        ],
    )


class Card(BaseModel):
    """
    The card data structure holds all information regarding a credit or debit card account.
    """

    bin: Optional[str] = Field(
        None, description="The first six digits of the card number.", example="455112", regex="^[\\d]{6}$"
    )
    last4Digits: Optional[str] = Field(
        None, description="Last 4 digits of the credit/debit card.", example="2315", regex="^[\\d]{4}$"
    )
    holder: Optional[str] = Field(
        None,
        description="Holder of the credit card account.",
        example="Jane Doe",
        regex="^[\\w'\\-,.][^0-9_!¡?÷?¿/\\\\+=@#$%ˆ&*(){}|~<>;:[\\]]{2,127}$",
    )
    expiryMonth: Optional[str] = Field(
        None, description="The expiry month of the card.", example="01", regex="^(0[1-9]|1[0-2])$"
    )
    expiryYear: Optional[str] = Field(
        None, description="The expiry year of the card.", example="2030", regex="^(20)([0-9]{2})$"
    )


class Mandate(BaseModel):
    """
    Customer mandate to bank.
    """

    dateOfSignature: Optional[str] = Field(
        None,
        description="The date the direct debit mandate was signed.",
        regex="^(19|20)([0-9]{2})-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$",
    )
    id: Optional[str] = Field(None, description="The id of the mandate for direct debit.", regex="^[a-zA-Z0-9]{35}$")
    reference: Optional[str] = Field(
        None,
        description=(
            "The mandate reference for direct debit as a contractual agreement between the creditor and the debtor."
        ),
        regex="^[a-zA-Z0-9]{32}$",
    )


class Recon(BaseModel):
    """
    The transaction reconciliation data.
    """

    ciMerchantNumber: Optional[str] = Field(
        None, description="The clearing institute merchant number.", regex="^[\\s\\S]{1,128}$"
    )
    rrn: Optional[str] = Field(None, description="The recon reference number from the bank.", regex="^[\\s\\S]{1,128}$")
    stan: Optional[str] = Field(None, description="The stan reference number from the bank.", regex="^[\\s\\S]{1,128}$")
    authCode: Optional[str] = Field(
        None, description="The auth code returned from the bank.", regex="^[\\s\\S]{1,128}$"
    )
    resultCode: Optional[str] = Field(
        None, description="The result code provided by the bank.", regex="^[\\s\\S]{1,128}$"
    )


class Amount(BaseModel):
    __root__: str = Field(
        ...,
        description="Indicates the amount of the payment request.",
        example="22.50",
        regex="^[0-9]{1,10}(\\.[0-9]{2})$",
    )


class Currency(BaseModel):
    __root__: str = Field(
        ..., description="The currency code of the payment request's amount.", example="ZAR", regex="^[A-Z]{3}$"
    )


class PaymentBrand(BaseModel):
    __root__: str = Field(
        ...,
        description="The payment brand specifies the method of payment for the request.",
        example="PartnerBrand",
        regex="^[a-zA-Z0-9_]{1,32}$",
    )


class UniqueId(BaseModel):
    __root__: str = Field(
        ...,
        description="The unique transaction ID provided by Peach.",
        example="b4508276b8d146728dac871d6f68b45d",
        regex="^[0-9a-f]{32}$",
    )


class ConnectorTxID1(BaseModel):
    __root__: str = Field(
        ...,
        description="A unique transaction identifier provided by the Partner.",
        example="8ac7a49f7921f2fd0179230196ec4bbe",
        regex="^[\\S]{1,64}$",
    )


class PaymentType(Enum):
    """
    Payment type of the transaction.
    """

    DB = "DB"
    RF = "RF"


class Code(BaseModel):
    __root__: str = Field(
        ...,
        description="The unique code that indicates the result status of the request.",
        example="800.100.153",
        regex="^([0-9]{3}.[0-9]{3}.[0-9]{3})$",
    )


class Timestamp(BaseModel):
    __root__: datetime = Field(..., description="A timestamp of the transaction", example="2021-04-23T07:41:25.519947Z")


class ClearingInstituteSessionId(BaseModel):
    __root__: str = Field(
        ...,
        description="Session ID of the transaction, provided by the Partner.",
        example="6262",
        regex="^[\\s\\S]{1,32}$",
    )


class Result(BaseModel):
    code: Code


class ErrorResponse(BaseModel):
    result: Result
    timestamp: Timestamp


class Error400Result(BaseModel):
    code: Code
    parameterErrors: ParameterErrors


class BankAccount(BaseModel):
    """
    Customer bank account details.
    """

    holder: Optional[str] = Field(None, description="Holder of the bank account.", regex="^[\\s\\S]{4,128}$")
    bankName: Optional[str] = Field(
        None, description="The name of the bank which holds the account.", regex="^[\\s\\S]{1,255}$"
    )
    number: Optional[str] = Field(
        None, description="The account number of the bank account.", regex="^[a-zA-Z0-9]{3,64}$"
    )
    iban: Optional[str] = Field(
        None,
        description="The IBAN (International Bank Account Number) associated with the bank account.",
        regex="^[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{11,27}$",
    )
    bic: Optional[str] = Field(
        None,
        description="The BIC (Bank Identifier Code (SWIFT)) number of the bank account.",
        regex="^[a-zA-Z0-9]{8}|[a-zA-Z0-9]{11}$",
    )
    bankCode: Optional[str] = Field(
        None, description="The code associated with the bank account.", regex="^[a-zA-Z0-9]{1,12}$"
    )
    country: Optional[str] = Field(
        None, description="The country code of the bank account (ISO 3166-1).", regex="^[a-zA-Z]{2}$"
    )
    mandate: Optional[Mandate] = None
    transactionDueDate: Optional[str] = Field(
        None,
        description="The due date of the transaction of the direct debit.",
        regex="^(19|20)([0-9]{2})-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$",
    )


class WebhookResponse(BaseModel):
    """
    A response to the  request.
    """

    result: Result
    timestamp: Timestamp


class WebhookRequest(BaseModel):
    uniqueId: UniqueId
    amount: Amount
    currency: Currency
    paymentBrand: PaymentBrand
    paymentType: PaymentType
    customParameters: Optional[CustomParameters] = None
    clearingInstituteSessionId: Optional[ClearingInstituteSessionId] = None
    result: Result
    resultDetails: Optional[ResultDetails] = None
    connectorTxID1: ConnectorTxID1
    card: Optional[Card] = None
    recon: Optional[Recon] = None
    bankAccount: Optional[BankAccount] = None
    timestamp: Timestamp


class Error400Response(BaseModel):
    result: Error400Result
    resultDetails: Optional[ResultDetails] = None
    timestamp: Timestamp
