#! /usr/bin/env python
# -*- coding: utf-8 -*-

# Varnam constants snipped directly from varnamruby

""" Varnam constants """

VARNAM_TOKEN_VOWEL = 1
VARNAM_TOKEN_CONSONANT = 2
VARNAM_TOKEN_DEAD_CONSONANT = 3
VARNAM_TOKEN_CONSONANT_VOWEL = 4
VARNAM_TOKEN_NUMBER = 5
VARNAM_TOKEN_SYMBOL = 6
VARNAM_TOKEN_ANUSVARA = 7
VARNAM_TOKEN_VISARGA = 8
VARNAM_TOKEN_VIRAMA = 9
VARNAM_TOKEN_OTHER = 10
VARNAM_TOKEN_NON_JOINER = 11
VARNAM_TOKEN_JOINER = 12

VARNAM_MATCH_EXACT = 1
VARNAM_MATCH_POSSIBILITY = 2

VARNAM_CONFIG_USE_DEAD_CONSONANTS = 100
VARNAM_CONFIG_IGNORE_DUPLICATE_TOKEN = 101
VARNAM_CONFIG_ENABLE_SUGGESTIONS = 102
VARNAM_CONFIG_USE_INDIC_DIGITS = 103

VARNAM_LANG_CODE_HI = 1
VARNAM_LANG_CODE_BN = 2
VARNAM_LANG_CODE_GU = 3
VARNAM_LANG_CODE_OR = 4
VARNAM_LANG_CODE_TA = 5
VARNAM_LANG_CODE_TE = 6
VARNAM_LANG_CODE_KN = 7
VARNAM_LANG_CODE_ML = 8
VARNAM_LANG_CODE_UNKNOWN = -1

VARNAM_TOKEN_PRIORITY_HIGH = 1
VARNAM_TOKEN_PRIORITY_NORMAL = 0
VARNAM_TOKEN_PRIORITY_LOW = -1

VARNAM_TOKEN_ACCEPT_ALL = 0
VARNAM_TOKEN_ACCEPT_IF_STARTS_WITH = 1
VARNAM_TOKEN_ACCEPT_IF_IN_BETWEEN = 2
VARNAM_TOKEN_ACCEPT_IF_ENDS_WITH = 3

VARNAM_EXPORT_WORDS = 0
VARNAM_EXPORT_FULL = 1

LANG_CODES = {VARNAM_LANG_CODE_UNKNOWN : 'Unknown',
              VARNAM_LANG_CODE_HI : 'Hindi',
              VARNAM_LANG_CODE_BN : 'Bengali',
              VARNAM_LANG_CODE_GU : 'Gujarati',
              VARNAM_LANG_CODE_OR : 'Oriya',
              VARNAM_LANG_CODE_TA : 'Tamil',
              VARNAM_LANG_CODE_TE : 'Telugu',
              VARNAM_LANG_CODE_KN : 'Kannada',
              VARNAM_LANG_CODE_ML : 'Malayalam'}

# Result codes

VARNAM_SUCCESS = 0
VARNAM_MISUSE = 1
VARNAM_ERROR = 2
VARNAM_ARGS_ERROR = 3
VARNAM_MEMORY_ERROR = 4
VARNAM_PARTIAL_RENDERING = 5
VARNAM_STORAGE_ERROR = 6
VARNAM_INVALID_CONFIG = 7
