from ..sessioncontroll import (
    baseobj,
    strobj,
    baseobj,
    intobj,
    floatobj,
    colobj,
    relobj,
    fkyobj,
    bkrobj,
)


class RacehorseData(baseobj):
    __tablename__ = "racehorse"
    __table_args__=({"mariadb_row_format": "DYNAMIC"})
    racehorsekey = colobj(strobj, primary_key=True)
    # 親に対して
    racekey = colobj(strobj, fkyobj("bangumi.racekey"))
    # 1:1
    trainanalysis = relobj(
        "TrainAnalysisData", uselist=False, backref=bkrobj("racehorse"), innerjoin=True
    )
    trainoikiri = relobj(
        "TrainOikiriData", uselist=False, backref=bkrobj("racehorse"), innerjoin=True
    )
    horse_base = relobj(
        "HorsebaseData", uselist=False, backref=bkrobj("racehorse"), innerjoin=True
    )
    result = relobj(
        "SeisekiData", uselist=False, backref=bkrobj("racehorse"), innerjoin=False
    )
    predict = relobj(
        "PredictData", uselist=False, backref=bkrobj("racehorse"), innerjoin=False
    )
    bacode = colobj(intobj)
    year = colobj(intobj)
    kai = colobj(intobj)
    day = colobj(strobj)
    race = colobj(intobj)
    num = colobj(intobj)
    blood = colobj(intobj, fkyobj("horsebase.blood"))
    horse = colobj(strobj)
    idm = colobj(floatobj)
    jockey_score = colobj(floatobj)
    info_score = colobj(floatobj)
    yobi1 = colobj(strobj)
    yobi2 = colobj(strobj)
    yobi3 = colobj(strobj)
    sogo_score = colobj(floatobj)
    leg_type = colobj(intobj)
    distance_adjust = colobj(intobj)
    up_degree = colobj(intobj)
    routin = colobj(intobj)
    cri_odds = colobj(floatobj)
    cri_popular_order = colobj(intobj)
    cri_fukusho_odds = colobj(floatobj)
    cri_fukusho_popluar_order = colobj(intobj)
    specific_info_1 = colobj(intobj)
    specific_info_2 = colobj(intobj)
    specific_info_3 = colobj(intobj)
    specific_info_4 = colobj(intobj)
    specific_info_5 = colobj(intobj)
    sogo_info_1 = colobj(intobj)
    sogo_info_2 = colobj(intobj)
    sogo_info_3 = colobj(intobj)
    sogo_info_4 = colobj(intobj)
    sogo_info_5 = colobj(intobj)
    pop_score = colobj(floatobj)
    train_score = colobj(floatobj)
    trainer_score = colobj(floatobj)
    train_code = colobj(intobj)
    trainer_hyoka_code = colobj(intobj)
    jockey_rate_rentai = colobj(floatobj)
    gekiso_score = colobj(floatobj)
    hidume_code = colobj(intobj)
    hidume_shape = colobj(intobj)
    hidume_size = colobj(intobj)
    omotekisei_code = colobj(intobj)
    class_code = colobj(intobj)
    yobi4 = colobj(strobj)
    brinkers = colobj(strobj)
    jockey_name = colobj(strobj)
    kinryo = colobj(intobj)
    minarai = colobj(intobj)
    trainer_name = colobj(strobj)
    trainer_shozoku = colobj(strobj)
    zenso_seiseki_key_1 = colobj(strobj)
    zenso_seiseki_key_2 = colobj(strobj)
    zenso_seiseki_key_3 = colobj(strobj)
    zenso_seiseki_key_4 = colobj(strobj)
    zenso_seiseki_key_5 = colobj(strobj)
    zenso_racekey_1 = colobj(strobj)
    zenso_racekey_2 = colobj(strobj)
    zenso_racekey_3 = colobj(strobj)
    zenso_racekey_4 = colobj(strobj)
    zenso_racekey_5 = colobj(strobj)
    waku = colobj(intobj)
    yobi5 = colobj(strobj)
    sogo_shirushi = colobj(intobj)
    idm_shiruishi = colobj(intobj)
    info_shirushi = colobj(intobj)
    jockey_shirushi = colobj(intobj)
    trainer_shirushi = colobj(intobj)
    train_shirushi = colobj(intobj)
    gekiso_shirushi = colobj(intobj)
    turf_adjust_code = colobj(intobj)
    dart_adjust_code = colobj(intobj)
    jockey_code = colobj(intobj)
    trainer_code = colobj(intobj)
    yobi6 = colobj(strobj)
    kakutoku_money = colobj(intobj)
    shukaku_money = colobj(intobj)
    joken = colobj(intobj)
    ten_score = colobj(floatobj)
    pace_score = colobj(floatobj)
    up_score = colobj(floatobj)
    position_score = colobj(floatobj)
    pace_predict = colobj(strobj)
    dochu_order = colobj(intobj)
    dochu_sa = colobj(intobj)
    dochu_in_out = colobj(intobj)
    last_order = colobj(intobj)
    last_sa = colobj(intobj)
    last_in_out = colobj(intobj)
    order = colobj(intobj)
    sa = colobj(intobj)
    in_out = colobj(intobj)
    tenkai = colobj(strobj)
    distance_adjust2 = colobj(intobj)
    commit_weight = colobj(intobj)
    commit_weight_increase = colobj(intobj)
    torikeshi = colobj(intobj)
    sex = colobj(intobj)
    owner_name = colobj(strobj)
    banushikai_code = colobj(intobj)
    umakigo_code = colobj(intobj)
    gekiso_order = colobj(intobj)
    ls_score_order = colobj(intobj)
    ten_score_order = colobj(intobj)
    pace_score_order = colobj(intobj)
    up_score_order = colobj(intobj)
    position_score_order = colobj(intobj)
    expect_jokey_win_rate = colobj(floatobj)
    expect_jokey_rentai_rate = colobj(floatobj)
    yuso = colobj(strobj)
    soho = colobj(intobj)
    taikei_data = colobj(strobj)
    taikei = colobj(intobj)
    senaka = colobj(intobj)
    do = colobj(intobj)
    siri = colobj(intobj)
    tomo = colobj(intobj)
    harabukuro = colobj(intobj)
    head = colobj(intobj)
    neck = colobj(intobj)
    breast = colobj(intobj)
    shoulder = colobj(intobj)
    zencho = colobj(intobj)
    kocho = colobj(intobj)
    maehaba = colobj(intobj)
    ushirohaba = colobj(intobj)
    maetsunagi = colobj(intobj)
    ushirotsunagi = colobj(intobj)
    tail = colobj(intobj)
    furikata = colobj(intobj)
    taikei_sogo1 = colobj(intobj)
    taikei_sogo2 = colobj(intobj)
    taikei_sogo3 = colobj(intobj)
    umatokki1 = colobj(intobj)
    umatokki2 = colobj(intobj)
    umatokki3 = colobj(intobj)
    horse_start_score = colobj(floatobj)
    horse_latestart_rate = colobj(floatobj)
    sanko_zenso = colobj(intobj)
    sanko_zenso_jockey_code = colobj(strobj)
    mambaken_score = colobj(floatobj)
    mambaken_shirushi = colobj(intobj)
    kokyu_flg = colobj(intobj)
    gekiso_type = colobj(strobj)
    rest_reason_code = colobj(intobj)
    flg = colobj(strobj)
    turf_dart_steeple_flg = colobj(intobj)
    distance_flg = colobj(intobj)
    class_flg = colobj(intobj)
    tenkyu_flg = colobj(intobj)
    kyosei_flg = colobj(intobj)
    norikae_flg = colobj(intobj)
    runtimes_first_train = colobj(intobj)
    date_first_train = colobj(intobj)
    days_after_first_train = colobj(intobj)
    hobokusaki = colobj(strobj)
    hobokusaki_rank = colobj(strobj)
    trainer_rank = colobj(intobj)
