import numpy as np

import pytest
from matplotlib.transforms import Affine2D
from mpltern.ternary.tick import TernaryTick


expected = [
    ["horizontal", 180, 120, "left"  , "center_baseline"],
    ["horizontal",   0,  60, "right" , "center_baseline"],
    ["horizontal", 185, 125, "left"  , "center_baseline"],
    ["horizontal",   5,  65, "right" , "center_baseline"],
    ["horizontal", 190, 130, "left"  , "center_baseline"],
    ["horizontal",  10,  70, "right" , "center_baseline"],
    ["horizontal", 195, 135, "left"  , "center_baseline"],
    ["horizontal",  15,  75, "right" , "center_baseline"],
    ["horizontal", 200, 140, "left"  , "center_baseline"],
    ["horizontal",  20,  80, "right" , "center_baseline"],
    ["horizontal", 205, 145, "left"  , "center_baseline"],
    ["horizontal",  25,  85, "right" , "center_baseline"],
    ["horizontal", 210, 150, "left"  , "center_baseline"],
    ["horizontal",  30,  90, "right" , "center_baseline"],
    ["horizontal", 215, 155, "left"  , "baseline"       ],
    ["horizontal",  35,  95, "right" , "center_baseline"],
    ["horizontal", 220, 160, "left"  , "baseline"       ],
    ["horizontal",  40, 100, "right" , "center_baseline"],
    ["horizontal", 225, 165, "center", "bottom"         ],
    ["horizontal",  45, 105, "right" , "center_baseline"],
    ["horizontal", 230, 170, "center", "bottom"         ],
    ["horizontal",  50, 110, "right" , "center_baseline"],
    ["horizontal", 235, 175, "center", "bottom"         ],
    ["horizontal",  55, 115, "right" , "center_baseline"],
    ["horizontal", 240, 180, "center", "bottom"         ],
    ["horizontal",  60, 120, "right" , "center_baseline"],
    ["horizontal", 245, 185, "center", "bottom"         ],
    ["horizontal",  65, 125, "right" , "center_baseline"],
    ["horizontal", 250, 190, "center", "bottom"         ],
    ["horizontal",  70, 130, "right" , "center_baseline"],
    ["horizontal", 255, 195, "center", "bottom"         ],
    ["horizontal",  75, 135, "center", "top"            ],
    ["horizontal", 260, 200, "center", "bottom"         ],
    ["horizontal",  80, 140, "center", "top"            ],
    ["horizontal", 265, 205, "center", "bottom"         ],
    ["horizontal",  85, 145, "center", "top"            ],
    ["horizontal", 270, 210, "center", "bottom"         ],
    ["horizontal",  90, 150, "center", "top"            ],
    ["horizontal", 275, 215, "center", "bottom"         ],
    ["horizontal",  95, 155, "center", "top"            ],
    ["horizontal", 280, 220, "center", "bottom"         ],
    ["horizontal", 100, 160, "center", "top"            ],
    ["horizontal", 285, 225, "center", "bottom"         ],
    ["horizontal", 105, 165, "center", "top"            ],
    ["horizontal", 290, 230, "right" , "baseline"       ],
    ["horizontal", 110, 170, "center", "top"            ],
    ["horizontal", 295, 235, "right" , "baseline"       ],
    ["horizontal", 115, 175, "center", "top"            ],
    ["horizontal", 300, 240, "right" , "baseline"       ],
    ["horizontal", 120, 180, "center", "top"            ],
    ["horizontal", 305, 245, "right" , "baseline"       ],
    ["horizontal", 125, 185, "center", "top"            ],
    ["horizontal", 310, 250, "right" , "baseline"       ],
    ["horizontal", 130, 190, "center", "top"            ],
    ["horizontal", 315, 255, "right" , "baseline"       ],
    ["horizontal", 135, 195, "center", "top"            ],
    ["horizontal", 320, 260, "right" , "baseline"       ],
    ["horizontal", 140, 200, "left"  , "center_baseline"],
    ["horizontal", 325, 265, "right" , "baseline"       ],
    ["horizontal", 145, 205, "left"  , "center_baseline"],
    ["horizontal", 330, 270, "right" , "center_baseline"],
    ["horizontal", 150, 210, "left"  , "center_baseline"],
    ["horizontal", 335, 275, "right" , "center_baseline"],
    ["horizontal", 155, 215, "left"  , "center_baseline"],
    ["horizontal", 340, 280, "right" , "center_baseline"],
    ["horizontal", 160, 220, "left"  , "center_baseline"],
    ["horizontal", 345, 285, "right" , "center_baseline"],
    ["horizontal", 165, 225, "left"  , "center_baseline"],
    ["horizontal", 350, 290, "right" , "center_baseline"],
    ["horizontal", 170, 230, "left"  , "center_baseline"],
    ["horizontal", 355, 295, "right" , "center_baseline"],
    ["horizontal", 175, 235, "left"  , "center_baseline"],
    ["horizontal", 360, 300, "right" , "center_baseline"],
    ["horizontal", 180, 240, "left"  , "center_baseline"],
    ["horizontal", 365, 305, "right" , "center_baseline"],
    ["horizontal", 185, 245, "left"  , "center_baseline"],
    ["horizontal", 370, 310, "right" , "center_baseline"],
    ["horizontal", 190, 250, "left"  , "center_baseline"],
    ["horizontal", 375, 315, "right" , "center_baseline"],
    ["horizontal", 195, 255, "left"  , "center_baseline"],
    ["horizontal", 380, 320, "right" , "center_baseline"],
    ["horizontal", 200, 260, "left"  , "center_baseline"],
    ["horizontal", 385, 325, "right" , "center_baseline"],
    ["horizontal", 205, 265, "left"  , "center_baseline"],
    ["horizontal", 390, 330, "right" , "center_baseline"],
    ["horizontal", 210, 270, "left"  , "center_baseline"],
    ["horizontal", 395, 335, "right" , "center_baseline"],
    ["horizontal", 215, 275, "left"  , "baseline"       ],
    ["horizontal", 400, 340, "right" , "center_baseline"],
    ["horizontal", 220, 280, "left"  , "baseline"       ],
    ["horizontal", 405, 345, "center", "top"            ],
    ["horizontal", 225, 285, "left"  , "baseline"       ],
    ["horizontal", 410, 350, "center", "top"            ],
    ["horizontal", 230, 290, "left"  , "baseline"       ],
    ["horizontal", 415, 355, "center", "top"            ],
    ["horizontal", 235, 295, "left"  , "baseline"       ],
    ["horizontal", 420, 360, "center", "top"            ],
    ["horizontal", 240, 300, "left"  , "baseline"       ],
    ["horizontal", 425, 365, "center", "top"            ],
    ["horizontal", 245, 305, "left"  , "baseline"       ],
    ["horizontal", 430, 370, "center", "top"            ],
    ["horizontal", 250, 310, "left"  , "baseline"       ],
    ["horizontal", 435, 375, "center", "top"            ],
    ["horizontal", 255, 315, "center", "bottom"         ],
    ["horizontal", 440, 380, "center", "top"            ],
    ["horizontal", 260, 320, "center", "bottom"         ],
    ["horizontal", 445, 385, "center", "top"            ],
    ["horizontal", 265, 325, "center", "bottom"         ],
    ["horizontal", 450, 390, "center", "top"            ],
    ["horizontal", 270, 330, "center", "bottom"         ],
    ["horizontal", 455, 395, "center", "top"            ],
    ["horizontal", 275, 335, "center", "bottom"         ],
    ["horizontal", 460, 400, "center", "top"            ],
    ["horizontal", 280, 340, "center", "bottom"         ],
    ["horizontal", 465, 405, "center", "top"            ],
    ["horizontal", 285, 345, "center", "bottom"         ],
    ["horizontal", 470, 410, "left"  , "center_baseline"],
    ["horizontal", 290, 350, "center", "bottom"         ],
    ["horizontal", 475, 415, "left"  , "center_baseline"],
    ["horizontal", 295, 355, "center", "bottom"         ],
    ["horizontal", 480, 420, "left"  , "center_baseline"],
    ["horizontal", 300, 360, "center", "bottom"         ],
    ["horizontal", 485, 425, "left"  , "center_baseline"],
    ["horizontal", 305, 365, "center", "bottom"         ],
    ["horizontal", 490, 430, "left"  , "center_baseline"],
    ["horizontal", 310, 370, "center", "bottom"         ],
    ["horizontal", 495, 435, "left"  , "center_baseline"],
    ["horizontal", 315, 375, "center", "bottom"         ],
    ["horizontal", 500, 440, "left"  , "center_baseline"],
    ["horizontal", 320, 380, "right" , "baseline"       ],
    ["horizontal", 505, 445, "left"  , "center_baseline"],
    ["horizontal", 325, 385, "right" , "baseline"       ],
    ["horizontal", 510, 450, "left"  , "center_baseline"],
    ["horizontal", 330, 390, "right" , "center_baseline"],
    ["horizontal", 515, 455, "left"  , "center_baseline"],
    ["horizontal", 335, 395, "right" , "center_baseline"],
    ["horizontal", 520, 460, "left"  , "center_baseline"],
    ["horizontal", 340, 400, "right" , "center_baseline"],
    ["horizontal", 525, 465, "left"  , "center_baseline"],
    ["horizontal", 345, 405, "right" , "center_baseline"],
    ["horizontal", 530, 470, "left"  , "center_baseline"],
    ["horizontal", 350, 410, "right" , "center_baseline"],
    ["horizontal", 535, 475, "left"  , "center_baseline"],
    ["horizontal", 355, 415, "right" , "center_baseline"],
    ["tick", 180, 120, "left"  , "center_baseline"],
    ["tick",   0,  60, "right" , "center_baseline"],
    ["tick", 185, 125, "left"  , "center_baseline"],
    ["tick",   5,  65, "right" , "center_baseline"],
    ["tick", 190, 130, "left"  , "center_baseline"],
    ["tick",  10,  70, "right" , "center_baseline"],
    ["tick", 195, 135, "left"  , "center_baseline"],
    ["tick",  15,  75, "right" , "center_baseline"],
    ["tick", 200, 140, "left"  , "center_baseline"],
    ["tick",  20,  80, "right" , "center_baseline"],
    ["tick", 205, 145, "left"  , "center_baseline"],
    ["tick",  25,  85, "right" , "center_baseline"],
    ["tick", 210, 150, "left"  , "center_baseline"],
    ["tick",  30,  90, "right" , "center_baseline"],
    ["tick", 215, 155, "left"  , "center_baseline"],
    ["tick",  35,  95, "right" , "center_baseline"],
    ["tick", 220, 160, "left"  , "center_baseline"],
    ["tick",  40, 100, "right" , "center_baseline"],
    ["tick", 225, 165, "left"  , "center_baseline"],
    ["tick",  45, 105, "right" , "center_baseline"],
    ["tick", 230, 170, "left"  , "center_baseline"],
    ["tick",  50, 110, "right" , "center_baseline"],
    ["tick", 235, 175, "left"  , "center_baseline"],
    ["tick",  55, 115, "right" , "center_baseline"],
    ["tick", 240, 180, "left"  , "center_baseline"],
    ["tick",  60, 120, "right" , "center_baseline"],
    ["tick", 245, 185, "left"  , "center_baseline"],
    ["tick",  65, 125, "right" , "center_baseline"],
    ["tick", 250, 190, "left"  , "center_baseline"],
    ["tick",  70, 130, "right" , "center_baseline"],
    ["tick", 255, 195, "left"  , "center_baseline"],
    ["tick",  75, 135, "right" , "center_baseline"],
    ["tick", 260, 200, "left"  , "center_baseline"],
    ["tick",  80, 140, "right" , "center_baseline"],
    ["tick", 265, 205, "left"  , "center_baseline"],
    ["tick",  85, 145, "right" , "center_baseline"],
    ["tick", 270, 210, "left"  , "center_baseline"],
    ["tick",  90, 150, "left"  , "center_baseline"],
    ["tick", 275, 215, "right" , "center_baseline"],
    ["tick",  95, 155, "left"  , "center_baseline"],
    ["tick", 280, 220, "right" , "center_baseline"],
    ["tick", 100, 160, "left"  , "center_baseline"],
    ["tick", 285, 225, "right" , "center_baseline"],
    ["tick", 105, 165, "left"  , "center_baseline"],
    ["tick", 290, 230, "right" , "center_baseline"],
    ["tick", 110, 170, "left"  , "center_baseline"],
    ["tick", 295, 235, "right" , "center_baseline"],
    ["tick", 115, 175, "left"  , "center_baseline"],
    ["tick", 300, 240, "right" , "center_baseline"],
    ["tick", 120, 180, "left"  , "center_baseline"],
    ["tick", 305, 245, "right" , "center_baseline"],
    ["tick", 125, 185, "left"  , "center_baseline"],
    ["tick", 310, 250, "right" , "center_baseline"],
    ["tick", 130, 190, "left"  , "center_baseline"],
    ["tick", 315, 255, "right" , "center_baseline"],
    ["tick", 135, 195, "left"  , "center_baseline"],
    ["tick", 320, 260, "right" , "center_baseline"],
    ["tick", 140, 200, "left"  , "center_baseline"],
    ["tick", 325, 265, "right" , "center_baseline"],
    ["tick", 145, 205, "left"  , "center_baseline"],
    ["tick", 330, 270, "right" , "center_baseline"],
    ["tick", 150, 210, "left"  , "center_baseline"],
    ["tick", 335, 275, "right" , "center_baseline"],
    ["tick", 155, 215, "left"  , "center_baseline"],
    ["tick", 340, 280, "right" , "center_baseline"],
    ["tick", 160, 220, "left"  , "center_baseline"],
    ["tick", 345, 285, "right" , "center_baseline"],
    ["tick", 165, 225, "left"  , "center_baseline"],
    ["tick", 350, 290, "right" , "center_baseline"],
    ["tick", 170, 230, "left"  , "center_baseline"],
    ["tick", 355, 295, "right" , "center_baseline"],
    ["tick", 175, 235, "left"  , "center_baseline"],
    ["tick", 360, 300, "right" , "center_baseline"],
    ["tick", 180, 240, "left"  , "center_baseline"],
    ["tick", 365, 305, "right" , "center_baseline"],
    ["tick", 185, 245, "left"  , "center_baseline"],
    ["tick", 370, 310, "right" , "center_baseline"],
    ["tick", 190, 250, "left"  , "center_baseline"],
    ["tick", 375, 315, "right" , "center_baseline"],
    ["tick", 195, 255, "left"  , "center_baseline"],
    ["tick", 380, 320, "right" , "center_baseline"],
    ["tick", 200, 260, "left"  , "center_baseline"],
    ["tick", 385, 325, "right" , "center_baseline"],
    ["tick", 205, 265, "left"  , "center_baseline"],
    ["tick", 390, 330, "right" , "center_baseline"],
    ["tick", 210, 270, "left"  , "center_baseline"],
    ["tick", 395, 335, "right" , "center_baseline"],
    ["tick", 215, 275, "left"  , "center_baseline"],
    ["tick", 400, 340, "right" , "center_baseline"],
    ["tick", 220, 280, "left"  , "center_baseline"],
    ["tick", 405, 345, "right" , "center_baseline"],
    ["tick", 225, 285, "left"  , "center_baseline"],
    ["tick", 410, 350, "right" , "center_baseline"],
    ["tick", 230, 290, "left"  , "center_baseline"],
    ["tick", 415, 355, "right" , "center_baseline"],
    ["tick", 235, 295, "left"  , "center_baseline"],
    ["tick", 420, 360, "right" , "center_baseline"],
    ["tick", 240, 300, "left"  , "center_baseline"],
    ["tick", 425, 365, "right" , "center_baseline"],
    ["tick", 245, 305, "left"  , "center_baseline"],
    ["tick", 430, 370, "right" , "center_baseline"],
    ["tick", 250, 310, "left"  , "center_baseline"],
    ["tick", 435, 375, "right" , "center_baseline"],
    ["tick", 255, 315, "left"  , "center_baseline"],
    ["tick", 440, 380, "right" , "center_baseline"],
    ["tick", 260, 320, "left"  , "center_baseline"],
    ["tick", 445, 385, "right" , "center_baseline"],
    ["tick", 265, 325, "left"  , "center_baseline"],
    ["tick", 450, 390, "left"  , "center_baseline"],
    ["tick", 270, 330, "left"  , "center_baseline"],
    ["tick", 455, 395, "left"  , "center_baseline"],
    ["tick", 275, 335, "right" , "center_baseline"],
    ["tick", 460, 400, "left"  , "center_baseline"],
    ["tick", 280, 340, "right" , "center_baseline"],
    ["tick", 465, 405, "left"  , "center_baseline"],
    ["tick", 285, 345, "right" , "center_baseline"],
    ["tick", 470, 410, "left"  , "center_baseline"],
    ["tick", 290, 350, "right" , "center_baseline"],
    ["tick", 475, 415, "left"  , "center_baseline"],
    ["tick", 295, 355, "right" , "center_baseline"],
    ["tick", 480, 420, "left"  , "center_baseline"],
    ["tick", 300, 360, "right" , "center_baseline"],
    ["tick", 485, 425, "left"  , "center_baseline"],
    ["tick", 305, 365, "right" , "center_baseline"],
    ["tick", 490, 430, "left"  , "center_baseline"],
    ["tick", 310, 370, "right" , "center_baseline"],
    ["tick", 495, 435, "left"  , "center_baseline"],
    ["tick", 315, 375, "right" , "center_baseline"],
    ["tick", 500, 440, "left"  , "center_baseline"],
    ["tick", 320, 380, "right" , "center_baseline"],
    ["tick", 505, 445, "left"  , "center_baseline"],
    ["tick", 325, 385, "right" , "center_baseline"],
    ["tick", 510, 450, "left"  , "center_baseline"],
    ["tick", 330, 390, "right" , "center_baseline"],
    ["tick", 515, 455, "left"  , "center_baseline"],
    ["tick", 335, 395, "right" , "center_baseline"],
    ["tick", 520, 460, "left"  , "center_baseline"],
    ["tick", 340, 400, "right" , "center_baseline"],
    ["tick", 525, 465, "left"  , "center_baseline"],
    ["tick", 345, 405, "right" , "center_baseline"],
    ["tick", 530, 470, "left"  , "center_baseline"],
    ["tick", 350, 410, "right" , "center_baseline"],
    ["tick", 535, 475, "left"  , "center_baseline"],
    ["tick", 355, 415, "right" , "center_baseline"],
    ["axis", 180, 120, "center", "baseline"       ],
    ["axis",   0,  60, "center", "baseline"       ],
    ["axis", 185, 125, "center", "baseline"       ],
    ["axis",   5,  65, "center", "baseline"       ],
    ["axis", 190, 130, "center", "baseline"       ],
    ["axis",  10,  70, "center", "baseline"       ],
    ["axis", 195, 135, "center", "baseline"       ],
    ["axis",  15,  75, "center", "baseline"       ],
    ["axis", 200, 140, "center", "baseline"       ],
    ["axis",  20,  80, "center", "baseline"       ],
    ["axis", 205, 145, "center", "baseline"       ],
    ["axis",  25,  85, "center", "baseline"       ],
    ["axis", 210, 150, "center", "baseline"       ],
    ["axis",  30,  90, "center", "baseline"       ],
    ["axis", 215, 155, "center", "baseline"       ],
    ["axis",  35,  95, "center", "top"            ],
    ["axis", 220, 160, "center", "baseline"       ],
    ["axis",  40, 100, "center", "top"            ],
    ["axis", 225, 165, "center", "baseline"       ],
    ["axis",  45, 105, "center", "top"            ],
    ["axis", 230, 170, "center", "baseline"       ],
    ["axis",  50, 110, "center", "top"            ],
    ["axis", 235, 175, "center", "baseline"       ],
    ["axis",  55, 115, "center", "top"            ],
    ["axis", 240, 180, "center", "baseline"       ],
    ["axis",  60, 120, "center", "top"            ],
    ["axis", 245, 185, "center", "baseline"       ],
    ["axis",  65, 125, "center", "top"            ],
    ["axis", 250, 190, "center", "baseline"       ],
    ["axis",  70, 130, "center", "top"            ],
    ["axis", 255, 195, "center", "baseline"       ],
    ["axis",  75, 135, "center", "top"            ],
    ["axis", 260, 200, "center", "baseline"       ],
    ["axis",  80, 140, "center", "top"            ],
    ["axis", 265, 205, "center", "baseline"       ],
    ["axis",  85, 145, "center", "top"            ],
    ["axis", 270, 210, "center", "baseline"       ],
    ["axis",  90, 150, "center", "top"            ],
    ["axis", 275, 215, "center", "baseline"       ],
    ["axis",  95, 155, "center", "top"            ],
    ["axis", 280, 220, "center", "baseline"       ],
    ["axis", 100, 160, "center", "top"            ],
    ["axis", 285, 225, "center", "baseline"       ],
    ["axis", 105, 165, "center", "top"            ],
    ["axis", 290, 230, "center", "baseline"       ],
    ["axis", 110, 170, "center", "top"            ],
    ["axis", 295, 235, "center", "baseline"       ],
    ["axis", 115, 175, "center", "top"            ],
    ["axis", 300, 240, "center", "baseline"       ],
    ["axis", 120, 180, "center", "top"            ],
    ["axis", 305, 245, "center", "baseline"       ],
    ["axis", 125, 185, "center", "top"            ],
    ["axis", 310, 250, "center", "baseline"       ],
    ["axis", 130, 190, "center", "top"            ],
    ["axis", 315, 255, "center", "baseline"       ],
    ["axis", 135, 195, "center", "top"            ],
    ["axis", 320, 260, "center", "baseline"       ],
    ["axis", 140, 200, "center", "top"            ],
    ["axis", 325, 265, "center", "baseline"       ],
    ["axis", 145, 205, "center", "top"            ],
    ["axis", 330, 270, "center", "baseline"       ],
    ["axis", 150, 210, "center", "top"            ],
    ["axis", 335, 275, "center", "top"            ],
    ["axis", 155, 215, "center", "top"            ],
    ["axis", 340, 280, "center", "top"            ],
    ["axis", 160, 220, "center", "top"            ],
    ["axis", 345, 285, "center", "top"            ],
    ["axis", 165, 225, "center", "top"            ],
    ["axis", 350, 290, "center", "top"            ],
    ["axis", 170, 230, "center", "top"            ],
    ["axis", 355, 295, "center", "top"            ],
    ["axis", 175, 235, "center", "top"            ],
    ["axis", 360, 300, "center", "top"            ],
    ["axis", 180, 240, "center", "top"            ],
    ["axis", 365, 305, "center", "top"            ],
    ["axis", 185, 245, "center", "top"            ],
    ["axis", 370, 310, "center", "top"            ],
    ["axis", 190, 250, "center", "top"            ],
    ["axis", 375, 315, "center", "top"            ],
    ["axis", 195, 255, "center", "top"            ],
    ["axis", 380, 320, "center", "top"            ],
    ["axis", 200, 260, "center", "top"            ],
    ["axis", 385, 325, "center", "top"            ],
    ["axis", 205, 265, "center", "top"            ],
    ["axis", 390, 330, "center", "top"            ],
    ["axis", 210, 270, "center", "baseline"       ],
    ["axis", 395, 335, "center", "top"            ],
    ["axis", 215, 275, "center", "baseline"       ],
    ["axis", 400, 340, "center", "top"            ],
    ["axis", 220, 280, "center", "baseline"       ],
    ["axis", 405, 345, "center", "top"            ],
    ["axis", 225, 285, "center", "baseline"       ],
    ["axis", 410, 350, "center", "top"            ],
    ["axis", 230, 290, "center", "baseline"       ],
    ["axis", 415, 355, "center", "top"            ],
    ["axis", 235, 295, "center", "baseline"       ],
    ["axis", 420, 360, "center", "top"            ],
    ["axis", 240, 300, "center", "baseline"       ],
    ["axis", 425, 365, "center", "top"            ],
    ["axis", 245, 305, "center", "baseline"       ],
    ["axis", 430, 370, "center", "top"            ],
    ["axis", 250, 310, "center", "baseline"       ],
    ["axis", 435, 375, "center", "top"            ],
    ["axis", 255, 315, "center", "baseline"       ],
    ["axis", 440, 380, "center", "top"            ],
    ["axis", 260, 320, "center", "baseline"       ],
    ["axis", 445, 385, "center", "top"            ],
    ["axis", 265, 325, "center", "baseline"       ],
    ["axis", 450, 390, "center", "top"            ],
    ["axis", 270, 330, "center", "baseline"       ],
    ["axis", 455, 395, "center", "top"            ],
    ["axis", 275, 335, "center", "baseline"       ],
    ["axis", 460, 400, "center", "top"            ],
    ["axis", 280, 340, "center", "baseline"       ],
    ["axis", 465, 405, "center", "top"            ],
    ["axis", 285, 345, "center", "baseline"       ],
    ["axis", 470, 410, "center", "top"            ],
    ["axis", 290, 350, "center", "baseline"       ],
    ["axis", 475, 415, "center", "top"            ],
    ["axis", 295, 355, "center", "baseline"       ],
    ["axis", 480, 420, "center", "top"            ],
    ["axis", 300, 360, "center", "baseline"       ],
    ["axis", 485, 425, "center", "top"            ],
    ["axis", 305, 365, "center", "baseline"       ],
    ["axis", 490, 430, "center", "top"            ],
    ["axis", 310, 370, "center", "baseline"       ],
    ["axis", 495, 435, "center", "top"            ],
    ["axis", 315, 375, "center", "baseline"       ],
    ["axis", 500, 440, "center", "top"            ],
    ["axis", 320, 380, "center", "baseline"       ],
    ["axis", 505, 445, "center", "top"            ],
    ["axis", 325, 385, "center", "baseline"       ],
    ["axis", 510, 450, "center", "baseline"       ],
    ["axis", 330, 390, "center", "baseline"       ],
    ["axis", 515, 455, "center", "baseline"       ],
    ["axis", 335, 395, "center", "baseline"       ],
    ["axis", 520, 460, "center", "baseline"       ],
    ["axis", 340, 400, "center", "baseline"       ],
    ["axis", 525, 465, "center", "baseline"       ],
    ["axis", 345, 405, "center", "baseline"       ],
    ["axis", 530, 470, "center", "baseline"       ],
    ["axis", 350, 410, "center", "baseline"       ],
    ["axis", 535, 475, "center", "baseline"       ],
    ["axis", 355, 415, "center", "baseline"       ],
]


class DummyAxes:
    corners = None
    _labelrotation = None


class DummyTernaryTick:
    tick_name = 'ttick'
    axes = DummyAxes


def _create_tick(rotation):
    xmin = 0.5 - 1.0 / np.sqrt(3.0)
    xmax = 0.5 + 1.0 / np.sqrt(3.0)
    corners = np.array([(0.5, 1.0), (xmin, 0.0), (xmax, 0.0)])
    self = DummyTernaryTick()
    self.axes.corners = Affine2D().rotate_deg(rotation).transform(corners)
    return self


@pytest.mark.parametrize('mode,tick_angle,axis_angle,ha_ref,va_ref', expected)
def test_tick_anchor(mode, tick_angle, axis_angle, ha_ref, va_ref):
    rotation = tick_angle - 180 if tick_angle > axis_angle else tick_angle
    self = _create_tick(rotation)
    self._label_rotation = (mode, 0.0)
    ha, va, rotation_text = TernaryTick._determine_anchor(
        self, mode, axis_angle, tick_angle)
    assert (ha, va) == (ha_ref, va_ref)


def _create_references():
    for mode in ['horizontal', 'tick', 'axis']:
        for rotation in range(0, 360, 5):
            self = _create_tick(rotation)
            self._label_rotation = (mode, 0.0)
            for i in range(2):
                if i == 0:
                    tick_angle = rotation + 180.0
                    axis_angle = rotation + 120.0
                else:
                    tick_angle = rotation
                    axis_angle = rotation + 60.0
                ha, va, rotation_text = TernaryTick._determine_anchor(
                    self, mode, axis_angle, tick_angle)
                print('    [{:s}, {:3.0f}, {:3.0f}, {:8s}, {:17s}],'.format(
                    '"' + mode + '"',
                    tick_angle,
                    axis_angle,
                    '"' + ha+ '"',
                    '"' + va+ '"'))


if __name__ == '__main__':
    _create_references()
