"""Add schedule item table

Revision ID: e29638428dfd
Revises: 003be8a91001
Create Date: 2019-07-08 18:18:59.215220

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = 'e29638428dfd'
down_revision = '003be8a91001'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('schedule_item',
    sa.Column('id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('start_date', sa.Date(), nullable=True),
    sa.Column('end_date', sa.Date(), nullable=True),
    sa.Column('project_id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=True),
    sa.Column('task_type_id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=True),
    sa.Column('entity_id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=True),
    sa.ForeignKeyConstraint(['entity_id'], ['task_type.id'], ),
    sa.ForeignKeyConstraint(['project_id'], ['project.id'], ),
    sa.ForeignKeyConstraint(['task_type_id'], ['task_type.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_schedule_item_entity_id'), 'schedule_item', ['entity_id'], unique=False)
    op.create_index(op.f('ix_schedule_item_project_id'), 'schedule_item', ['project_id'], unique=False)
    op.create_index(op.f('ix_schedule_item_task_type_id'), 'schedule_item', ['task_type_id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_schedule_item_task_type_id'), table_name='schedule_item')
    op.drop_index(op.f('ix_schedule_item_project_id'), table_name='schedule_item')
    op.drop_index(op.f('ix_schedule_item_entity_id'), table_name='schedule_item')
    op.drop_table('schedule_item')
    # ### end Alembic commands ###
