"""add project id to events

Revision ID: 82e7f7a95e84
Revises: 5e2ce62632a6
Create Date: 2020-09-18 12:26:58.248230

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = '82e7f7a95e84'
down_revision = '5e2ce62632a6'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('api_event', sa.Column('project_id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=True))
    op.create_index(op.f('ix_api_event_project_id'), 'api_event', ['project_id'], unique=False)
    op.create_foreign_key(None, 'api_event', 'project', ['project_id'], ['id'])
    op.create_index(op.f('ix_entity_link_entity_in_id'), 'entity_link', ['entity_in_id'], unique=False)
    op.create_index(op.f('ix_entity_link_entity_out_id'), 'entity_link', ['entity_out_id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_entity_link_entity_out_id'), table_name='entity_link')
    op.drop_index(op.f('ix_entity_link_entity_in_id'), table_name='entity_link')
    op.drop_constraint(None, 'api_event', type_='foreignkey')
    op.drop_index(op.f('ix_api_event_project_id'), table_name='api_event')
    op.drop_column('api_event', 'project_id')
    # ### end Alembic commands ###
