nbdev_cards
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

A deck of cards demo of [nbdev](https://nbdev.fast.ai) based on ideas
from “Think Python 2nd Edition” by Allen B. Downey.

## pip install

The [nbdev-cards2022](https://pypi.org/project/nbdev-cards2022/) package
was uploaded to [PyPI](https://pypi.org/) and can be easily installed
using the below command.

`pip install nbdev-cards2022`

## conda install

The [nbdev-cards2022](https://anaconda.org/hdocmsu/nbdev-cards2022) was
also uploaded to [Anaconda](https://anaconda.org/) and can be installed
using the below command.

`conda install -c hdocmsu nbdev-cards2022`

## How to use

import the card and deck modules

``` python
from nbdev_cards.card import *
from nbdev_cards.deck import *
```

This lib provids a
[`Card`](https://hdocmsu.github.io/nbdev_cards/card.html#card) class
that you can use to create, display, and compare playing cards.

``` python
Card(2,3)
```

    3♥

display all suits

``` python
suits
```

    ['♣', '♦', '♥', '♠']

display all ranks

``` python
ranks
```

    [None, 'A', '2', '3', '4', '5', '6', '7', '8', '9', '10', 'J', 'Q', 'K']

[`Deck`](https://hdocmsu.github.io/nbdev_cards/deck.html#deck) class can
be called to generate a deck of playing card. Initially, the deck is
ordered.

``` python
deck = Deck()
deck
```

    A♣; 2♣; 3♣; 4♣; 5♣; 6♣; 7♣; 8♣; 9♣; 10♣; J♣; Q♣; K♣; A♦; 2♦; 3♦; 4♦; 5♦; 6♦; 7♦; 8♦; 9♦; 10♦; J♦; Q♦; K♦; A♥; 2♥; 3♥; 4♥; 5♥; 6♥; 7♥; 8♥; 9♥; 10♥; J♥; Q♥; K♥; A♠; 2♠; 3♠; 4♠; 5♠; 6♠; 7♠; 8♠; 9♠; 10♠; J♠; Q♠; K♠

`shuffle()` method could be used to shuffle the deck.

``` python
deck.shuffle()
deck
```

    Q♥; 6♥; 4♥; Q♣; 8♥; K♣; A♦; Q♠; 7♠; 5♦; J♣; J♥; 6♠; A♣; 9♥; 9♣; J♠; A♠; 10♥; 3♥; 7♦; K♠; 4♠; 2♦; 5♠; K♦; 10♣; 5♣; 4♦; 8♣; 7♣; 10♠; Q♦; K♥; A♥; 7♥; 6♦; 3♠; 3♦; 9♦; 4♣; 6♣; 3♣; 8♦; 5♥; 9♠; 10♦; 2♠; J♦; 8♠; 2♥; 2♣

`draw_n()` function can be used to draw n card with or without
replacement.

let’s draw 10 cards with replacement.

``` python
draw_n(10, replace=True)
```

    [10♦, 3♣, 6♦, Q♦, 3♥, K♠, 4♣, K♣, 3♣, 2♦]

now let’s draw 10 cards without replacement.

``` python
draw_n(10, replace=False)
```

    [Q♣, A♥, A♦, J♦, 2♦, 5♠, 8♦, J♥, 5♣, 3♠]

**Example**: One can draw two sets of cards each set contains four cards
and compare to see which one has higher rank.

## Developer install

If you want to develop nbdev_cards yourself, please use an editable
installation of nbdev_cards.

`git clone https://github.com/hdocmsu/nbdev_cards.git`

`pip install -e "nbdev_cards[dev]"`

You also need to use an editable installation of
[nbdev](https://github.com/fastai/nbdev),
[fastcore](https://github.com/fastai/fastcore), and
[excnb](https://github.com/fastai/execnb).

Happy Coding!!!
