import { ConcreteWidget } from './widget';
/**
 * Properties for a Text widget.
 *
 * @stability stable
 */
export interface TextWidgetProps {
    /**
     * The text to display, in MarkDown format.
     *
     * @stability stable
     */
    readonly markdown: string;
    /**
     * Width of the widget, in a grid of 24 units wide.
     *
     * @default 6
     * @stability stable
     */
    readonly width?: number;
    /**
     * Height of the widget.
     *
     * @default 2
     * @stability stable
     */
    readonly height?: number;
}
/**
 * A dashboard widget that displays MarkDown.
 *
 * @stability stable
 */
export declare class TextWidget extends ConcreteWidget {
    private readonly markdown;
    /**
     * @stability stable
     */
    constructor(props: TextWidgetProps);
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson(): any[];
}
