# Generated by Django 3.2.7 on 2021-10-12 07:35

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import wagtail.core.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0062_comment_models_and_pagesubscription'),
    ]

    operations = [
        migrations.CreateModel(
            name='Map',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30, verbose_name='name')),
                ('center_latitude', models.DecimalField(decimal_places=4, max_digits=7, verbose_name="center point's latitude")),
                ('center_longitude', models.DecimalField(decimal_places=4, max_digits=7, verbose_name="center point's longitude")),
                ('min_zoom', models.PositiveSmallIntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(20)], verbose_name='minimum zoom level')),
                ('max_zoom', models.PositiveSmallIntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(20)], verbose_name='maximum zoom level')),
            ],
            options={
                'verbose_name': 'map',
                'verbose_name_plural': 'maps',
            },
        ),
        migrations.CreateModel(
            name='Point',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='title')),
                ('content', wagtail.core.fields.RichTextField(blank=True, verbose_name='content')),
                ('external_link', models.URLField(blank=True, verbose_name='link to an URL')),
                ('latitude', models.DecimalField(decimal_places=4, max_digits=7, verbose_name='latitude')),
                ('longitude', models.DecimalField(decimal_places=4, max_digits=7, verbose_name='longitude')),
                ('map', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='points', to='wagtail_maps.map')),
                ('page_link', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.page', verbose_name='link to a page')),
            ],
            options={
                'verbose_name': 'point',
                'verbose_name_plural': 'points',
            },
        ),
    ]
