# This is autogenerated code. Do not modify this file directly
from __future__ import annotations

import os
import sys
from functools import cache

import pytest
from resonate.storage import (
    IPromiseStore,
    LocalPromiseStore,
    MemoryStorage,
    RemotePromiseStore,
)


@cache
def _promise_storages() -> list[IPromiseStore]:
    stores: list[IPromiseStore] = [LocalPromiseStore(MemoryStorage())]
    if os.getenv("RESONATE_STORE_URL") is not None:
        stores.append(RemotePromiseStore(url=os.environ["RESONATE_STORE_URL"]))
    return stores


@pytest.mark.parametrize("store", _promise_storages())
def test_case_0_transition_from_init_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    promise_record = store.create(
        promise_id="id0",
        ikey=None,
        strict=True,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.promise_id == "id0"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_1_transition_from_init_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    promise_record = store.create(
        promise_id="id1",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.promise_id == "id1"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_2_transition_from_init_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    promise_record = store.create(
        promise_id="id2",
        ikey="ikc",
        strict=True,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.promise_id == "id2"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_3_transition_from_init_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    promise_record = store.create(
        promise_id="id3",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.promise_id == "id3"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_4_transition_from_init_to_init_via_resolve(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(promise_id="id4", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_5_transition_from_init_to_init_via_resolve(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id5", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_6_transition_from_init_to_init_via_resolve(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id6", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_7_transition_from_init_to_init_via_resolve(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id7", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_8_transition_from_init_to_init_via_reject(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(promise_id="id8", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_9_transition_from_init_to_init_via_reject(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(promise_id="id9", ikey=None, strict=False, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_10_transition_from_init_to_init_via_reject(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id10", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_11_transition_from_init_to_init_via_reject(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id11", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_12_transition_from_init_to_init_via_cancel(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(promise_id="id12", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_13_transition_from_init_to_init_via_cancel(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id13", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_14_transition_from_init_to_init_via_cancel(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id14", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_15_transition_from_init_to_init_via_cancel(store: IPromiseStore) -> None:
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id15", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_16_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id16",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id16",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_17_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id17",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id17",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_18_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id18",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id18",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_19_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id19",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id19",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_20_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id20",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id20", ikey=None, strict=True, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id20"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_21_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id21",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id21", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id21"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_22_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id22",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id22", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id22"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_23_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id23",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id23", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id23"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_24_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id24",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id24", ikey=None, strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id24"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_25_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id25",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id25", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id25"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_26_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id26",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id26", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id26"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_27_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id27",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id27", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id27"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_28_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id28",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id28", ikey=None, strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id28"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_29_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id29",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id29", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id29"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_30_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id30",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id30", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id30"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_31_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id31",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id31", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id31"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_32_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id32",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id32",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_33_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id33",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id33",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_34_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id34",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.create(
        promise_id="id34",
        ikey="ikc",
        strict=True,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.promise_id == "id34"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_35_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id35",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.create(
        promise_id="id35",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "PENDING"
    assert promise_record.promise_id == "id35"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_36_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id36",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id36",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_37_transition_from_pending_to_pending_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id37",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id37",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_38_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id38",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id38", ikey=None, strict=True, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id38"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_39_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id39",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id39", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id39"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_40_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id40",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id40", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id40"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_41_transition_from_pending_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id41",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id41", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id41"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_42_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id42",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id42", ikey=None, strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id42"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_43_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id43",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id43", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id43"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_44_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id44",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id44", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id44"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_45_transition_from_pending_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id45",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id45", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id45"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_46_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id46",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id46", ikey=None, strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id46"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_47_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id47",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id47", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id47"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_48_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id48",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id48", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id48"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_49_transition_from_pending_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id49",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id49", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id49"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_50_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id50",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id50", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id50",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_51_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id51",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id51", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id51",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_52_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id52",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id52", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id52",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_53_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id53",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id53", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id53",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_54_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id54",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id54", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id54", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_55_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id55",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id55", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id55", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_56_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id56",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id56", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id56", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_57_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id57",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id57", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id57", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_58_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id58",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id58", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(promise_id="id58", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_59_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id59",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id59", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id59", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_60_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id60",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id60", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id60", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_61_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id61",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id61", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id61", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_62_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id62",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id62", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(promise_id="id62", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_63_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id63",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id63", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id63", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_64_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id64",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id64", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id64", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_65_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id65",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id65", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id65", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_66_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id66",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id66", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id66",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_67_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id67",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id67", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id67",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_68_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id68",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id68", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id68",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_69_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id69",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id69", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id69",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_70_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id70",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id70", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id70", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_71_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id71",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id71", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id71", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_72_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id72",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id72", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id72", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id72"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_73_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id73",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id73", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id73", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id73"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_74_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id74",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id74", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id74", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_75_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id75",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id75", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id75", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_76_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id76",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id76", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(promise_id="id76", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_77_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id77",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id77", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id77", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_78_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id78",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id78", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id78", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_79_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id79",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id79", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id79", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id79"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_80_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id80",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id80", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id80", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_81_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id81",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id81", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id81", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_82_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id82",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id82", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(promise_id="id82", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_83_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id83",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id83", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id83", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_84_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id84",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id84", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id84", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_85_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id85",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id85", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id85", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id85"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_86_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id86",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id86", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id86", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_87_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id87",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id87", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id87", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_88_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id88",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id88", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id88",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_89_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id89",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id89", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id89",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_90_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id90",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id90", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id90",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_91_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id91",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id91", ikey=None, strict=False, headers=None, data=None)
    promise_record = store.create(
        promise_id="id91",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id91"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_92_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id92",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id92", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id92",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_93_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id93",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id93", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id93",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_94_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id94",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id94", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id94", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_95_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id95",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id95", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id95", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_96_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id96",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id96", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id96", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_97_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id97",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id97", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id97", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_98_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id98",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id98", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(promise_id="id98", ikey=None, strict=True, headers=None, data=None)


@pytest.mark.parametrize("store", _promise_storages())
def test_case_99_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id99",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id99", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id99", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_100_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id100",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id100", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id100", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_101_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id101",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id101", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id101", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_102_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id102",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id102", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id102", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_103_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id103",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id103", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id103", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_104_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id104",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id104", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id104", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_105_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id105",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id105", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id105", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_106_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id106",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id106", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id106",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_107_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id107",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id107", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id107",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_108_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id108",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id108", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id108",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_109_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id109",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id109", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.create(
        promise_id="id109",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id109"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_110_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id110",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id110", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id110",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_111_transition_from_resolved_to_resolved_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id111",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id111", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id111",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_112_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id112",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id112", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id112", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_113_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id113",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id113", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id113", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_114_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id114",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id114", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id114", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id114"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_115_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id115",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id115", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id115", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id115"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_116_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id116",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id116", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id116", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_117_transition_from_resolved_to_resolved_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id117",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id117", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id117", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_118_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id118",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id118", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id118", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_119_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id119",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id119", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id119", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_120_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id120",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id120", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id120", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_121_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id121",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id121", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id121", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id121"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_122_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id122",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id122", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id122", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_123_transition_from_resolved_to_resolved_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id123",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id123", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id123", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_124_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id124",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id124", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id124", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_125_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id125",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id125", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id125", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_126_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id126",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id126", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id126", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_127_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id127",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id127", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id127", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "RESOLVED"
    assert promise_record.promise_id == "id127"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_128_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id128",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id128", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id128", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_129_transition_from_resolved_to_resolved_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id129",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.resolve(promise_id="id129", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id129", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_130_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id130",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id130", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id130",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_131_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id131",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id131", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id131",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_132_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id132",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id132", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id132",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_133_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id133",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id133", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id133",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_134_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id134",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id134", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id134", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_135_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id135",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id135", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id135", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_136_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id136",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id136", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id136", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_137_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id137",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id137", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id137", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_138_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id138",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id138", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id138", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_139_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id139",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id139", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id139", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_140_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id140",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id140", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id140", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_141_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id141",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id141", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id141", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_142_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id142",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id142", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id142", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_143_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id143",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id143", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id143", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_144_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id144",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id144", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id144", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_145_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id145",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id145", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id145", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_146_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id146",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id146", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id146",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_147_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id147",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id147", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id147",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_148_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id148",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id148", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id148",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_149_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id149",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id149", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id149",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_150_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id150",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id150", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id150", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_151_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id151",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id151", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id151", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_152_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id152",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id152", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id152", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_153_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id153",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id153", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id153", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id153"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_154_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id154",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id154", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id154", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_155_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id155",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id155", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id155", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_156_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id156",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id156", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id156", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_157_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id157",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id157", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id157", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_158_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id158",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id158", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id158", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id158"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_159_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id159",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id159", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id159", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id159"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_160_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id160",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id160", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id160", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_161_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id161",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id161", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id161", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_162_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id162",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id162", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id162", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_163_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id163",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id163", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id163", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_164_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id164",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id164", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id164", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_165_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id165",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id165", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id165", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id165"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_166_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id166",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id166", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id166", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_167_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id167",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id167", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id167", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_168_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id168",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id168", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id168",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_169_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id169",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id169", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id169",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_170_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id170",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id170", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id170",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_171_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id171",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id171", ikey=None, strict=False, headers=None, data=None)
    promise_record = store.create(
        promise_id="id171",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id171"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_172_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id172",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id172", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id172",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_173_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id173",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id173", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id173",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_174_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id174",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id174", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id174", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_175_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id175",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id175", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id175", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_176_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id176",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id176", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id176", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_177_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id177",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id177", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id177", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_178_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id178",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id178", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id178", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_179_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id179",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id179", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id179", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_180_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id180",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id180", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id180", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_181_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id181",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id181", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id181", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_182_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id182",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id182", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id182", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_183_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id183",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id183", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id183", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_184_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id184",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id184", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id184", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_185_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id185",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id185", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id185", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_186_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id186",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id186", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id186",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_187_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id187",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id187", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id187",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_188_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id188",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id188", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id188",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_189_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id189",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id189", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.create(
        promise_id="id189",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id189"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_190_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id190",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id190", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id190",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_191_transition_from_rejected_to_rejected_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id191",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id191", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id191",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_192_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id192",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id192", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id192", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_193_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id193",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id193", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id193", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_194_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id194",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id194", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id194", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_195_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id195",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id195", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id195", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id195"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_196_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id196",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id196", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id196", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_197_transition_from_rejected_to_rejected_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id197",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id197", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id197", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_198_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id198",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id198", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id198", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_199_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id199",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id199", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id199", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_200_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id200",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id200", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id200", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id200"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_201_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id201",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id201", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id201", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id201"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_202_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id202",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id202", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id202", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_203_transition_from_rejected_to_rejected_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id203",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id203", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id203", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_204_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id204",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id204", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id204", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_205_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id205",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id205", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id205", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_206_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id206",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id206", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id206", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_207_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id207",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id207", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id207", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED"
    assert promise_record.promise_id == "id207"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_208_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id208",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id208", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id208", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_209_transition_from_rejected_to_rejected_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id209",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.reject(promise_id="id209", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id209", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_210_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id210",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id210", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id210",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_211_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id211",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id211", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id211",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_212_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id212",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id212", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id212",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_213_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id213",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id213", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id213",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_214_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id214",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id214", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id214", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_215_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id215",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id215", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id215", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_216_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id216",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id216", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id216", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_217_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id217",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id217", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id217", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_218_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id218",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id218", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id218", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_219_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id219",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id219", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id219", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_220_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id220",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id220", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id220", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_221_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id221",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id221", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id221", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_222_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id222",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id222", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id222", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_223_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id223",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id223", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id223", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_224_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id224",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id224", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id224", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_225_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id225",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id225", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id225", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_226_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id226",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id226", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id226",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_227_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id227",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id227", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id227",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_228_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id228",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id228", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id228",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_229_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id229",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id229", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id229",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_230_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id230",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id230", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id230", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_231_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id231",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id231", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id231", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_232_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id232",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id232", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id232", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_233_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id233",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id233", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id233", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id233"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_234_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id234",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id234", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id234", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_235_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id235",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id235", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id235", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_236_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id236",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id236", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id236", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_237_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id237",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id237", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id237", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_238_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id238",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id238", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id238", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_239_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id239",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id239", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id239", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id239"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_240_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id240",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id240", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id240", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_241_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id241",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id241", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id241", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_242_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id242",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id242", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id242", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_243_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id243",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id243", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id243", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_244_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id244",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id244", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id244", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id244"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_245_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id245",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id245", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id245", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id245"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_246_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id246",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id246", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id246", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_247_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id247",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id247", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id247", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_248_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id248",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id248", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id248",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_249_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id249",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id249", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id249",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_250_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id250",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id250", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id250",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_251_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id251",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id251", ikey=None, strict=False, headers=None, data=None)
    promise_record = store.create(
        promise_id="id251",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id251"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_252_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id252",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id252", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id252",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_253_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id253",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id253", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id253",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_254_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id254",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id254", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id254", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_255_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id255",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id255", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id255", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_256_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id256",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id256", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id256", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_257_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id257",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id257", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id257", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_258_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id258",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id258", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id258", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_259_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id259",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id259", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id259", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_260_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id260",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id260", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id260", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_261_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id261",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id261", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id261", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_262_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id262",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id262", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id262", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_263_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id263",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id263", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id263", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_264_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id264",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id264", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id264", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_265_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id265",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id265", ikey=None, strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id265", ikey="iku", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_266_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id266",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id266", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id266",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_267_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id267",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id267", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id267",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_268_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id268",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id268", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id268",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_269_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id269",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id269", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.create(
        promise_id="id269",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id269"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_270_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id270",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id270", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id270",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_271_transition_from_canceled_to_canceled_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id271",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id271", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id271",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=sys.maxsize,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_272_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id272",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id272", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id272", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_273_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id273",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id273", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id273", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_274_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id274",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id274", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id274", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_275_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id275",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id275", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.resolve(
        promise_id="id275", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id275"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_276_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id276",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id276", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id276", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_277_transition_from_canceled_to_canceled_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id277",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id277", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id277", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_278_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id278",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id278", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id278", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_279_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id279",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id279", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id279", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_280_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id280",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id280", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id280", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_281_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id281",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id281", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.reject(
        promise_id="id281", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id281"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_282_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id282",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id282", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id282", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_283_transition_from_canceled_to_canceled_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id283",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id283", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id283", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_284_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id284",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id284", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id284", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_285_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id285",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id285", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id285", ikey=None, strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_286_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id286",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id286", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id286", ikey="iku", strict=True, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id286"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_287_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id287",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id287", ikey="iku", strict=False, headers=None, data=None)
    promise_record = store.cancel(
        promise_id="id287", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_CANCELED"
    assert promise_record.promise_id == "id287"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete == "iku"


@pytest.mark.parametrize("store", _promise_storages())
def test_case_288_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id288",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id288", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id288", ikey="iku*", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_289_transition_from_canceled_to_canceled_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id289",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=sys.maxsize,
        tags=None,
    )
    store.cancel(promise_id="id289", ikey="iku", strict=False, headers=None, data=None)
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id289", ikey="iku*", strict=False, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_290_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id290",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id290",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_291_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id291",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id291",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_292_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id292",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id292",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_293_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id293",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id293",
            ikey="ikc",
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_294_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id294",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id294", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_295_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id295",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id295", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id295"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_296_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id296",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id296", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_297_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id297",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id297", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id297"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_298_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id298",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id298", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_299_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id299",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id299", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id299"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_300_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id300",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id300", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_301_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id301",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id301", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id301"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_302_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id302",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id302", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_303_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id303",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id303", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id303"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_304_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id304",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id304", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_305_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id305",
        ikey=None,
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id305", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id305"
    assert promise_record.idempotency_key_for_create is None
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_306_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id306",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id306",
            ikey=None,
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_307_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id307",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id307",
            ikey=None,
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_308_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id308",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id308",
            ikey="ikc",
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_309_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id309",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.create(
        promise_id="id309",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id309"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_310_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id310",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id310",
            ikey="ikc*",
            strict=True,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_311_transition_from_timedout_to_timedout_via_create(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id311",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.create(
            promise_id="id311",
            ikey="ikc*",
            strict=False,
            headers=None,
            data=None,
            timeout=0,
            tags=None,
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_312_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id312",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id312", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_313_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id313",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id313", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id313"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_314_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id314",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.resolve(
            promise_id="id314", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_315_transition_from_timedout_to_timedout_via_resolve(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id315",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.resolve(
        promise_id="id315", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id315"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_316_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id316",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id316", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_317_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id317",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id317", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id317"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_318_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id318",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.reject(
            promise_id="id318", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_319_transition_from_timedout_to_timedout_via_reject(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id319",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.reject(
        promise_id="id319", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id319"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_320_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id320",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id320", ikey=None, strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_321_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id321",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id321", ikey=None, strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id321"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None


@pytest.mark.parametrize("store", _promise_storages())
def test_case_322_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id322",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    with pytest.raises(Exception):  # noqa: B017, PT011:
        store.cancel(
            promise_id="id322", ikey="iku", strict=True, headers=None, data=None
        )


@pytest.mark.parametrize("store", _promise_storages())
def test_case_323_transition_from_timedout_to_timedout_via_cancel(
    store: IPromiseStore,
) -> None:
    store.create(
        promise_id="id323",
        ikey="ikc",
        strict=False,
        headers=None,
        data=None,
        timeout=0,
        tags=None,
    )
    promise_record = store.cancel(
        promise_id="id323", ikey="iku", strict=False, headers=None, data=None
    )
    assert promise_record.state == "REJECTED_TIMEDOUT"
    assert promise_record.promise_id == "id323"
    assert promise_record.idempotency_key_for_create == "ikc"
    assert promise_record.idempotency_key_for_complete is None
