#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['weco_datascience',
 'weco_datascience.api',
 'weco_datascience.test',
 'weco_datascience.test.api']

package_data = \
{'': ['*']}

install_requires = \
['aiofile==3.1.0',
 'aiohttp[speedups]==3.6.2',
 'async-timeout==3.0.1',
 'boto3==1.12.14',
 'Pillow==7.0.0',
 'piffle==0.3.0',
 'urlpath==1.1.7',
 'elasticsearch==7.14']

extras_require = \
{'dev': ['black==19.10b0',
         'flake8==3.8.1',
         'isort==4.3.21',
         'pytest-asyncio==0.14.0']}

setup(name='weco-datascience',
      version='0.1.9',
      description='Common functionality for data science applications at Wellcome Collection',
      author='Harrison Pim',
      author_email='h.pim@wellcome.ac.uk',
      url='https://github.com/wellcomecollection/data-science',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
