# Notebooks

Exploratory and analytical data science in jupyter.

Each of the subdirectories listed here represents a distinct research project.

## Docker

For reproducibility's sake, the notebooks are containerised and orchestrated with docker. Working this way means that consistency between requirements, results etc can be guaranteed for each collaborator or reviewer.

The base image for each container is [jupyter/scipy-notebook](https://jupyter-docker-stacks.readthedocs.io/en/latest/using/selecting.html#jupyter-scipy-notebook). Additional requirements should be specified in the `requirements.in` file within each project, and will be installed when the container is built.

## Running

### Requirements & environment variables

First run this command to create a blank .env file in each of the project subdirectories and copy common requirements to all projects.

```
find * -type d -maxdepth 0 -exec cp requirements.common {} \;  -exec touch {}/.env \;
```

### Reproducing an existing project

To reproduce or modify an existing project, run:

```
docker compose up --build THE_NAME_OF_THE_PROJECT
```

### Creating a new project

Each notebook container should be isolated in its own directory, and each should contain the following:

- a `/notebooks` directory, where the `.ipynb` files are stored
- a `/src` directory, where any `.py` files containing common modules or utilities are stored
- a `/data` directory, where data outputs should be saved
- a `.env` file, for storing secrets. These will be ignored by git but passed into the container as environment variables
- a `.requirements.in` file, listing packages which will be installed when the container is built. Pinning the versions of those packages is recommended.

A new service should be added to the `docker-compose.yml` file, following the same structure as the others.
