"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsInterfaceEndpoints = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
class AwsInterfaceEndpoints extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        const endpointProps = {
            vpc: props.vpc,
            subnets: props.subnets || { subnetType: ec2.SubnetType.PRIVATE_ISOLATED },
            open: typeof props.open !== 'undefined' ? props.open : true,
            securityGroups: props.securityGroups,
        };
        this.endpointServices = services.map(service => ({
            service: service.service,
            endpoint: this.defineEndpoint(this, service.id, {
                service: service.service,
                ...endpointProps,
                exportPrefix,
            }),
        }));
    }
    static fromAttributes(scope, id, props) {
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        class Import extends aws_cdk_lib_1.Resource {
            constructor(_scope, _id) {
                super(_scope, _id);
                this.endpointServices = services.map(service => ({
                    service: service.service,
                    endpoint: ec2.InterfaceVpcEndpoint.fromInterfaceVpcEndpointAttributes(_scope, service.id, {
                        port: service.service.port,
                        vpcEndpointId: cdk.Fn.importValue(`${exportPrefix}/${service.service.name}`),
                    }),
                }));
            }
            allowDefaultPromFrom(connectable) {
                this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
            }
        }
        return new Import(scope, id);
    }
    defineEndpoint(scope, id, props) {
        const endpoint = new ec2.InterfaceVpcEndpoint(scope, id, props);
        const tags = cdk.Tags.of(endpoint);
        tags.add('Name', endpoint.node.path);
        const { exportPrefix, service } = props;
        new cdk.CfnOutput(this, `vpcEndpointId${id}`, {
            value: endpoint.vpcEndpointId,
            exportName: `${exportPrefix}/${service.name}`,
        });
        return endpoint;
    }
    allowDefaultPromFrom(connectable) {
        this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
    }
}
exports.AwsInterfaceEndpoints = AwsInterfaceEndpoints;
_a = JSII_RTTI_SYMBOL_1;
AwsInterfaceEndpoints[_a] = { fqn: "@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints", version: "0.0.4" };
AwsInterfaceEndpoints.SessionManagerConnect = [
    { id: 'Ssm', service: ec2.InterfaceVpcEndpointAwsService.SSM },
    { id: 'Ec2Messages', service: ec2.InterfaceVpcEndpointAwsService.EC2_MESSAGES },
    { id: 'SsmMessages', service: ec2.InterfaceVpcEndpointAwsService.SSM_MESSAGES },
];
//# sourceMappingURL=data:application/json;base64,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