# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['src',
 'src.stubber',
 'src.stubber.codemod',
 'src.stubber.commands',
 'src.stubber.freeze',
 'src.stubber.publish',
 'src.stubber.rst',
 'src.stubber.tools',
 'src.stubber.utils']

package_data = \
{'': ['*'],
 'src.stubber': ['data/*',
                 'minified/stubs/.git/objects/00/*',
                 'minified/stubs/.git/objects/02/*',
                 'minified/stubs/.git/objects/04/*',
                 'minified/stubs/.git/objects/05/*',
                 'minified/stubs/.git/objects/06/*',
                 'minified/stubs/.git/objects/09/*',
                 'minified/stubs/.git/objects/0b/*',
                 'minified/stubs/.git/objects/0d/*',
                 'minified/stubs/.git/objects/0f/*',
                 'minified/stubs/.git/objects/11/*',
                 'minified/stubs/.git/objects/12/*',
                 'minified/stubs/.git/objects/13/*',
                 'minified/stubs/.git/objects/16/*',
                 'minified/stubs/.git/objects/18/*',
                 'minified/stubs/.git/objects/19/*',
                 'minified/stubs/.git/objects/1a/*',
                 'minified/stubs/.git/objects/1d/*',
                 'minified/stubs/.git/objects/1f/*',
                 'minified/stubs/.git/objects/22/*',
                 'minified/stubs/.git/objects/24/*',
                 'minified/stubs/.git/objects/25/*',
                 'minified/stubs/.git/objects/26/*',
                 'minified/stubs/.git/objects/27/*',
                 'minified/stubs/.git/objects/28/*',
                 'minified/stubs/.git/objects/2a/*',
                 'minified/stubs/.git/objects/2e/*',
                 'minified/stubs/.git/objects/2f/*',
                 'minified/stubs/.git/objects/30/*',
                 'minified/stubs/.git/objects/39/*',
                 'minified/stubs/.git/objects/3a/*',
                 'minified/stubs/.git/objects/3b/*',
                 'minified/stubs/.git/objects/3d/*',
                 'minified/stubs/.git/objects/40/*',
                 'minified/stubs/.git/objects/43/*',
                 'minified/stubs/.git/objects/44/*',
                 'minified/stubs/.git/objects/45/*',
                 'minified/stubs/.git/objects/47/*',
                 'minified/stubs/.git/objects/49/*',
                 'minified/stubs/.git/objects/4b/*',
                 'minified/stubs/.git/objects/4f/*',
                 'minified/stubs/.git/objects/51/*',
                 'minified/stubs/.git/objects/52/*',
                 'minified/stubs/.git/objects/54/*',
                 'minified/stubs/.git/objects/55/*',
                 'minified/stubs/.git/objects/56/*',
                 'minified/stubs/.git/objects/57/*',
                 'minified/stubs/.git/objects/58/*',
                 'minified/stubs/.git/objects/5a/*',
                 'minified/stubs/.git/objects/5c/*',
                 'minified/stubs/.git/objects/5d/*',
                 'minified/stubs/.git/objects/5e/*',
                 'minified/stubs/.git/objects/60/*',
                 'minified/stubs/.git/objects/65/*',
                 'minified/stubs/.git/objects/66/*',
                 'minified/stubs/.git/objects/68/*',
                 'minified/stubs/.git/objects/69/*',
                 'minified/stubs/.git/objects/6b/*',
                 'minified/stubs/.git/objects/6d/*',
                 'minified/stubs/.git/objects/70/*',
                 'minified/stubs/.git/objects/73/*',
                 'minified/stubs/.git/objects/77/*',
                 'minified/stubs/.git/objects/7d/*',
                 'minified/stubs/.git/objects/7f/*',
                 'minified/stubs/.git/objects/83/*',
                 'minified/stubs/.git/objects/84/*',
                 'minified/stubs/.git/objects/85/*',
                 'minified/stubs/.git/objects/88/*',
                 'minified/stubs/.git/objects/89/*',
                 'minified/stubs/.git/objects/8b/*',
                 'minified/stubs/.git/objects/8c/*',
                 'minified/stubs/.git/objects/90/*',
                 'minified/stubs/.git/objects/94/*',
                 'minified/stubs/.git/objects/95/*',
                 'minified/stubs/.git/objects/97/*',
                 'minified/stubs/.git/objects/98/*',
                 'minified/stubs/.git/objects/9b/*',
                 'minified/stubs/.git/objects/9d/*',
                 'minified/stubs/.git/objects/9e/*',
                 'minified/stubs/.git/objects/9f/*',
                 'minified/stubs/.git/objects/a0/*',
                 'minified/stubs/.git/objects/a1/*',
                 'minified/stubs/.git/objects/a2/*',
                 'minified/stubs/.git/objects/a3/*',
                 'minified/stubs/.git/objects/a5/*',
                 'minified/stubs/.git/objects/a8/*',
                 'minified/stubs/.git/objects/a9/*',
                 'minified/stubs/.git/objects/ac/*',
                 'minified/stubs/.git/objects/ad/*',
                 'minified/stubs/.git/objects/ae/*',
                 'minified/stubs/.git/objects/b0/*',
                 'minified/stubs/.git/objects/b1/*',
                 'minified/stubs/.git/objects/b2/*',
                 'minified/stubs/.git/objects/b4/*',
                 'minified/stubs/.git/objects/b5/*',
                 'minified/stubs/.git/objects/b6/*',
                 'minified/stubs/.git/objects/ba/*',
                 'minified/stubs/.git/objects/be/*',
                 'minified/stubs/.git/objects/bf/*',
                 'minified/stubs/.git/objects/c5/*',
                 'minified/stubs/.git/objects/c7/*',
                 'minified/stubs/.git/objects/c9/*',
                 'minified/stubs/.git/objects/ca/*',
                 'minified/stubs/.git/objects/cb/*',
                 'minified/stubs/.git/objects/cc/*',
                 'minified/stubs/.git/objects/cd/*',
                 'minified/stubs/.git/objects/cf/*',
                 'minified/stubs/.git/objects/d5/*',
                 'minified/stubs/.git/objects/d6/*',
                 'minified/stubs/.git/objects/d8/*',
                 'minified/stubs/.git/objects/dd/*',
                 'minified/stubs/.git/objects/de/*',
                 'minified/stubs/.git/objects/e3/*',
                 'minified/stubs/.git/objects/e4/*',
                 'minified/stubs/.git/objects/e5/*',
                 'minified/stubs/.git/objects/e6/*',
                 'minified/stubs/.git/objects/e7/*',
                 'minified/stubs/.git/objects/e8/*',
                 'minified/stubs/.git/objects/e9/*',
                 'minified/stubs/.git/objects/ea/*',
                 'minified/stubs/.git/objects/eb/*',
                 'minified/stubs/.git/objects/ee/*',
                 'minified/stubs/.git/objects/ef/*',
                 'minified/stubs/.git/objects/f0/*',
                 'minified/stubs/.git/objects/f1/*',
                 'minified/stubs/.git/objects/f2/*',
                 'minified/stubs/.git/objects/f3/*',
                 'minified/stubs/.git/objects/f5/*',
                 'minified/stubs/.git/objects/f7/*',
                 'minified/stubs/.git/objects/f8/*',
                 'minified/stubs/.git/objects/fa/*',
                 'minified/stubs/.git/objects/fb/*',
                 'minified/stubs/.git/objects/ff/*']}

install_requires = \
['PyGithub>=1.57,<1.58',
 'autoflake>=1.7,<2.0',
 'black>=22.10,<23.0',
 'click>=8.1.3,<8.2.0',
 'libcst>=0.4.9,<0.5.0',
 'loguru>=0.6.0,<0.7.0',
 'mpy-cross==1.19.1',
 'mypy>=0.991,<0.992',
 'packaging>=21.3,<21.4',
 'pypi-simple>=1.0.0,<1.1.0',
 'pysondb-v2>=2.1.0,<2.2.0',
 'python-minifier>=2.7.0,<2.8.0',
 'requests>=2.28.0,<2.29.0',
 'tabulate>=0.9.0,<0.10.0',
 'tomli-w>=1.0.0,<1.1.0',
 'typed-config>=1.3.0,<1.4.0']

extras_require = \
{':python_version < "3.11"': ['tomli>=2.0.1,<2.1.0'],
 ':python_version < "3.8"': ['importlib-metadata>=1.0,<1.1'],
 'tools': ['esptool>=4.4,<4.5', 'pyserial>=3.5,<3.6', 'mpremote>=0.4.0']}

entry_points = \
{'console_scripts': ['pyboard = stubber.tools.pyboard:main',
                     'stubber = stubber.stubber:stubber_cli']}

setup_kwargs = {
    'name': 'micropython-stubber',
    'version': '1.11.1',
    'description': 'Tooling to create and maintain stubs for MicroPython',
    'long_description': '# Boost MicroPython productivity in VSCode\n \n  [![pypi version](https://badgen.net/pypi/v/micropython-stubber)](https://pypi.org/project/micropython-stubber/)\n  [![python versions](https://badgen.net/pypi/python/micropython-stubber)](https://badgen.net/pypi/python/micropython-stubber)\n  [![Documentation Status](https://readthedocs.org/projects/micropython-stubber/badge/?version=latest)](https://micropython-stubber.readthedocs.io/en/latest/?badge=latest "Document build status badge")\n  [![Star on GitHub](https://img.shields.io/github/stars/josverl/micropython-stubber.svg?style=social)](https://github.com/josverl/micropython-stubber/stargazers)\n  [![All Contributors](https://img.shields.io/badge/all_contributors-19-green.svg?style=flat-square)](#Contributions)\n  <!-- break -->\n  [![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/Josverl/micropython-stubber.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/Josverl/micropython-stubber/context:python)\n  [![pytest tests/common](https://github.com/Josverl/micropython-stubber/actions/workflows/pytest.yml/badge.svg)](https://github.com/Josverl/micropython-stubber/actions/workflows/pytest.yml)\n  [![codecov](https://codecov.io/gh/Josverl/micropython-stubber/branch/main/graph/badge.svg?token=WJFGMKBHOV)](https://codecov.io/gh/Josverl/micropython-stubber)\n  [![Black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/python/black "Black badge")\n  <!-- break -->\n  [![Open in VSCode](https://img.shields.io/static/v1?logo=visualstudiocode&label=&message=Open%20in%20Visual%20Studio%20Code&labelColor=2c2c32&color=007acc&logoColor=007acc\n)](https://open.vscode.dev/josverl/micropython-stubber)\n  \nThe intellisense and code linting that is so prevalent in modern editors, does not work out-of-the-gate for MicroPython projects.\nWhile the language is Python, the modules used are different from CPython , and also different ports have different modules and classes , or the same class with different parameters.\n\nWriting MicroPython code in a modern editor should not need to involve keeping a browser open to check for the exact parameters to read a sensor, light-up a led or send a network request.\n\nFortunately with some additional configuration and data, it is possible to make the editors understand your flavor of MicroPython, wether you use one of the pre-compiled firmwares, but also if you run a one-off custom firmware version.\n\n\n![demo][]]\n\nIn order to achieve this a few things are needed:\n1) Stub files for the native / enabled modules in the firmware using PEP 484 Type Hints\n2) Specific configuration of the VSCode Python extensions \n3) Specific configuration of Pylint [ Optional ]\n4) Suppression of warnings that collide with the MicroPython principals or code optimization.\n\nPlease review the documentation on [https://micropython-stubber.readthedocs.io]  \n\nWith that in place, VSCode will understand MicroPython for the most part, and help you to write code, and catch more errors before deploying it to your board. \n\nNote that the above is not limited to VSCode and pylint, but it happens to be the combination that I use. \n\nA lot of subs have already been generated and are shared on github or other means,  so it is quite likely that you can just grab a copy be be productive in a few minutes.\n\nFor now you will need to [configure this by hand](#manual-configuration), or use the [micropy cli` tool](#using-micropy-cli)\n\n1. The sister-repo [**MicroPython-stubs**][stubs-repo] contains [all stubs][all-stubs] I have collected with the help of others, and which can be used directly.\nThat repo also contains examples configuration files that can be easily adopted to your setup.\n\n2. A second repo [micropy-stubs repo][stubs-repo2] maintained by BradenM, also contains stubs, but in a structure only used and distributed by the [micropy-cli](#using-micropy-cli) tool.\nYou should use micropy-cli to consume stubs from that repo.\n\nThe (stretch) goal is to create a VSCode add-in to simplify the configuration, and allow easy switching between different firmwares and versions.\n\n\n## Install and basic usage\n\n``` sh\npip install micropython-stubber\n\n# go to your working folder \ncd my_stub_folder\nmkdir all-stubs\n\n# clone the micropython repo\'s and switch to a specific version \nstubber clone\nstubber switch --version v1.18\n\n# get the document stubs for the current version ( v1.18 )\nstubber get-docstubs\n\n# get the frozen stubs for the current version ( v1.18 )\nstubber get-frozen\n\n# get the core CPython compatibility stubs from PyPi \nstubber get-core\n\n# Update the fallback stubs\nstubber update-fallback\n\n#\nls all-stubs\ndir all-stubs\n```\n\n\n## Developing & testing \n\nThis is described in more detail in the [developing](docs/developing.md) and [testing](docs/testing.md)  documents in the docs folder.\n\n## Branch Main\nThe name of the default branch has been changed to `main`.\nIf you have cloned this repo before you main need to adjust the local repro to be aware of this, or create a fresh clone.\n\nTo update run the below command:  \n``` bash\ngit branch -m master main                    \ngit fetch origin\ngit branch -u origin/main main                      \ngit remote set-head origin -a\n```\n\nfor more info see [**Renaming a branch**](https://docs.github.com/en/repositories/configuring-branches-and-merges-in-your-repository/managing-branches-in-your-repository/renaming-a-branch#updating-a-local-clone-after-a-branch-name-changes)\n\n## Licensing \n\nMicroPython-Stubber is licensed under the MIT license, and all contributions should follow this [LICENSE](LICENSE).\n\n\n# Contributions\n<!-- spell-checker: disable -->\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://github.com/Josverl"><img src="https://avatars2.githubusercontent.com/u/981654?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jos Verlinde</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/commits?author=josverl" title="Code">💻</a> <a href="#research-josverl" title="Research">🔬</a> <a href="#ideas-josverl" title="Ideas, Planning, & Feedback">🤔</a> <a href="#content-josverl" title="Content">🖋</a> <a href="#stubs-josverl" title="MicroPython stubs">📚</a> <a href="#test-josverl" title="Test">✔</a></td>\n    <td align="center"><a href="https://thonny.org/"><img src="https://avatars1.githubusercontent.com/u/46202078?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Thonny, Python IDE for beginners</b></sub></a><br /><a href="#ideas-thonny" title="Ideas, Planning, & Feedback">🤔</a> <a href="#research-thonny" title="Research">🔬</a></td>\n    <td align="center"><a href="https://micropython.org/"><img src="https://avatars1.githubusercontent.com/u/6298560?v=4?s=100" width="100px;" alt=""/><br /><sub><b>MicroPython</b></sub></a><br /><a href="#data-micropython" title="Data">🔣</a> <a href="#stubs-micropython" title="MicroPython stubs">📚</a></td>\n    <td align="center"><a href="https://github.com/loboris"><img src="https://avatars3.githubusercontent.com/u/6280349?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Boris Lovosevic</b></sub></a><br /><a href="#data-loboris" title="Data">🔣</a> <a href="#stubs-loboris" title="MicroPython stubs">📚</a></td>\n    <td align="center"><a href="https://github.com/pfalcon"><img src="https://avatars3.githubusercontent.com/u/500451?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Paul Sokolovsky</b></sub></a><br /><a href="#data-pfalcon" title="Data">🔣</a> <a href="#stubs-pfalcon" title="MicroPython stubs">📚</a></td>\n    <td align="center"><a href="https://github.com/pycopy"><img src="https://avatars0.githubusercontent.com/u/67273174?v=4?s=100" width="100px;" alt=""/><br /><sub><b>pycopy</b></sub></a><br /><a href="#data-pycopy" title="Data">🔣</a> <a href="#stubs-pycopy" title="MicroPython stubs">📚</a></td>\n    <td align="center"><a href="https://github.com/pycom"><img src="https://avatars2.githubusercontent.com/u/16415153?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Pycom</b></sub></a><br /><a href="#infra-pycom" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/BradenM"><img src="https://avatars1.githubusercontent.com/u/5913808?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Braden Mars</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3ABradenM" title="Bug reports">🐛</a> <a href="https://github.com/Josverl/micropython-stubber/commits?author=BradenM" title="Code">💻</a> <a href="#stubs-BradenM" title="MicroPython stubs">📚</a> <a href="#platform-BradenM" title="Packaging/porting to new platform">📦</a></td>\n    <td align="center"><a href="https://binary.com.au/"><img src="https://avatars2.githubusercontent.com/u/175909?v=4?s=100" width="100px;" alt=""/><br /><sub><b>James Manners</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/commits?author=jmannau" title="Code">💻</a> <a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3Ajmannau" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="http://patrickwalters.us/"><img src="https://avatars0.githubusercontent.com/u/4002194?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Patrick</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3Aaskpatrickw" title="Bug reports">🐛</a> <a href="https://github.com/Josverl/micropython-stubber/commits?author=askpatrickw" title="Code">💻</a> <a href="#stubs-askpatrickw" title="MicroPython stubs">📚</a></td>\n    <td align="center"><a href="https://opencollective.com/pythonseverywhere"><img src="https://avatars3.githubusercontent.com/u/16009100?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Paul m. p. P.</b></sub></a><br /><a href="#ideas-pmp-p" title="Ideas, Planning, & Feedback">🤔</a> <a href="#research-pmp-p" title="Research">🔬</a></td>\n    <td align="center"><a href="https://github.com/edreamleo"><img src="https://avatars0.githubusercontent.com/u/592928?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Edward K. Ream</b></sub></a><br /><a href="#plugin-edreamleo" title="Plugin/utility libraries">🔌</a></td>\n    <td align="center"><a href="https://github.com/dastultz"><img src="https://avatars3.githubusercontent.com/u/4334042?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Daryl Stultz</b></sub></a><br /><a href="#stubs-dastultz" title="MicroPython stubs">📚</a></td>\n    <td align="center"><a href="https://github.com/cabletie"><img src="https://avatars1.githubusercontent.com/u/2356734?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Keeping things together</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3Acabletie" title="Bug reports">🐛</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/vbolshakov"><img src="https://avatars2.githubusercontent.com/u/2453324?v=4?s=100" width="100px;" alt=""/><br /><sub><b>vbolshakov</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3Avbolshakov" title="Bug reports">🐛</a> <a href="#stubs-vbolshakov" title="MicroPython stubs">📚</a></td>\n    <td align="center"><a href="https://lemariva.com/"><img src="https://avatars2.githubusercontent.com/u/15173329?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mauro Riva</b></sub></a><br /><a href="#blog-lemariva" title="Blogposts">📝</a> <a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3Alemariva" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/MathijsNL"><img src="https://avatars0.githubusercontent.com/u/1612886?v=4?s=100" width="100px;" alt=""/><br /><sub><b>MathijsNL</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3AMathijsNL" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="http://comingsoon.tm/"><img src="https://avatars0.githubusercontent.com/u/13251689?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Callum Jacob Hays</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3ACallumJHays" title="Bug reports">🐛</a> <a href="#test-CallumJHays" title="Test">✔</a></td>\n    <td align="center"><a href="https://github.com/v923z"><img src="https://avatars0.githubusercontent.com/u/1310472?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Zoltán Vörös</b></sub></a><br /><a href="#data-v923z" title="Data">🔣</a></td>\n    <td align="center"><a href="https://github.com/vincent-l-j"><img src="https://avatars.githubusercontent.com/u/20021376?v=4?s=100" width="100px;" alt=""/><br /><sub><b>vincent-l-j</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/commits?author=vincent-l-j" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/yegorLitvinov"><img src="https://avatars.githubusercontent.com/u/20367310?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Egor Litvinov</b></sub></a><br /><a href="https://github.com/Josverl/micropython-stubber/issues?q=author%3AyegorLitvinov" title="Bug reports">🐛</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n\n----------------------------\n\n--------------------------------\n\n\n\n[stubs-repo]:   https://github.com/Josverl/micropython-stubs\n[stubs-repo2]:  https://github.com/BradenM/micropy-stubs\n[micropython-stubber]: https://github.com/Josverl/micropython-stubber\n[micropython-stubs]: https://github.com/Josverl/micropython-stubs#micropython-stubs\n[micropy-cli]: https://github.com/BradenM/micropy-cli\n[using-the-stubs]: https://github.com/Josverl/micropython-stubs#using-the-stubs\n[demo]:         https://github.com/Josverl/micropython-stubber/blob/main/docs/img/demo.gif?raw=true\t"demo of writing code using the stubs"\n[stub processing order]: https://github.com/Josverl/micropython-stubber/blob/main/docs/img/stuborder_pylance.png?raw=true\t"recommended stub processing order"\n[naming-convention]: #naming-convention-and-stub-folder-structure\n[all-stubs]: https://github.com/Josverl/micropython-stubs/blob/main/firmwares.md\n[micropython]: https://github.com/micropython/micropython\n[micropython-lib]:  https://github.com/micropython/micropython-lib\n[pycopy]: https://github.com/pfalcon/pycopy\n[pycopy-lib]: https://github.com/pfalcon/pycopy-lib\n\n',
    'author': 'Jos Verlinde',
    'author_email': 'jos_verlinde@hotmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Josverl/micropython-stubber#readme',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.12',
}


setup(**setup_kwargs)
