# __init__.py - indicates that this directory is a Python package
#
# Copyright 2011 Lincoln de Sousa <lincoln@comum.org>.
# Copyright 2012, 2013, 2014, 2015, 2016 Jeffrey Finkelstein
#           <jeffrey.finkelstein@gmail.com> and contributors.
#
# This file is part of Flask-Restless.
#
# Flask-Restless is distributed under both the GNU Affero General Public
# License version 3 and under the 3-clause BSD license. For more
# information, see LICENSE.AGPL and LICENSE.BSD.
"""Serialization and deserialization for Flask-Restless."""
from .deserializers import DefaultDeserializer
from .exceptions import DeserializationException
from .exceptions import MultipleExceptions
from .exceptions import SerializationException
from .serializers import DefaultSerializer
from .serializers import JsonApiDocument
from .serializers import simple_serialize
from .serializers import simple_serialize_many
from .serializers import simple_relationship_serialize
from .serializers import simple_relationship_serialize_many

__all__ = [
    'DefaultDeserializer',
    'DefaultSerializer',
    'DeserializationException',
    'JsonApiDocument',
    'MultipleExceptions',
    'SerializationException',
    'simple_relationship_serialize',
    'simple_relationship_serialize_many',
    'simple_serialize',
    'simple_serialize_many',
]
