# pwn_gadget
Check for satisfied one gadget constraints using the state of a running gdb instance

*Required* to have the [one_gadget](https://github.com/david942j/one_gadget) tool installed and in your path, it is called via subprocess to gather the gadgets/constraints

# How does this work?
pwn_gadget parses the constraints generated by [one_gadget](https://github.com/david942j/one_gadget) in python into a format that can be evaluated by a gdb `print` command.

Leveraging the Gdb python api, accessed through pwntools' gdb module, it executes those commands parsed from the one_gadget constraints.

Performs all of the boolean operations in the one_gadget constraints on the results from the commands run in gdb.

Searches for a gadget where every boolean operation returned True, returning either that offset or None.

Regardless of if a satisfiable gadget is found or not, color coded information on the succeeding and failing constraints for each gadget will be printed.

# Usage

```python
from pwn import *
import pwn_gadget

p = process("chal")
libc = p.libc

# attach and break at the target address
_, gdb_api = gdb.attach(p, gdbscript="b *(vuln+180)", api=True)
# call pwn_gadget function to look for satisfied gadgets
gadget = pwn_gadget.find_gadget(gdb_api, libc.path)

# use found address in payload
payload = b"A"*32 + p64(gadget+libc.address)
p.sendline(payload)

p.interactive()
```

# Example Output
## Success
![Successful discovery of satisfied one gadget](static/success.png)
## Failure
![Failed discovery of satisfied one gadget](static/failure.png)