# Contributing to Paramak

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:


## Code of Conduct

This project and everyone participating in it is governed by the [Paramak Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.

## Resources

- [GitHub Repository](https://github.com/fusion-energy/paramak)
- [Documentation](http://paramak.readthedocs.io/en/latest)

## How to Report Bugs

Paramak is hosted on GitHub and all bugs are reported and tracked through the
[Issues](https://github.com/fusion-energy/paramak/issues) listed on GitHub.

## How to Suggest Enhancements

We welcome suggestions for new features or enhancements to the code and
encourage you to submit them as Issues on GitHub.

## How to Submit Changes

All changes to Paramak happen through pull requests. We use a
[simplified](https://thomaspoignant.medium.com/simple-git-flow-who-works-dac82430e484)
version of the original [GitFlow](https://nvie.com/posts/a-successful-git-branching-model/) workflow that avoids release branches.

## Code Style

We have automated PEP formatting of commits using GitHub actions so don't be
surprised if your code gets reformatted when pushing to the repository.


## Testing

We have a handful of tests that run on pull requests and new pull requests are
expected to include tests to show that the feature works. We suggest running
the tests locally before submitting a pull request.
