# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['path_tree_generator', 'path_tree_generator.models']

package_data = \
{'': ['*']}

install_requires = \
['pydantic>=1.9.1,<2.0.0']

setup_kwargs = {
    'name': 'path-tree-generator',
    'version': '0.1.0',
    'description': 'Generate tree-like directory listings for humans and output them as str, list[str], dict or json.',
    'long_description': '# path-tree-generator\n\nGenerate tree-like directory listings for humans and output them as `str`, `list[str]`, `dict` or `json`.\n\n    from path_tree_generator import PathTree\n    pt = PathTree(\'/my/path/to/generate\')\n    print(\n        pt.get_human_readable()\n    )\n\n----------------------------------------------------------------------------------------------------\n\n:warning: **This package is in Beta now and still under development!** :warning:\n\nKeep in mind that classes, methods and their signatures \nmight change anytime during development till the first official release 1.0.0.\n\nThe fist working version is released as **path-tree-generator v0.1.0** \nand contains the most base implementations.\n\nIssues and suggestions can be tracked on [GitHub][issue-tracker].\n\n----------------------------------------------------------------------------------------------------\n\n## Table of Contents\n\n- [Requirements](#requirements)\n- [Usage](#usage)\n  - [Installation](#installation)\n  - [Example](#example)\n    - [Human Readable Path Tree](#human-readable-path-tree)\n    - [Path Tree `dict`](#path-tree-dict)\n    - [Path Tree `json`](#path-tree-json)\n- [Support](#support)\n- [Contributing](#contributing)\n- [License](#license)\n- [Known Issues](#known-issues)\n\n## Requirements\n\n[Python 3.10][python]+\n\n`path-tree-generator` depends on the following packages:\n\n- [Pydantic][pydantic] for data models and validation\n\n## Usage\n\n### Installation\n\n    pip install path-tree-generator\n\n### Examples\n\nAll example are using the same instance assigned to the variable `pt` as follows:\n\n    from path_tree_generator import PathTree\n    pt = PathTree(\'/my/path/to/generate\')\n\n#### Human Readable Path Tree\n\nUsing the `PathTree` instance `pt` from the [Examples](#examples) you can simply use one of the following methods:\n\n    pt.get_human_readable()\n    pt.human_readable()\n\nThe code above returns a tree-like formatted recursive directory listing as string.\nDirectories are wrapped in square brackets, files aren\'t.\n\n    [data]\n    ├── data-with-stat.json\n    ├── data.json\n    ├── data.tree\n    ├── [myDirectory-1]\n    │   ├── myFile.txt\n    │   └── [subdirectory]\n    │       └── green.gif\n    └── [myDirectory-2]\n        ├── [subdirectory1]\n        │   └── green.gif\n        └── [subdirectory2]\n            ├── myFile.txt\n            └── myFile2.txt\n\n#### Path Tree `dict`\n\nYou can also get a `dict` representation of a retrieved `PathTree`, having some additional information like \nthe absolute or relative path of the file or directory and their stats like _size_, _ctime_, _mode_, _uid_ and so on.\n\nUsing the `PathTree` instance `pt` from the [Examples](#examples) you can simply use one of the following methods:\n\n    pt.get_dict()\n    pt.dict()\n\nThe `dict` looks like as follows:\n\n    {\n        \'entry_type\': <ListEntryType.dir: \'dir\'>, \n        \'name\': \'data\', \n        \'path\': WindowsPath(\'.\'), \n        \'stat\': {\n            \'size\': 10834, \n            \'atime\': 1657198698.2257857, \n            \'ctime\': 1656593062.5510206, \n            \'mtime\': 1657177629.2652764, \n            \'gid\': 0, \n            \'mode\': 16895, \n            \'uid\': 0\n        }, \n        \'children\': [\n            {\n                \'entry_type\': <ListEntryType.file: \'file\'>, \n                \'name\': \'data-with-stat.json\', \n                \'path\': WindowsPath(\'data-with-stat.json\'), \n                \'stat\': {\n                    \'size\': 5774, \n                    \'atime\': 1657198447.0669634, \n                    \'ctime\': 1657177197.231495, \n                    \'mtime\': 1657177629.2642767, \n                    \'gid\': 0, \n                    \'mode\': 33206, \n                    \'uid\': 0\n                }, \n                \'children\': None\n            },\n            [...]\n        ]\n    }\n\n#### Path Tree `json`\n\nLast but not least you can get a `json` representation, with the same properties like the [Path Tree `dict`](#path-tree-dict).\n\nUsing the `PathTree` instance `pt` from the [Examples](#examples) you can simply use one of the following methods:\n\n    pt.get_json()\n    pt.json()\n\nThe `json` output looks like as follows:\n\n    {\n      "entry_type": "dir",\n      "name": "data",\n      "path": ".",\n      "stat": {\n        "size": 10834,\n        "atime": 1657199261.7484741,\n        "ctime": 1656593062.5510206,\n        "mtime": 1657177629.2652764,\n        "gid": 0,\n        "mode": 16895,\n        "uid": 0\n      },\n      "children": [\n        {\n          "entry_type": "file",\n          "name": "data-with-stat.json",\n          "path": "data-with-stat.json",\n          "stat": {\n            "size": 5774,\n            "atime": 1657198447.0669634,\n            "ctime": 1657177197.231495,\n            "mtime": 1657177629.2642767,\n            "gid": 0,\n            "mode": 33206,\n            "uid": 0\n          },\n          "children": null\n        },\n        [...]\n      ]\n    }\n\n## Support\n\nIf you\'re opening [issues][issue-tracker], please mention the version that the issue relates to. \nPlease further provide some sample code and also the expected output or behaviour. \n\n## Contributing\n\nTo contribute to this project, fork the repository, make your changes and create a pull request.\n\n## License\n\nThis project is licensed under the terms of the MIT license.\n\n## Known Issues\n\n- Python version compatibility < v3.10 is not tested yet\n\n\n\n[issue-tracker]: https://github.com/dl6nm/path-tree-generator/issues\n[pydantic]: https://pydantic-docs.helpmanual.io/\n[python]: https://www.python.org/\n',
    'author': 'DL6NM',
    'author_email': 'mail@dl6nm.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dl6nm/path-tree-generator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
