# encoding:utf-8
# distutils: language=c++
"""
(Copyright) 2018, Winton Wang <365504029@qq.com>

ctpwrapper is free software: you can redistribute it and/or modify
it under the terms of the GNU LGPLv3 as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ctpwrapper.  If not, see <http://www.gnu.org/licenses/>.
"""

from .ThostFtdcUserApiDataType cimport *

cdef extern from 'ThostFtdcUserApiStruct.h':
    cdef struct CThostFtdcDisseminationField:
        TThostFtdcSequenceSeriesType SequenceSeries
        TThostFtdcSequenceNoType SequenceNo
    cdef struct CThostFtdcReqUserLoginField:
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcPasswordType Password
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcProductInfoType InterfaceProductInfo
        TThostFtdcProtocolInfoType ProtocolInfo
        TThostFtdcMacAddressType MacAddress
        TThostFtdcPasswordType OneTimePassword
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcLoginRemarkType LoginRemark
        TThostFtdcIPPortType ClientIPPort
        TThostFtdcIPAddressType ClientIPAddress
    cdef struct CThostFtdcRspUserLoginField:
        TThostFtdcDateType TradingDay
        TThostFtdcTimeType LoginTime
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcSystemNameType SystemName
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcOrderRefType MaxOrderRef
        TThostFtdcTimeType SHFETime
        TThostFtdcTimeType DCETime
        TThostFtdcTimeType CZCETime
        TThostFtdcTimeType FFEXTime
        TThostFtdcTimeType INETime
    cdef struct CThostFtdcUserLogoutField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcForceUserLogoutField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcReqAuthenticateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcAuthCodeType AuthCode
        TThostFtdcAppIDType AppID
    cdef struct CThostFtdcRspAuthenticateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcAppIDType AppID
        TThostFtdcAppTypeType AppType
    cdef struct CThostFtdcAuthenticationInfoField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcAuthInfoType AuthInfo
        TThostFtdcBoolType IsResult
        TThostFtdcAppIDType AppID
        TThostFtdcAppTypeType AppType
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcIPAddressType ClientIPAddress
    cdef struct CThostFtdcRspUserLogin2Field:
        TThostFtdcDateType TradingDay
        TThostFtdcTimeType LoginTime
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcSystemNameType SystemName
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcOrderRefType MaxOrderRef
        TThostFtdcTimeType SHFETime
        TThostFtdcTimeType DCETime
        TThostFtdcTimeType CZCETime
        TThostFtdcTimeType FFEXTime
        TThostFtdcTimeType INETime
        TThostFtdcRandomStringType RandomString
    cdef struct CThostFtdcTransferHeaderField:
        TThostFtdcVersionType Version
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcTradeSerialType TradeSerial
        TThostFtdcFutureIDType FutureID
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBrchID
        TThostFtdcOperNoType OperNo
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcRecordNumType RecordNum
        TThostFtdcSessionIDType SessionID
        TThostFtdcRequestIDType RequestID
    cdef struct CThostFtdcTransferBankToFutureReqField:
        TThostFtdcAccountIDType FutureAccount
        TThostFtdcFuturePwdFlagType FuturePwdFlag
        TThostFtdcFutureAccPwdType FutureAccPwd
        TThostFtdcMoneyType TradeAmt
        TThostFtdcMoneyType CustFee
        TThostFtdcCurrencyCodeType CurrencyCode
    cdef struct CThostFtdcTransferBankToFutureRspField:
        TThostFtdcRetCodeType RetCode
        TThostFtdcRetInfoType RetInfo
        TThostFtdcAccountIDType FutureAccount
        TThostFtdcMoneyType TradeAmt
        TThostFtdcMoneyType CustFee
        TThostFtdcCurrencyCodeType CurrencyCode
    cdef struct CThostFtdcTransferFutureToBankReqField:
        TThostFtdcAccountIDType FutureAccount
        TThostFtdcFuturePwdFlagType FuturePwdFlag
        TThostFtdcFutureAccPwdType FutureAccPwd
        TThostFtdcMoneyType TradeAmt
        TThostFtdcMoneyType CustFee
        TThostFtdcCurrencyCodeType CurrencyCode
    cdef struct CThostFtdcTransferFutureToBankRspField:
        TThostFtdcRetCodeType RetCode
        TThostFtdcRetInfoType RetInfo
        TThostFtdcAccountIDType FutureAccount
        TThostFtdcMoneyType TradeAmt
        TThostFtdcMoneyType CustFee
        TThostFtdcCurrencyCodeType CurrencyCode
    cdef struct CThostFtdcTransferQryBankReqField:
        TThostFtdcAccountIDType FutureAccount
        TThostFtdcFuturePwdFlagType FuturePwdFlag
        TThostFtdcFutureAccPwdType FutureAccPwd
        TThostFtdcCurrencyCodeType CurrencyCode
    cdef struct CThostFtdcTransferQryBankRspField:
        TThostFtdcRetCodeType RetCode
        TThostFtdcRetInfoType RetInfo
        TThostFtdcAccountIDType FutureAccount
        TThostFtdcMoneyType TradeAmt
        TThostFtdcMoneyType UseAmt
        TThostFtdcMoneyType FetchAmt
        TThostFtdcCurrencyCodeType CurrencyCode
    cdef struct CThostFtdcTransferQryDetailReqField:
        TThostFtdcAccountIDType FutureAccount
    cdef struct CThostFtdcTransferQryDetailRspField:
        TThostFtdcDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcTradeSerialNoType FutureSerial
        TThostFtdcFutureIDType FutureID
        TThostFtdcFutureAccountType FutureAccount
        TThostFtdcTradeSerialNoType BankSerial
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBrchID
        TThostFtdcBankAccountType BankAccount
        TThostFtdcCertCodeType CertCode
        TThostFtdcCurrencyCodeType CurrencyCode
        TThostFtdcMoneyType TxAmount
        TThostFtdcTransferValidFlagType Flag
    cdef struct CThostFtdcRspInfoField:
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcExchangeField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExchangeNameType ExchangeName
        TThostFtdcExchangePropertyType ExchangeProperty
    cdef struct CThostFtdcProductField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcProductNameType ProductName
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcProductClassType ProductClass
        TThostFtdcVolumeMultipleType VolumeMultiple
        TThostFtdcPriceType PriceTick
        TThostFtdcVolumeType MaxMarketOrderVolume
        TThostFtdcVolumeType MinMarketOrderVolume
        TThostFtdcVolumeType MaxLimitOrderVolume
        TThostFtdcVolumeType MinLimitOrderVolume
        TThostFtdcPositionTypeType PositionType
        TThostFtdcPositionDateTypeType PositionDateType
        TThostFtdcCloseDealTypeType CloseDealType
        TThostFtdcCurrencyIDType TradeCurrencyID
        TThostFtdcMortgageFundUseRangeType MortgageFundUseRange
        TThostFtdcOldInstrumentIDType reserve2
        TThostFtdcUnderlyingMultipleType UnderlyingMultiple
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcInstrumentIDType ExchangeProductID
    cdef struct CThostFtdcInstrumentField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentNameType InstrumentName
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcOldInstrumentIDType reserve3
        TThostFtdcProductClassType ProductClass
        TThostFtdcYearType DeliveryYear
        TThostFtdcMonthType DeliveryMonth
        TThostFtdcVolumeType MaxMarketOrderVolume
        TThostFtdcVolumeType MinMarketOrderVolume
        TThostFtdcVolumeType MaxLimitOrderVolume
        TThostFtdcVolumeType MinLimitOrderVolume
        TThostFtdcVolumeMultipleType VolumeMultiple
        TThostFtdcPriceType PriceTick
        TThostFtdcDateType CreateDate
        TThostFtdcDateType OpenDate
        TThostFtdcDateType ExpireDate
        TThostFtdcDateType StartDelivDate
        TThostFtdcDateType EndDelivDate
        TThostFtdcInstLifePhaseType InstLifePhase
        TThostFtdcBoolType IsTrading
        TThostFtdcPositionTypeType PositionType
        TThostFtdcPositionDateTypeType PositionDateType
        TThostFtdcRatioType LongMarginRatio
        TThostFtdcRatioType ShortMarginRatio
        TThostFtdcMaxMarginSideAlgorithmType MaxMarginSideAlgorithm
        TThostFtdcOldInstrumentIDType reserve4
        TThostFtdcPriceType StrikePrice
        TThostFtdcOptionsTypeType OptionsType
        TThostFtdcUnderlyingMultipleType UnderlyingMultiple
        TThostFtdcCombinationTypeType CombinationType
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcInstrumentIDType UnderlyingInstrID
    cdef struct CThostFtdcBrokerField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcBrokerAbbrType BrokerAbbr
        TThostFtdcBrokerNameType BrokerName
        TThostFtdcBoolType IsActive
    cdef struct CThostFtdcTraderField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcPasswordType Password
        TThostFtdcInstallCountType InstallCount
        TThostFtdcBrokerIDType BrokerID
    cdef struct CThostFtdcInvestorField:
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorGroupID
        TThostFtdcPartyNameType InvestorName
        TThostFtdcIdCardTypeType IdentifiedCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcBoolType IsActive
        TThostFtdcTelephoneType Telephone
        TThostFtdcAddressType Address
        TThostFtdcDateType OpenDate
        TThostFtdcMobileType Mobile
        TThostFtdcInvestorIDType CommModelID
        TThostFtdcInvestorIDType MarginModelID
    cdef struct CThostFtdcTradingCodeField:
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcClientIDType ClientID
        TThostFtdcBoolType IsActive
        TThostFtdcClientIDTypeType ClientIDType
        TThostFtdcBranchIDType BranchID
        TThostFtdcBizTypeType BizType
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcPartBrokerField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcBoolType IsActive
    cdef struct CThostFtdcSuperUserField:
        TThostFtdcUserIDType UserID
        TThostFtdcUserNameType UserName
        TThostFtdcPasswordType Password
        TThostFtdcBoolType IsActive
    cdef struct CThostFtdcSuperUserFunctionField:
        TThostFtdcUserIDType UserID
        TThostFtdcFunctionCodeType FunctionCode
    cdef struct CThostFtdcInvestorGroupField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorGroupID
        TThostFtdcInvestorGroupNameType InvestorGroupName
    cdef struct CThostFtdcTradingAccountField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcMoneyType PreMortgage
        TThostFtdcMoneyType PreCredit
        TThostFtdcMoneyType PreDeposit
        TThostFtdcMoneyType PreBalance
        TThostFtdcMoneyType PreMargin
        TThostFtdcMoneyType InterestBase
        TThostFtdcMoneyType Interest
        TThostFtdcMoneyType Deposit
        TThostFtdcMoneyType Withdraw
        TThostFtdcMoneyType FrozenMargin
        TThostFtdcMoneyType FrozenCash
        TThostFtdcMoneyType FrozenCommission
        TThostFtdcMoneyType CurrMargin
        TThostFtdcMoneyType CashIn
        TThostFtdcMoneyType Commission
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType PositionProfit
        TThostFtdcMoneyType Balance
        TThostFtdcMoneyType Available
        TThostFtdcMoneyType WithdrawQuota
        TThostFtdcMoneyType Reserve
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcMoneyType Credit
        TThostFtdcMoneyType Mortgage
        TThostFtdcMoneyType ExchangeMargin
        TThostFtdcMoneyType DeliveryMargin
        TThostFtdcMoneyType ExchangeDeliveryMargin
        TThostFtdcMoneyType ReserveBalance
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcMoneyType PreFundMortgageIn
        TThostFtdcMoneyType PreFundMortgageOut
        TThostFtdcMoneyType FundMortgageIn
        TThostFtdcMoneyType FundMortgageOut
        TThostFtdcMoneyType FundMortgageAvailable
        TThostFtdcMoneyType MortgageableFund
        TThostFtdcMoneyType SpecProductMargin
        TThostFtdcMoneyType SpecProductFrozenMargin
        TThostFtdcMoneyType SpecProductCommission
        TThostFtdcMoneyType SpecProductFrozenCommission
        TThostFtdcMoneyType SpecProductPositionProfit
        TThostFtdcMoneyType SpecProductCloseProfit
        TThostFtdcMoneyType SpecProductPositionProfitByAlg
        TThostFtdcMoneyType SpecProductExchangeMargin
        TThostFtdcBizTypeType BizType
        TThostFtdcMoneyType FrozenSwap
        TThostFtdcMoneyType RemainSwap
    cdef struct CThostFtdcInvestorPositionField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcPosiDirectionType PosiDirection
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcPositionDateType PositionDate
        TThostFtdcVolumeType YdPosition
        TThostFtdcVolumeType Position
        TThostFtdcVolumeType LongFrozen
        TThostFtdcVolumeType ShortFrozen
        TThostFtdcMoneyType LongFrozenAmount
        TThostFtdcMoneyType ShortFrozenAmount
        TThostFtdcVolumeType OpenVolume
        TThostFtdcVolumeType CloseVolume
        TThostFtdcMoneyType OpenAmount
        TThostFtdcMoneyType CloseAmount
        TThostFtdcMoneyType PositionCost
        TThostFtdcMoneyType PreMargin
        TThostFtdcMoneyType UseMargin
        TThostFtdcMoneyType FrozenMargin
        TThostFtdcMoneyType FrozenCash
        TThostFtdcMoneyType FrozenCommission
        TThostFtdcMoneyType CashIn
        TThostFtdcMoneyType Commission
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType PositionProfit
        TThostFtdcPriceType PreSettlementPrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcMoneyType OpenCost
        TThostFtdcMoneyType ExchangeMargin
        TThostFtdcVolumeType CombPosition
        TThostFtdcVolumeType CombLongFrozen
        TThostFtdcVolumeType CombShortFrozen
        TThostFtdcMoneyType CloseProfitByDate
        TThostFtdcMoneyType CloseProfitByTrade
        TThostFtdcVolumeType TodayPosition
        TThostFtdcRatioType MarginRateByMoney
        TThostFtdcRatioType MarginRateByVolume
        TThostFtdcVolumeType StrikeFrozen
        TThostFtdcMoneyType StrikeFrozenAmount
        TThostFtdcVolumeType AbandonFrozen
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcVolumeType YdStrikeFrozen
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcMoneyType PositionCostOffset
        TThostFtdcVolumeType TasPosition
        TThostFtdcMoneyType TasPositionCost
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInstrumentMarginRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcBoolType IsRelative
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInstrumentCommissionRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType OpenRatioByMoney
        TThostFtdcRatioType OpenRatioByVolume
        TThostFtdcRatioType CloseRatioByMoney
        TThostFtdcRatioType CloseRatioByVolume
        TThostFtdcRatioType CloseTodayRatioByMoney
        TThostFtdcRatioType CloseTodayRatioByVolume
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcBizTypeType BizType
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcDepthMarketDataField:
        TThostFtdcDateType TradingDay
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcPriceType LastPrice
        TThostFtdcPriceType PreSettlementPrice
        TThostFtdcPriceType PreClosePrice
        TThostFtdcLargeVolumeType PreOpenInterest
        TThostFtdcPriceType OpenPrice
        TThostFtdcPriceType HighestPrice
        TThostFtdcPriceType LowestPrice
        TThostFtdcVolumeType Volume
        TThostFtdcMoneyType Turnover
        TThostFtdcLargeVolumeType OpenInterest
        TThostFtdcPriceType ClosePrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcPriceType UpperLimitPrice
        TThostFtdcPriceType LowerLimitPrice
        TThostFtdcRatioType PreDelta
        TThostFtdcRatioType CurrDelta
        TThostFtdcTimeType UpdateTime
        TThostFtdcMillisecType UpdateMillisec
        TThostFtdcPriceType BidPrice1
        TThostFtdcVolumeType BidVolume1
        TThostFtdcPriceType AskPrice1
        TThostFtdcVolumeType AskVolume1
        TThostFtdcPriceType BidPrice2
        TThostFtdcVolumeType BidVolume2
        TThostFtdcPriceType AskPrice2
        TThostFtdcVolumeType AskVolume2
        TThostFtdcPriceType BidPrice3
        TThostFtdcVolumeType BidVolume3
        TThostFtdcPriceType AskPrice3
        TThostFtdcVolumeType AskVolume3
        TThostFtdcPriceType BidPrice4
        TThostFtdcVolumeType BidVolume4
        TThostFtdcPriceType AskPrice4
        TThostFtdcVolumeType AskVolume4
        TThostFtdcPriceType BidPrice5
        TThostFtdcVolumeType BidVolume5
        TThostFtdcPriceType AskPrice5
        TThostFtdcVolumeType AskVolume5
        TThostFtdcPriceType AveragePrice
        TThostFtdcDateType ActionDay
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcPriceType BandingUpperPrice
        TThostFtdcPriceType BandingLowerPrice
    cdef struct CThostFtdcInstrumentTradingRightField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcTradingRightType TradingRight
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcBrokerUserField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcUserNameType UserName
        TThostFtdcUserTypeType UserType
        TThostFtdcBoolType IsActive
        TThostFtdcBoolType IsUsingOTP
        TThostFtdcBoolType IsAuthForce
    cdef struct CThostFtdcBrokerUserPasswordField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcPasswordType Password
        TThostFtdcDateTimeType LastUpdateTime
        TThostFtdcDateTimeType LastLoginTime
        TThostFtdcDateType ExpireDate
        TThostFtdcDateType WeakExpireDate
    cdef struct CThostFtdcBrokerUserFunctionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcBrokerFunctionCodeType BrokerFunctionCode
    cdef struct CThostFtdcTraderOfferField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcTraderConnectStatusType TraderConnectStatus
        TThostFtdcDateType ConnectRequestDate
        TThostFtdcTimeType ConnectRequestTime
        TThostFtdcDateType LastReportDate
        TThostFtdcTimeType LastReportTime
        TThostFtdcDateType ConnectDate
        TThostFtdcTimeType ConnectTime
        TThostFtdcDateType StartDate
        TThostFtdcTimeType StartTime
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcTradeIDType MaxTradeID
        TThostFtdcReturnCodeType MaxOrderMessageReference
    cdef struct CThostFtdcSettlementInfoField:
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcContentType Content
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcInstrumentMarginRateAdjustField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcBoolType IsRelative
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeMarginRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeMarginRateAdjustField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcRatioType ExchLongMarginRatioByMoney
        TThostFtdcMoneyType ExchLongMarginRatioByVolume
        TThostFtdcRatioType ExchShortMarginRatioByMoney
        TThostFtdcMoneyType ExchShortMarginRatioByVolume
        TThostFtdcRatioType NoLongMarginRatioByMoney
        TThostFtdcMoneyType NoLongMarginRatioByVolume
        TThostFtdcRatioType NoShortMarginRatioByMoney
        TThostFtdcMoneyType NoShortMarginRatioByVolume
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcCurrencyIDType FromCurrencyID
        TThostFtdcCurrencyUnitType FromCurrencyUnit
        TThostFtdcCurrencyIDType ToCurrencyID
        TThostFtdcExchangeRateType ExchangeRate
    cdef struct CThostFtdcSettlementRefField:
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
    cdef struct CThostFtdcCurrentTimeField:
        TThostFtdcDateType CurrDate
        TThostFtdcTimeType CurrTime
        TThostFtdcMillisecType CurrMillisec
        TThostFtdcDateType ActionDay
    cdef struct CThostFtdcCommPhaseField:
        TThostFtdcDateType TradingDay
        TThostFtdcCommPhaseNoType CommPhaseNo
        TThostFtdcSystemIDType SystemID
    cdef struct CThostFtdcLoginInfoField:
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcDateType LoginDate
        TThostFtdcTimeType LoginTime
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcProductInfoType InterfaceProductInfo
        TThostFtdcProtocolInfoType ProtocolInfo
        TThostFtdcSystemNameType SystemName
        TThostFtdcPasswordType PasswordDeprecated
        TThostFtdcOrderRefType MaxOrderRef
        TThostFtdcTimeType SHFETime
        TThostFtdcTimeType DCETime
        TThostFtdcTimeType CZCETime
        TThostFtdcTimeType FFEXTime
        TThostFtdcMacAddressType MacAddress
        TThostFtdcPasswordType OneTimePassword
        TThostFtdcTimeType INETime
        TThostFtdcBoolType IsQryControl
        TThostFtdcLoginRemarkType LoginRemark
        TThostFtdcPasswordType Password
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcLogoutAllField:
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcSystemNameType SystemName
    cdef struct CThostFtdcFrontStatusField:
        TThostFtdcFrontIDType FrontID
        TThostFtdcDateType LastReportDate
        TThostFtdcTimeType LastReportTime
        TThostFtdcBoolType IsActive
    cdef struct CThostFtdcUserPasswordUpdateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcPasswordType OldPassword
        TThostFtdcPasswordType NewPassword
    cdef struct CThostFtdcInputOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcOrderPriceTypeType OrderPriceType
        TThostFtdcDirectionType Direction
        TThostFtdcCombOffsetFlagType CombOffsetFlag
        TThostFtdcCombHedgeFlagType CombHedgeFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeTotalOriginal
        TThostFtdcTimeConditionType TimeCondition
        TThostFtdcDateType GTDDate
        TThostFtdcVolumeConditionType VolumeCondition
        TThostFtdcVolumeType MinVolume
        TThostFtdcContingentConditionType ContingentCondition
        TThostFtdcPriceType StopPrice
        TThostFtdcForceCloseReasonType ForceCloseReason
        TThostFtdcBoolType IsAutoSuspend
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcRequestIDType RequestID
        TThostFtdcBoolType UserForceClose
        TThostFtdcBoolType IsSwapOrder
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcOrderPriceTypeType OrderPriceType
        TThostFtdcDirectionType Direction
        TThostFtdcCombOffsetFlagType CombOffsetFlag
        TThostFtdcCombHedgeFlagType CombHedgeFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeTotalOriginal
        TThostFtdcTimeConditionType TimeCondition
        TThostFtdcDateType GTDDate
        TThostFtdcVolumeConditionType VolumeCondition
        TThostFtdcVolumeType MinVolume
        TThostFtdcContingentConditionType ContingentCondition
        TThostFtdcPriceType StopPrice
        TThostFtdcForceCloseReasonType ForceCloseReason
        TThostFtdcBoolType IsAutoSuspend
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcRequestIDType RequestID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcOrderSourceType OrderSource
        TThostFtdcOrderStatusType OrderStatus
        TThostFtdcOrderTypeType OrderType
        TThostFtdcVolumeType VolumeTraded
        TThostFtdcVolumeType VolumeTotal
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType ActiveTime
        TThostFtdcTimeType SuspendTime
        TThostFtdcTimeType UpdateTime
        TThostFtdcTimeType CancelTime
        TThostFtdcTraderIDType ActiveTraderID
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcBoolType UserForceClose
        TThostFtdcUserIDType ActiveUserID
        TThostFtdcSequenceNoType BrokerOrderSeq
        TThostFtdcOrderSysIDType RelativeOrderSysID
        TThostFtdcVolumeType ZCETotalTradedVolume
        TThostFtdcBoolType IsSwapOrder
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcOldIPAddressType reserve3
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcExchangeOrderField:
        TThostFtdcOrderPriceTypeType OrderPriceType
        TThostFtdcDirectionType Direction
        TThostFtdcCombOffsetFlagType CombOffsetFlag
        TThostFtdcCombHedgeFlagType CombHedgeFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeTotalOriginal
        TThostFtdcTimeConditionType TimeCondition
        TThostFtdcDateType GTDDate
        TThostFtdcVolumeConditionType VolumeCondition
        TThostFtdcVolumeType MinVolume
        TThostFtdcContingentConditionType ContingentCondition
        TThostFtdcPriceType StopPrice
        TThostFtdcForceCloseReasonType ForceCloseReason
        TThostFtdcBoolType IsAutoSuspend
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcRequestIDType RequestID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcOrderSourceType OrderSource
        TThostFtdcOrderStatusType OrderStatus
        TThostFtdcOrderTypeType OrderType
        TThostFtdcVolumeType VolumeTraded
        TThostFtdcVolumeType VolumeTotal
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType ActiveTime
        TThostFtdcTimeType SuspendTime
        TThostFtdcTimeType UpdateTime
        TThostFtdcTimeType CancelTime
        TThostFtdcTraderIDType ActiveTraderID
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcBranchIDType BranchID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcExchangeOrderInsertErrorField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcInputOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OrderActionRef
        TThostFtdcOrderRefType OrderRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeChange
        TThostFtdcUserIDType UserID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OrderActionRef
        TThostFtdcOrderRefType OrderRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeChange
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcExchangeOrderActionField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeChange
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcBranchIDType BranchID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcMacAddressType MacAddress
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcExchangeOrderActionErrorField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcExchangeTradeField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTradeIDType TradeID
        TThostFtdcDirectionType Direction
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcTradingRoleType TradingRole
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcPriceType Price
        TThostFtdcVolumeType Volume
        TThostFtdcDateType TradeDate
        TThostFtdcTimeType TradeTime
        TThostFtdcTradeTypeType TradeType
        TThostFtdcPriceSourceType PriceSource
        TThostFtdcTraderIDType TraderID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcTradeSourceType TradeSource
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcTradeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTradeIDType TradeID
        TThostFtdcDirectionType Direction
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcTradingRoleType TradingRole
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcPriceType Price
        TThostFtdcVolumeType Volume
        TThostFtdcDateType TradeDate
        TThostFtdcTimeType TradeTime
        TThostFtdcTradeTypeType TradeType
        TThostFtdcPriceSourceType PriceSource
        TThostFtdcTraderIDType TraderID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcSequenceNoType BrokerOrderSeq
        TThostFtdcTradeSourceType TradeSource
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcUserSessionField:
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcDateType LoginDate
        TThostFtdcTimeType LoginTime
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcProductInfoType InterfaceProductInfo
        TThostFtdcProtocolInfoType ProtocolInfo
        TThostFtdcMacAddressType MacAddress
        TThostFtdcLoginRemarkType LoginRemark
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryMaxOrderVolumeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcDirectionType Direction
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcVolumeType MaxVolume
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcSettlementInfoConfirmField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcDateType ConfirmDate
        TThostFtdcTimeType ConfirmTime
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcSyncDepositField:
        TThostFtdcDepositSeqNoType DepositSeqNo
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcMoneyType Deposit
        TThostFtdcBoolType IsForce
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcBoolType IsFromSopt
        TThostFtdcPasswordType TradingPassword
    cdef struct CThostFtdcSyncFundMortgageField:
        TThostFtdcDepositSeqNoType MortgageSeqNo
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcCurrencyIDType FromCurrencyID
        TThostFtdcMoneyType MortgageAmount
        TThostFtdcCurrencyIDType ToCurrencyID
    cdef struct CThostFtdcBrokerSyncField:
        TThostFtdcBrokerIDType BrokerID
    cdef struct CThostFtdcSyncingInvestorField:
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorGroupID
        TThostFtdcPartyNameType InvestorName
        TThostFtdcIdCardTypeType IdentifiedCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcBoolType IsActive
        TThostFtdcTelephoneType Telephone
        TThostFtdcAddressType Address
        TThostFtdcDateType OpenDate
        TThostFtdcMobileType Mobile
        TThostFtdcInvestorIDType CommModelID
        TThostFtdcInvestorIDType MarginModelID
    cdef struct CThostFtdcSyncingTradingCodeField:
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcClientIDType ClientID
        TThostFtdcBoolType IsActive
        TThostFtdcClientIDTypeType ClientIDType
    cdef struct CThostFtdcSyncingInvestorGroupField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorGroupID
        TThostFtdcInvestorGroupNameType InvestorGroupName
    cdef struct CThostFtdcSyncingTradingAccountField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcMoneyType PreMortgage
        TThostFtdcMoneyType PreCredit
        TThostFtdcMoneyType PreDeposit
        TThostFtdcMoneyType PreBalance
        TThostFtdcMoneyType PreMargin
        TThostFtdcMoneyType InterestBase
        TThostFtdcMoneyType Interest
        TThostFtdcMoneyType Deposit
        TThostFtdcMoneyType Withdraw
        TThostFtdcMoneyType FrozenMargin
        TThostFtdcMoneyType FrozenCash
        TThostFtdcMoneyType FrozenCommission
        TThostFtdcMoneyType CurrMargin
        TThostFtdcMoneyType CashIn
        TThostFtdcMoneyType Commission
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType PositionProfit
        TThostFtdcMoneyType Balance
        TThostFtdcMoneyType Available
        TThostFtdcMoneyType WithdrawQuota
        TThostFtdcMoneyType Reserve
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcMoneyType Credit
        TThostFtdcMoneyType Mortgage
        TThostFtdcMoneyType ExchangeMargin
        TThostFtdcMoneyType DeliveryMargin
        TThostFtdcMoneyType ExchangeDeliveryMargin
        TThostFtdcMoneyType ReserveBalance
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcMoneyType PreFundMortgageIn
        TThostFtdcMoneyType PreFundMortgageOut
        TThostFtdcMoneyType FundMortgageIn
        TThostFtdcMoneyType FundMortgageOut
        TThostFtdcMoneyType FundMortgageAvailable
        TThostFtdcMoneyType MortgageableFund
        TThostFtdcMoneyType SpecProductMargin
        TThostFtdcMoneyType SpecProductFrozenMargin
        TThostFtdcMoneyType SpecProductCommission
        TThostFtdcMoneyType SpecProductFrozenCommission
        TThostFtdcMoneyType SpecProductPositionProfit
        TThostFtdcMoneyType SpecProductCloseProfit
        TThostFtdcMoneyType SpecProductPositionProfitByAlg
        TThostFtdcMoneyType SpecProductExchangeMargin
        TThostFtdcMoneyType FrozenSwap
        TThostFtdcMoneyType RemainSwap
    cdef struct CThostFtdcSyncingInvestorPositionField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcPosiDirectionType PosiDirection
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcPositionDateType PositionDate
        TThostFtdcVolumeType YdPosition
        TThostFtdcVolumeType Position
        TThostFtdcVolumeType LongFrozen
        TThostFtdcVolumeType ShortFrozen
        TThostFtdcMoneyType LongFrozenAmount
        TThostFtdcMoneyType ShortFrozenAmount
        TThostFtdcVolumeType OpenVolume
        TThostFtdcVolumeType CloseVolume
        TThostFtdcMoneyType OpenAmount
        TThostFtdcMoneyType CloseAmount
        TThostFtdcMoneyType PositionCost
        TThostFtdcMoneyType PreMargin
        TThostFtdcMoneyType UseMargin
        TThostFtdcMoneyType FrozenMargin
        TThostFtdcMoneyType FrozenCash
        TThostFtdcMoneyType FrozenCommission
        TThostFtdcMoneyType CashIn
        TThostFtdcMoneyType Commission
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType PositionProfit
        TThostFtdcPriceType PreSettlementPrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcMoneyType OpenCost
        TThostFtdcMoneyType ExchangeMargin
        TThostFtdcVolumeType CombPosition
        TThostFtdcVolumeType CombLongFrozen
        TThostFtdcVolumeType CombShortFrozen
        TThostFtdcMoneyType CloseProfitByDate
        TThostFtdcMoneyType CloseProfitByTrade
        TThostFtdcVolumeType TodayPosition
        TThostFtdcRatioType MarginRateByMoney
        TThostFtdcRatioType MarginRateByVolume
        TThostFtdcVolumeType StrikeFrozen
        TThostFtdcMoneyType StrikeFrozenAmount
        TThostFtdcVolumeType AbandonFrozen
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcVolumeType YdStrikeFrozen
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcMoneyType PositionCostOffset
        TThostFtdcVolumeType TasPosition
        TThostFtdcMoneyType TasPositionCost
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcSyncingInstrumentMarginRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcBoolType IsRelative
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcSyncingInstrumentCommissionRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType OpenRatioByMoney
        TThostFtdcRatioType OpenRatioByVolume
        TThostFtdcRatioType CloseRatioByMoney
        TThostFtdcRatioType CloseRatioByVolume
        TThostFtdcRatioType CloseTodayRatioByMoney
        TThostFtdcRatioType CloseTodayRatioByVolume
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcSyncingInstrumentTradingRightField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcTradingRightType TradingRight
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcTimeType InsertTimeStart
        TThostFtdcTimeType InsertTimeEnd
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryTradeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTradeIDType TradeID
        TThostFtdcTimeType TradeTimeStart
        TThostFtdcTimeType TradeTimeEnd
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryInvestorPositionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryTradingAccountField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcBizTypeType BizType
        TThostFtdcAccountIDType AccountID
    cdef struct CThostFtdcQryInvestorField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcQryTradingCodeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcClientIDType ClientID
        TThostFtdcClientIDTypeType ClientIDType
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcQryInvestorGroupField:
        TThostFtdcBrokerIDType BrokerID
    cdef struct CThostFtdcQryInstrumentMarginRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryInstrumentCommissionRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryInstrumentTradingRightField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryBrokerField:
        TThostFtdcBrokerIDType BrokerID
    cdef struct CThostFtdcQryTraderField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcTraderIDType TraderID
    cdef struct CThostFtdcQrySuperUserFunctionField:
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcQryUserSessionField:
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcQryPartBrokerField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcParticipantIDType ParticipantID
    cdef struct CThostFtdcQryFrontStatusField:
        TThostFtdcFrontIDType FrontID
    cdef struct CThostFtdcQryExchangeOrderField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcQryOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcQryExchangeOrderActionField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
    cdef struct CThostFtdcQrySuperUserField:
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcQryExchangeField:
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcQryProductField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcProductClassType ProductClass
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType ProductID
    cdef struct CThostFtdcQryInstrumentField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcOldInstrumentIDType reserve3
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcInstrumentIDType ProductID
    cdef struct CThostFtdcQryDepthMarketDataField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryBrokerUserField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcQryBrokerUserFunctionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcQryTraderOfferField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcTraderIDType TraderID
    cdef struct CThostFtdcQrySyncDepositField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcDepositSeqNoType DepositSeqNo
    cdef struct CThostFtdcQrySettlementInfoField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcDateType TradingDay
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcQryExchangeMarginRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryExchangeMarginRateAdjustField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryExchangeRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcCurrencyIDType FromCurrencyID
        TThostFtdcCurrencyIDType ToCurrencyID
    cdef struct CThostFtdcQrySyncFundMortgageField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcDepositSeqNoType MortgageSeqNo
    cdef struct CThostFtdcQryHisOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcTimeType InsertTimeStart
        TThostFtdcTimeType InsertTimeEnd
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcOptionInstrMiniMarginField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcMoneyType MinMargin
        TThostFtdcValueMethodType ValueMethod
        TThostFtdcBoolType IsRelative
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcOptionInstrMarginAdjustField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType SShortMarginRatioByMoney
        TThostFtdcMoneyType SShortMarginRatioByVolume
        TThostFtdcRatioType HShortMarginRatioByMoney
        TThostFtdcMoneyType HShortMarginRatioByVolume
        TThostFtdcRatioType AShortMarginRatioByMoney
        TThostFtdcMoneyType AShortMarginRatioByVolume
        TThostFtdcBoolType IsRelative
        TThostFtdcRatioType MShortMarginRatioByMoney
        TThostFtdcMoneyType MShortMarginRatioByVolume
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcOptionInstrCommRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType OpenRatioByMoney
        TThostFtdcRatioType OpenRatioByVolume
        TThostFtdcRatioType CloseRatioByMoney
        TThostFtdcRatioType CloseRatioByVolume
        TThostFtdcRatioType CloseTodayRatioByMoney
        TThostFtdcRatioType CloseTodayRatioByVolume
        TThostFtdcRatioType StrikeRatioByMoney
        TThostFtdcRatioType StrikeRatioByVolume
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcOptionInstrTradeCostField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcMoneyType FixedMargin
        TThostFtdcMoneyType MiniMargin
        TThostFtdcMoneyType Royalty
        TThostFtdcMoneyType ExchFixedMargin
        TThostFtdcMoneyType ExchMiniMargin
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryOptionInstrTradeCostField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcPriceType InputPrice
        TThostFtdcPriceType UnderlyingPrice
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryOptionInstrCommRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcIndexPriceField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcPriceType ClosePrice
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInputExecOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType ExecOrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcVolumeType Volume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcActionTypeType ActionType
        TThostFtdcPosiDirectionType PosiDirection
        TThostFtdcExecOrderPositionFlagType ReservePositionFlag
        TThostFtdcExecOrderCloseFlagType CloseFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcInputExecOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType ExecOrderActionRef
        TThostFtdcOrderRefType ExecOrderRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExecOrderSysIDType ExecOrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcUserIDType UserID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcExecOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType ExecOrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcVolumeType Volume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcActionTypeType ActionType
        TThostFtdcPosiDirectionType PosiDirection
        TThostFtdcExecOrderPositionFlagType ReservePositionFlag
        TThostFtdcExecOrderCloseFlagType CloseFlag
        TThostFtdcOrderLocalIDType ExecOrderLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcExecOrderSysIDType ExecOrderSysID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType CancelTime
        TThostFtdcExecResultType ExecResult
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcUserIDType ActiveUserID
        TThostFtdcSequenceNoType BrokerExecOrderSeq
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcOldIPAddressType reserve3
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcExecOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType ExecOrderActionRef
        TThostFtdcOrderRefType ExecOrderRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExecOrderSysIDType ExecOrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType ExecOrderLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcActionTypeType ActionType
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryExecOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExecOrderSysIDType ExecOrderSysID
        TThostFtdcTimeType InsertTimeStart
        TThostFtdcTimeType InsertTimeEnd
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeExecOrderField:
        TThostFtdcVolumeType Volume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcActionTypeType ActionType
        TThostFtdcPosiDirectionType PosiDirection
        TThostFtdcExecOrderPositionFlagType ReservePositionFlag
        TThostFtdcExecOrderCloseFlagType CloseFlag
        TThostFtdcOrderLocalIDType ExecOrderLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcExecOrderSysIDType ExecOrderSysID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType CancelTime
        TThostFtdcExecResultType ExecResult
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcBranchIDType BranchID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryExchangeExecOrderField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcQryExecOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcExchangeExecOrderActionField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExecOrderSysIDType ExecOrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType ExecOrderLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcActionTypeType ActionType
        TThostFtdcBranchIDType BranchID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcMacAddressType MacAddress
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcVolumeType Volume
        TThostFtdcIPAddressType IPAddress
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcQryExchangeExecOrderActionField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
    cdef struct CThostFtdcErrExecOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType ExecOrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcVolumeType Volume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcActionTypeType ActionType
        TThostFtdcPosiDirectionType PosiDirection
        TThostFtdcExecOrderPositionFlagType ReservePositionFlag
        TThostFtdcExecOrderCloseFlagType CloseFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryErrExecOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcErrExecOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType ExecOrderActionRef
        TThostFtdcOrderRefType ExecOrderRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExecOrderSysIDType ExecOrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcUserIDType UserID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryErrExecOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcOptionInstrTradingRightField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcDirectionType Direction
        TThostFtdcTradingRightType TradingRight
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryOptionInstrTradingRightField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcDirectionType Direction
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInputForQuoteField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType ForQuoteRef
        TThostFtdcUserIDType UserID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcForQuoteField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType ForQuoteRef
        TThostFtdcUserIDType UserID
        TThostFtdcOrderLocalIDType ForQuoteLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcForQuoteStatusType ForQuoteStatus
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcUserIDType ActiveUserID
        TThostFtdcSequenceNoType BrokerForQutoSeq
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve3
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryForQuoteField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTimeType InsertTimeStart
        TThostFtdcTimeType InsertTimeEnd
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeForQuoteField:
        TThostFtdcOrderLocalIDType ForQuoteLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcForQuoteStatusType ForQuoteStatus
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryExchangeForQuoteField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcInputQuoteField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType QuoteRef
        TThostFtdcUserIDType UserID
        TThostFtdcPriceType AskPrice
        TThostFtdcPriceType BidPrice
        TThostFtdcVolumeType AskVolume
        TThostFtdcVolumeType BidVolume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOffsetFlagType AskOffsetFlag
        TThostFtdcOffsetFlagType BidOffsetFlag
        TThostFtdcHedgeFlagType AskHedgeFlag
        TThostFtdcHedgeFlagType BidHedgeFlag
        TThostFtdcOrderRefType AskOrderRef
        TThostFtdcOrderRefType BidOrderRef
        TThostFtdcOrderSysIDType ForQuoteSysID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
        TThostFtdcOrderSysIDType ReplaceSysID
    cdef struct CThostFtdcInputQuoteActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType QuoteActionRef
        TThostFtdcOrderRefType QuoteRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType QuoteSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcUserIDType UserID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQuoteField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType QuoteRef
        TThostFtdcUserIDType UserID
        TThostFtdcPriceType AskPrice
        TThostFtdcPriceType BidPrice
        TThostFtdcVolumeType AskVolume
        TThostFtdcVolumeType BidVolume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOffsetFlagType AskOffsetFlag
        TThostFtdcOffsetFlagType BidOffsetFlag
        TThostFtdcHedgeFlagType AskHedgeFlag
        TThostFtdcHedgeFlagType BidHedgeFlag
        TThostFtdcOrderLocalIDType QuoteLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcOrderSysIDType QuoteSysID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType CancelTime
        TThostFtdcOrderStatusType QuoteStatus
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcOrderSysIDType AskOrderSysID
        TThostFtdcOrderSysIDType BidOrderSysID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcUserIDType ActiveUserID
        TThostFtdcSequenceNoType BrokerQuoteSeq
        TThostFtdcOrderRefType AskOrderRef
        TThostFtdcOrderRefType BidOrderRef
        TThostFtdcOrderSysIDType ForQuoteSysID
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcOldIPAddressType reserve3
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
        TThostFtdcOrderSysIDType ReplaceSysID
    cdef struct CThostFtdcQuoteActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType QuoteActionRef
        TThostFtdcOrderRefType QuoteRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType QuoteSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType QuoteLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryQuoteField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType QuoteSysID
        TThostFtdcTimeType InsertTimeStart
        TThostFtdcTimeType InsertTimeEnd
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeQuoteField:
        TThostFtdcPriceType AskPrice
        TThostFtdcPriceType BidPrice
        TThostFtdcVolumeType AskVolume
        TThostFtdcVolumeType BidVolume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOffsetFlagType AskOffsetFlag
        TThostFtdcOffsetFlagType BidOffsetFlag
        TThostFtdcHedgeFlagType AskHedgeFlag
        TThostFtdcHedgeFlagType BidHedgeFlag
        TThostFtdcOrderLocalIDType QuoteLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcOrderSysIDType QuoteSysID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType CancelTime
        TThostFtdcOrderStatusType QuoteStatus
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcOrderSysIDType AskOrderSysID
        TThostFtdcOrderSysIDType BidOrderSysID
        TThostFtdcOrderSysIDType ForQuoteSysID
        TThostFtdcBranchIDType BranchID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryExchangeQuoteField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcQryQuoteActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcExchangeQuoteActionField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType QuoteSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType QuoteLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcMacAddressType MacAddress
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryExchangeQuoteActionField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
    cdef struct CThostFtdcOptionInstrDeltaField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType Delta
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcForQuoteRspField:
        TThostFtdcDateType TradingDay
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderSysIDType ForQuoteSysID
        TThostFtdcTimeType ForQuoteTime
        TThostFtdcDateType ActionDay
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcStrikeOffsetField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcMoneyType Offset
        TThostFtdcStrikeOffsetTypeType OffsetType
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryStrikeOffsetField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInputBatchOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OrderActionRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcUserIDType UserID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcMacAddressType MacAddress
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcBatchOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OrderActionRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcMacAddressType MacAddress
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcExchangeBatchOrderActionField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcMacAddressType MacAddress
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryBatchOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcCombInstrumentGuardField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcRatioType GuarantRatio
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryCombInstrumentGuardField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInputCombActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType CombActionRef
        TThostFtdcUserIDType UserID
        TThostFtdcDirectionType Direction
        TThostFtdcVolumeType Volume
        TThostFtdcCombDirectionType CombDirection
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcCombActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType CombActionRef
        TThostFtdcUserIDType UserID
        TThostFtdcDirectionType Direction
        TThostFtdcVolumeType Volume
        TThostFtdcCombDirectionType CombDirection
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderActionStatusType ActionStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcOldIPAddressType reserve3
        TThostFtdcMacAddressType MacAddress
        TThostFtdcTradeIDType ComTradeID
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryCombActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeCombActionField:
        TThostFtdcDirectionType Direction
        TThostFtdcVolumeType Volume
        TThostFtdcCombDirectionType CombDirection
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderActionStatusType ActionStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcTradeIDType ComTradeID
        TThostFtdcBranchIDType BranchID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryExchangeCombActionField:
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcProductExchRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcCurrencyIDType QuoteCurrencyID
        TThostFtdcExchangeRateType ExchangeRate
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType ProductID
    cdef struct CThostFtdcQryProductExchRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType ProductID
    cdef struct CThostFtdcQryForQuoteParamField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcForQuoteParamField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcPriceType LastPrice
        TThostFtdcPriceType PriceInterval
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcMMOptionInstrCommRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType OpenRatioByMoney
        TThostFtdcRatioType OpenRatioByVolume
        TThostFtdcRatioType CloseRatioByMoney
        TThostFtdcRatioType CloseRatioByVolume
        TThostFtdcRatioType CloseTodayRatioByMoney
        TThostFtdcRatioType CloseTodayRatioByVolume
        TThostFtdcRatioType StrikeRatioByMoney
        TThostFtdcRatioType StrikeRatioByVolume
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryMMOptionInstrCommRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcMMInstrumentCommissionRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType OpenRatioByMoney
        TThostFtdcRatioType OpenRatioByVolume
        TThostFtdcRatioType CloseRatioByMoney
        TThostFtdcRatioType CloseRatioByVolume
        TThostFtdcRatioType CloseTodayRatioByMoney
        TThostFtdcRatioType CloseTodayRatioByVolume
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryMMInstrumentCommissionRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInstrumentOrderCommRateField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType OrderCommByVolume
        TThostFtdcRatioType OrderActionCommByVolume
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcRatioType OrderCommByTrade
        TThostFtdcRatioType OrderActionCommByTrade
    cdef struct CThostFtdcQryInstrumentOrderCommRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcTradeParamField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcTradeParamIDType TradeParamID
        TThostFtdcSettlementParamValueType TradeParamValue
        TThostFtdcMemoType Memo
    cdef struct CThostFtdcInstrumentMarginRateULField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcFutureLimitPosiParamField:
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcVolumeType SpecOpenVolume
        TThostFtdcVolumeType ArbiOpenVolume
        TThostFtdcVolumeType OpenVolume
        TThostFtdcInstrumentIDType ProductID
    cdef struct CThostFtdcLoginForbiddenIPField:
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcIPListField:
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcBoolType IsWhite
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcInputOptionSelfCloseField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OptionSelfCloseRef
        TThostFtdcUserIDType UserID
        TThostFtdcVolumeType Volume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcOptSelfCloseFlagType OptSelfCloseFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcInputOptionSelfCloseActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OptionSelfCloseActionRef
        TThostFtdcOrderRefType OptionSelfCloseRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OptionSelfCloseSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcUserIDType UserID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcOptionSelfCloseField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OptionSelfCloseRef
        TThostFtdcUserIDType UserID
        TThostFtdcVolumeType Volume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcOptSelfCloseFlagType OptSelfCloseFlag
        TThostFtdcOrderLocalIDType OptionSelfCloseLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcOrderSysIDType OptionSelfCloseSysID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType CancelTime
        TThostFtdcExecResultType ExecResult
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcUserIDType ActiveUserID
        TThostFtdcSequenceNoType BrokerOptionSelfCloseSeq
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcOldIPAddressType reserve3
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcOptionSelfCloseActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OptionSelfCloseActionRef
        TThostFtdcOrderRefType OptionSelfCloseRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OptionSelfCloseSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OptionSelfCloseLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryOptionSelfCloseField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OptionSelfCloseSysID
        TThostFtdcTimeType InsertTimeStart
        TThostFtdcTimeType InsertTimeEnd
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcExchangeOptionSelfCloseField:
        TThostFtdcVolumeType Volume
        TThostFtdcRequestIDType RequestID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcOptSelfCloseFlagType OptSelfCloseFlag
        TThostFtdcOrderLocalIDType OptionSelfCloseLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcOrderSysIDType OptionSelfCloseSysID
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType CancelTime
        TThostFtdcExecResultType ExecResult
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcBranchIDType BranchID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryOptionSelfCloseActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcExchangeOptionSelfCloseActionField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OptionSelfCloseSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OptionSelfCloseLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcBranchIDType BranchID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcMacAddressType MacAddress
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcOptSelfCloseFlagType OptSelfCloseFlag
        TThostFtdcIPAddressType IPAddress
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcSyncDelaySwapField:
        TThostFtdcDepositSeqNoType DelaySwapSeqNo
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcCurrencyIDType FromCurrencyID
        TThostFtdcMoneyType FromAmount
        TThostFtdcMoneyType FromFrozenSwap
        TThostFtdcMoneyType FromRemainSwap
        TThostFtdcCurrencyIDType ToCurrencyID
        TThostFtdcMoneyType ToAmount
        TThostFtdcBoolType IsManualSwap
        TThostFtdcBoolType IsAllRemainSetZero
    cdef struct CThostFtdcQrySyncDelaySwapField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcDepositSeqNoType DelaySwapSeqNo
    cdef struct CThostFtdcInvestUnitField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcPartyNameType InvestorUnitName
        TThostFtdcInvestorIDType InvestorGroupID
        TThostFtdcInvestorIDType CommModelID
        TThostFtdcInvestorIDType MarginModelID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcQryInvestUnitField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcSecAgentCheckModeField:
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcAccountIDType BrokerSecAgentID
        TThostFtdcBoolType CheckSelfAccount
    cdef struct CThostFtdcSecAgentTradeInfoField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType BrokerSecAgentID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcMarketDataField:
        TThostFtdcDateType TradingDay
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcPriceType LastPrice
        TThostFtdcPriceType PreSettlementPrice
        TThostFtdcPriceType PreClosePrice
        TThostFtdcLargeVolumeType PreOpenInterest
        TThostFtdcPriceType OpenPrice
        TThostFtdcPriceType HighestPrice
        TThostFtdcPriceType LowestPrice
        TThostFtdcVolumeType Volume
        TThostFtdcMoneyType Turnover
        TThostFtdcLargeVolumeType OpenInterest
        TThostFtdcPriceType ClosePrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcPriceType UpperLimitPrice
        TThostFtdcPriceType LowerLimitPrice
        TThostFtdcRatioType PreDelta
        TThostFtdcRatioType CurrDelta
        TThostFtdcTimeType UpdateTime
        TThostFtdcMillisecType UpdateMillisec
        TThostFtdcDateType ActionDay
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcMarketDataBaseField:
        TThostFtdcDateType TradingDay
        TThostFtdcPriceType PreSettlementPrice
        TThostFtdcPriceType PreClosePrice
        TThostFtdcLargeVolumeType PreOpenInterest
        TThostFtdcRatioType PreDelta
    cdef struct CThostFtdcMarketDataStaticField:
        TThostFtdcPriceType OpenPrice
        TThostFtdcPriceType HighestPrice
        TThostFtdcPriceType LowestPrice
        TThostFtdcPriceType ClosePrice
        TThostFtdcPriceType UpperLimitPrice
        TThostFtdcPriceType LowerLimitPrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcRatioType CurrDelta
    cdef struct CThostFtdcMarketDataLastMatchField:
        TThostFtdcPriceType LastPrice
        TThostFtdcVolumeType Volume
        TThostFtdcMoneyType Turnover
        TThostFtdcLargeVolumeType OpenInterest
    cdef struct CThostFtdcMarketDataBestPriceField:
        TThostFtdcPriceType BidPrice1
        TThostFtdcVolumeType BidVolume1
        TThostFtdcPriceType AskPrice1
        TThostFtdcVolumeType AskVolume1
    cdef struct CThostFtdcMarketDataBid23Field:
        TThostFtdcPriceType BidPrice2
        TThostFtdcVolumeType BidVolume2
        TThostFtdcPriceType BidPrice3
        TThostFtdcVolumeType BidVolume3
    cdef struct CThostFtdcMarketDataAsk23Field:
        TThostFtdcPriceType AskPrice2
        TThostFtdcVolumeType AskVolume2
        TThostFtdcPriceType AskPrice3
        TThostFtdcVolumeType AskVolume3
    cdef struct CThostFtdcMarketDataBid45Field:
        TThostFtdcPriceType BidPrice4
        TThostFtdcVolumeType BidVolume4
        TThostFtdcPriceType BidPrice5
        TThostFtdcVolumeType BidVolume5
    cdef struct CThostFtdcMarketDataAsk45Field:
        TThostFtdcPriceType AskPrice4
        TThostFtdcVolumeType AskVolume4
        TThostFtdcPriceType AskPrice5
        TThostFtdcVolumeType AskVolume5
    cdef struct CThostFtdcMarketDataUpdateTimeField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcTimeType UpdateTime
        TThostFtdcMillisecType UpdateMillisec
        TThostFtdcDateType ActionDay
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcMarketDataBandingPriceField:
        TThostFtdcPriceType BandingUpperPrice
        TThostFtdcPriceType BandingLowerPrice
    cdef struct CThostFtdcMarketDataExchangeField:
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcSpecificInstrumentField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInstrumentStatusField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcSettlementGroupIDType SettlementGroupID
        TThostFtdcOldInstrumentIDType reserve2
        TThostFtdcInstrumentStatusType InstrumentStatus
        TThostFtdcTradingSegmentSNType TradingSegmentSN
        TThostFtdcTimeType EnterTime
        TThostFtdcInstStatusEnterReasonType EnterReason
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryInstrumentStatusField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldExchangeInstIDType reserve1
        TThostFtdcExchangeInstIDType ExchangeInstID
    cdef struct CThostFtdcInvestorAccountField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcPositionProfitAlgorithmField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcAlgorithmType Algorithm
        TThostFtdcMemoType Memo
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcDiscountField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType Discount
    cdef struct CThostFtdcQryTransferBankField:
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBrchID
    cdef struct CThostFtdcTransferBankField:
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBrchID
        TThostFtdcBankNameType BankName
        TThostFtdcBoolType IsActive
    cdef struct CThostFtdcQryInvestorPositionDetailField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcInvestorPositionDetailField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcDirectionType Direction
        TThostFtdcDateType OpenDate
        TThostFtdcTradeIDType TradeID
        TThostFtdcVolumeType Volume
        TThostFtdcPriceType OpenPrice
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcTradeTypeType TradeType
        TThostFtdcOldInstrumentIDType reserve2
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcMoneyType CloseProfitByDate
        TThostFtdcMoneyType CloseProfitByTrade
        TThostFtdcMoneyType PositionProfitByDate
        TThostFtdcMoneyType PositionProfitByTrade
        TThostFtdcMoneyType Margin
        TThostFtdcMoneyType ExchMargin
        TThostFtdcRatioType MarginRateByMoney
        TThostFtdcRatioType MarginRateByVolume
        TThostFtdcPriceType LastSettlementPrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcVolumeType CloseVolume
        TThostFtdcMoneyType CloseAmount
        TThostFtdcVolumeType TimeFirstVolume
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcSpecPosiTypeType SpecPosiType
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcInstrumentIDType CombInstrumentID
    cdef struct CThostFtdcTradingAccountPasswordField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcMDTraderOfferField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcTraderIDType TraderID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcTraderConnectStatusType TraderConnectStatus
        TThostFtdcDateType ConnectRequestDate
        TThostFtdcTimeType ConnectRequestTime
        TThostFtdcDateType LastReportDate
        TThostFtdcTimeType LastReportTime
        TThostFtdcDateType ConnectDate
        TThostFtdcTimeType ConnectTime
        TThostFtdcDateType StartDate
        TThostFtdcTimeType StartTime
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcTradeIDType MaxTradeID
        TThostFtdcReturnCodeType MaxOrderMessageReference
    cdef struct CThostFtdcQryMDTraderOfferField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcTraderIDType TraderID
    cdef struct CThostFtdcQryNoticeField:
        TThostFtdcBrokerIDType BrokerID
    cdef struct CThostFtdcNoticeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcContentType Content
        TThostFtdcSequenceLabelType SequenceLabel
    cdef struct CThostFtdcUserRightField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcUserRightTypeType UserRightType
        TThostFtdcBoolType IsForbidden
    cdef struct CThostFtdcQrySettlementInfoConfirmField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcLoadSettlementInfoField:
        TThostFtdcBrokerIDType BrokerID
    cdef struct CThostFtdcBrokerWithdrawAlgorithmField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAlgorithmType WithdrawAlgorithm
        TThostFtdcRatioType UsingRatio
        TThostFtdcIncludeCloseProfitType IncludeCloseProfit
        TThostFtdcAllWithoutTradeType AllWithoutTrade
        TThostFtdcIncludeCloseProfitType AvailIncludeCloseProfit
        TThostFtdcBoolType IsBrokerUserEvent
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcRatioType FundMortgageRatio
        TThostFtdcBalanceAlgorithmType BalanceAlgorithm
    cdef struct CThostFtdcTradingAccountPasswordUpdateV1Field:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcPasswordType OldPassword
        TThostFtdcPasswordType NewPassword
    cdef struct CThostFtdcTradingAccountPasswordUpdateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType OldPassword
        TThostFtdcPasswordType NewPassword
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcQryCombinationLegField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcLegIDType LegID
        TThostFtdcOldInstrumentIDType reserve2
        TThostFtdcInstrumentIDType CombInstrumentID
        TThostFtdcInstrumentIDType LegInstrumentID
    cdef struct CThostFtdcQrySyncStatusField:
        TThostFtdcDateType TradingDay
    cdef struct CThostFtdcCombinationLegField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcLegIDType LegID
        TThostFtdcOldInstrumentIDType reserve2
        TThostFtdcDirectionType Direction
        TThostFtdcLegMultipleType LegMultiple
        TThostFtdcImplyLevelType ImplyLevel
        TThostFtdcInstrumentIDType CombInstrumentID
        TThostFtdcInstrumentIDType LegInstrumentID
    cdef struct CThostFtdcSyncStatusField:
        TThostFtdcDateType TradingDay
        TThostFtdcDataSyncStatusType DataSyncStatus
    cdef struct CThostFtdcQryLinkManField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcLinkManField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcPersonTypeType PersonType
        TThostFtdcIdCardTypeType IdentifiedCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcPartyNameType PersonName
        TThostFtdcTelephoneType Telephone
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcPriorityType Priority
        TThostFtdcUOAZipCodeType UOAZipCode
        TThostFtdcInvestorFullNameType PersonFullName
    cdef struct CThostFtdcQryBrokerUserEventField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcUserEventTypeType UserEventType
    cdef struct CThostFtdcBrokerUserEventField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcUserEventTypeType UserEventType
        TThostFtdcSequenceNoType EventSequenceNo
        TThostFtdcDateType EventDate
        TThostFtdcTimeType EventTime
        TThostFtdcUserEventInfoType UserEventInfo
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryContractBankField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBrchID
    cdef struct CThostFtdcContractBankField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBrchID
        TThostFtdcBankNameType BankName
    cdef struct CThostFtdcInvestorPositionCombineDetailField:
        TThostFtdcDateType TradingDay
        TThostFtdcDateType OpenDate
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcTradeIDType ComTradeID
        TThostFtdcTradeIDType TradeID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcDirectionType Direction
        TThostFtdcVolumeType TotalAmt
        TThostFtdcMoneyType Margin
        TThostFtdcMoneyType ExchMargin
        TThostFtdcRatioType MarginRateByMoney
        TThostFtdcRatioType MarginRateByVolume
        TThostFtdcLegIDType LegID
        TThostFtdcLegMultipleType LegMultiple
        TThostFtdcOldInstrumentIDType reserve2
        TThostFtdcTradeGroupIDType TradeGroupID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcInstrumentIDType CombInstrumentID
    cdef struct CThostFtdcParkedOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcOrderPriceTypeType OrderPriceType
        TThostFtdcDirectionType Direction
        TThostFtdcCombOffsetFlagType CombOffsetFlag
        TThostFtdcCombHedgeFlagType CombHedgeFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeTotalOriginal
        TThostFtdcTimeConditionType TimeCondition
        TThostFtdcDateType GTDDate
        TThostFtdcVolumeConditionType VolumeCondition
        TThostFtdcVolumeType MinVolume
        TThostFtdcContingentConditionType ContingentCondition
        TThostFtdcPriceType StopPrice
        TThostFtdcForceCloseReasonType ForceCloseReason
        TThostFtdcBoolType IsAutoSuspend
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcRequestIDType RequestID
        TThostFtdcBoolType UserForceClose
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParkedOrderIDType ParkedOrderID
        TThostFtdcUserTypeType UserType
        TThostFtdcParkedOrderStatusType Status
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcBoolType IsSwapOrder
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcClientIDType ClientID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcParkedOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OrderActionRef
        TThostFtdcOrderRefType OrderRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeChange
        TThostFtdcUserIDType UserID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcParkedOrderActionIDType ParkedOrderActionID
        TThostFtdcUserTypeType UserType
        TThostFtdcParkedOrderStatusType Status
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryParkedOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryParkedOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcRemoveParkedOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcParkedOrderIDType ParkedOrderID
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcRemoveParkedOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcParkedOrderActionIDType ParkedOrderActionID
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcInvestorWithdrawAlgorithmField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType UsingRatio
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcRatioType FundMortgageRatio
    cdef struct CThostFtdcQryInvestorPositionCombineDetailField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType CombInstrumentID
    cdef struct CThostFtdcMarketDataAveragePriceField:
        TThostFtdcPriceType AveragePrice
    cdef struct CThostFtdcVerifyInvestorPasswordField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcPasswordType Password
    cdef struct CThostFtdcUserIPField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcIPAddressType IPAddress
        TThostFtdcIPAddressType IPMask
    cdef struct CThostFtdcTradingNoticeInfoField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcTimeType SendTime
        TThostFtdcContentType FieldContent
        TThostFtdcSequenceSeriesType SequenceSeries
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcTradingNoticeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcSequenceSeriesType SequenceSeries
        TThostFtdcUserIDType UserID
        TThostFtdcTimeType SendTime
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcContentType FieldContent
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcQryTradingNoticeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcQryErrOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcErrOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcOrderPriceTypeType OrderPriceType
        TThostFtdcDirectionType Direction
        TThostFtdcCombOffsetFlagType CombOffsetFlag
        TThostFtdcCombHedgeFlagType CombHedgeFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeTotalOriginal
        TThostFtdcTimeConditionType TimeCondition
        TThostFtdcDateType GTDDate
        TThostFtdcVolumeConditionType VolumeCondition
        TThostFtdcVolumeType MinVolume
        TThostFtdcContingentConditionType ContingentCondition
        TThostFtdcPriceType StopPrice
        TThostFtdcForceCloseReasonType ForceCloseReason
        TThostFtdcBoolType IsAutoSuspend
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcRequestIDType RequestID
        TThostFtdcBoolType UserForceClose
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcBoolType IsSwapOrder
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcErrorConditionalOrderField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcOrderRefType OrderRef
        TThostFtdcUserIDType UserID
        TThostFtdcOrderPriceTypeType OrderPriceType
        TThostFtdcDirectionType Direction
        TThostFtdcCombOffsetFlagType CombOffsetFlag
        TThostFtdcCombHedgeFlagType CombHedgeFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeTotalOriginal
        TThostFtdcTimeConditionType TimeCondition
        TThostFtdcDateType GTDDate
        TThostFtdcVolumeConditionType VolumeCondition
        TThostFtdcVolumeType MinVolume
        TThostFtdcContingentConditionType ContingentCondition
        TThostFtdcPriceType StopPrice
        TThostFtdcForceCloseReasonType ForceCloseReason
        TThostFtdcBoolType IsAutoSuspend
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcRequestIDType RequestID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcOldExchangeInstIDType reserve2
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderSubmitStatusType OrderSubmitStatus
        TThostFtdcSequenceNoType NotifySequence
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcOrderSourceType OrderSource
        TThostFtdcOrderStatusType OrderStatus
        TThostFtdcOrderTypeType OrderType
        TThostFtdcVolumeType VolumeTraded
        TThostFtdcVolumeType VolumeTotal
        TThostFtdcDateType InsertDate
        TThostFtdcTimeType InsertTime
        TThostFtdcTimeType ActiveTime
        TThostFtdcTimeType SuspendTime
        TThostFtdcTimeType UpdateTime
        TThostFtdcTimeType CancelTime
        TThostFtdcTraderIDType ActiveTraderID
        TThostFtdcParticipantIDType ClearingPartID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcBoolType UserForceClose
        TThostFtdcUserIDType ActiveUserID
        TThostFtdcSequenceNoType BrokerOrderSeq
        TThostFtdcOrderSysIDType RelativeOrderSysID
        TThostFtdcVolumeType ZCETotalTradedVolume
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcBoolType IsSwapOrder
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcOldIPAddressType reserve3
        TThostFtdcMacAddressType MacAddress
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryErrOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcErrOrderActionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOrderActionRefType OrderActionRef
        TThostFtdcOrderRefType OrderRef
        TThostFtdcRequestIDType RequestID
        TThostFtdcFrontIDType FrontID
        TThostFtdcSessionIDType SessionID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOrderSysIDType OrderSysID
        TThostFtdcActionFlagType ActionFlag
        TThostFtdcPriceType LimitPrice
        TThostFtdcVolumeType VolumeChange
        TThostFtdcDateType ActionDate
        TThostFtdcTimeType ActionTime
        TThostFtdcTraderIDType TraderID
        TThostFtdcInstallIDType InstallID
        TThostFtdcOrderLocalIDType OrderLocalID
        TThostFtdcOrderLocalIDType ActionLocalID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcClientIDType ClientID
        TThostFtdcBusinessUnitType BusinessUnit
        TThostFtdcOrderActionStatusType OrderActionStatus
        TThostFtdcUserIDType UserID
        TThostFtdcErrorMsgType StatusMsg
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBranchIDType BranchID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcOldIPAddressType reserve2
        TThostFtdcMacAddressType MacAddress
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryExchangeSequenceField:
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcExchangeSequenceField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcInstrumentStatusType MarketStatus
    cdef struct CThostFtdcQryMaxOrderVolumeWithPriceField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcDirectionType Direction
        TThostFtdcOffsetFlagType OffsetFlag
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcVolumeType MaxVolume
        TThostFtdcPriceType Price
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryBrokerTradingParamsField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcAccountIDType AccountID
    cdef struct CThostFtdcBrokerTradingParamsField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcMarginPriceTypeType MarginPriceType
        TThostFtdcAlgorithmType Algorithm
        TThostFtdcIncludeCloseProfitType AvailIncludeCloseProfit
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcOptionRoyaltyPriceTypeType OptionRoyaltyPriceType
        TThostFtdcAccountIDType AccountID
    cdef struct CThostFtdcQryBrokerTradingAlgosField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcBrokerTradingAlgosField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHandlePositionAlgoIDType HandlePositionAlgoID
        TThostFtdcFindMarginRateAlgoIDType FindMarginRateAlgoID
        TThostFtdcHandleTradingAccountAlgoIDType HandleTradingAccountAlgoID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQueryBrokerDepositField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcExchangeIDType ExchangeID
    cdef struct CThostFtdcBrokerDepositField:
        TThostFtdcTradeDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcMoneyType PreBalance
        TThostFtdcMoneyType CurrMargin
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType Balance
        TThostFtdcMoneyType Deposit
        TThostFtdcMoneyType Withdraw
        TThostFtdcMoneyType Available
        TThostFtdcMoneyType Reserve
        TThostFtdcMoneyType FrozenMargin
    cdef struct CThostFtdcQryCFMMCBrokerKeyField:
        TThostFtdcBrokerIDType BrokerID
    cdef struct CThostFtdcCFMMCBrokerKeyField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcDateType CreateDate
        TThostFtdcTimeType CreateTime
        TThostFtdcSequenceNoType KeyID
        TThostFtdcCFMMCKeyType CurrentKey
        TThostFtdcCFMMCKeyKindType KeyKind
    cdef struct CThostFtdcCFMMCTradingAccountKeyField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcAccountIDType AccountID
        TThostFtdcSequenceNoType KeyID
        TThostFtdcCFMMCKeyType CurrentKey
    cdef struct CThostFtdcQryCFMMCTradingAccountKeyField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcBrokerUserOTPParamField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcOTPVendorsIDType OTPVendorsID
        TThostFtdcSerialNumberType SerialNumber
        TThostFtdcAuthKeyType AuthKey
        TThostFtdcLastDriftType LastDrift
        TThostFtdcLastSuccessType LastSuccess
        TThostFtdcOTPTypeType OTPType
    cdef struct CThostFtdcManualSyncBrokerUserOTPField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcOTPTypeType OTPType
        TThostFtdcPasswordType FirstOTP
        TThostFtdcPasswordType SecondOTP
    cdef struct CThostFtdcCommRateModelField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType CommModelID
        TThostFtdcCommModelNameType CommModelName
    cdef struct CThostFtdcQryCommRateModelField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType CommModelID
    cdef struct CThostFtdcMarginModelField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType MarginModelID
        TThostFtdcCommModelNameType MarginModelName
    cdef struct CThostFtdcQryMarginModelField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType MarginModelID
    cdef struct CThostFtdcEWarrantOffsetField:
        TThostFtdcTradeDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcDirectionType Direction
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcVolumeType Volume
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryEWarrantOffsetField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryInvestorProductGroupMarginField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType ProductGroupID
    cdef struct CThostFtdcInvestorProductGroupMarginField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcMoneyType FrozenMargin
        TThostFtdcMoneyType LongFrozenMargin
        TThostFtdcMoneyType ShortFrozenMargin
        TThostFtdcMoneyType UseMargin
        TThostFtdcMoneyType LongUseMargin
        TThostFtdcMoneyType ShortUseMargin
        TThostFtdcMoneyType ExchMargin
        TThostFtdcMoneyType LongExchMargin
        TThostFtdcMoneyType ShortExchMargin
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType FrozenCommission
        TThostFtdcMoneyType Commission
        TThostFtdcMoneyType FrozenCash
        TThostFtdcMoneyType CashIn
        TThostFtdcMoneyType PositionProfit
        TThostFtdcMoneyType OffsetAmount
        TThostFtdcMoneyType LongOffsetAmount
        TThostFtdcMoneyType ShortOffsetAmount
        TThostFtdcMoneyType ExchOffsetAmount
        TThostFtdcMoneyType LongExchOffsetAmount
        TThostFtdcMoneyType ShortExchOffsetAmount
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcInstrumentIDType ProductGroupID
    cdef struct CThostFtdcQueryCFMMCTradingAccountTokenField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcInvestUnitIDType InvestUnitID
    cdef struct CThostFtdcCFMMCTradingAccountTokenField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcParticipantIDType ParticipantID
        TThostFtdcAccountIDType AccountID
        TThostFtdcSequenceNoType KeyID
        TThostFtdcCFMMCTokenType Token
    cdef struct CThostFtdcQryProductGroupField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType ProductID
    cdef struct CThostFtdcProductGroupField:
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcOldInstrumentIDType reserve2
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcInstrumentIDType ProductGroupID
    cdef struct CThostFtdcBulletinField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcDateType TradingDay
        TThostFtdcBulletinIDType BulletinID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcNewsTypeType NewsType
        TThostFtdcNewsUrgencyType NewsUrgency
        TThostFtdcTimeType SendTime
        TThostFtdcAbstractType Abstract
        TThostFtdcComeFromType ComeFrom
        TThostFtdcContentType Content
        TThostFtdcURLLinkType URLLink
        TThostFtdcMarketIDType MarketID
    cdef struct CThostFtdcQryBulletinField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcBulletinIDType BulletinID
        TThostFtdcSequenceNoType SequenceNo
        TThostFtdcNewsTypeType NewsType
        TThostFtdcNewsUrgencyType NewsUrgency
    cdef struct CThostFtdcMulticastInstrumentField:
        TThostFtdcInstallIDType TopicID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstallIDType InstrumentNo
        TThostFtdcPriceType CodePrice
        TThostFtdcVolumeMultipleType VolumeMultiple
        TThostFtdcPriceType PriceTick
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryMulticastInstrumentField:
        TThostFtdcInstallIDType TopicID
        TThostFtdcOldInstrumentIDType reserve1
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcAppIDAuthAssignField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAppIDType AppID
        TThostFtdcDRIdentityIDType DRIdentityID
    cdef struct CThostFtdcReqOpenAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcCashExchangeCodeType CashExchangeCode
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcTIDType TID
        TThostFtdcUserIDType UserID
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcReqCancelAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcCashExchangeCodeType CashExchangeCode
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcTIDType TID
        TThostFtdcUserIDType UserID
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcReqChangeAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcBankAccountType NewBankAccount
        TThostFtdcPasswordType NewBankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcTIDType TID
        TThostFtdcDigestType Digest
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcReqTransferField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcUserIDType UserID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcTradeAmountType TradeAmount
        TThostFtdcTradeAmountType FutureFetchAmount
        TThostFtdcFeePayFlagType FeePayFlag
        TThostFtdcCustFeeType CustFee
        TThostFtdcFutureFeeType BrokerFee
        TThostFtdcAddInfoType Message
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcTransferStatusType TransferStatus
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcRspTransferField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcUserIDType UserID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcTradeAmountType TradeAmount
        TThostFtdcTradeAmountType FutureFetchAmount
        TThostFtdcFeePayFlagType FeePayFlag
        TThostFtdcCustFeeType CustFee
        TThostFtdcFutureFeeType BrokerFee
        TThostFtdcAddInfoType Message
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcTransferStatusType TransferStatus
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcReqRepealField:
        TThostFtdcRepealTimeIntervalType RepealTimeInterval
        TThostFtdcRepealedTimesType RepealedTimes
        TThostFtdcBankRepealFlagType BankRepealFlag
        TThostFtdcBrokerRepealFlagType BrokerRepealFlag
        TThostFtdcPlateSerialType PlateRepealSerial
        TThostFtdcBankSerialType BankRepealSerial
        TThostFtdcFutureSerialType FutureRepealSerial
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcUserIDType UserID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcTradeAmountType TradeAmount
        TThostFtdcTradeAmountType FutureFetchAmount
        TThostFtdcFeePayFlagType FeePayFlag
        TThostFtdcCustFeeType CustFee
        TThostFtdcFutureFeeType BrokerFee
        TThostFtdcAddInfoType Message
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcTransferStatusType TransferStatus
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcRspRepealField:
        TThostFtdcRepealTimeIntervalType RepealTimeInterval
        TThostFtdcRepealedTimesType RepealedTimes
        TThostFtdcBankRepealFlagType BankRepealFlag
        TThostFtdcBrokerRepealFlagType BrokerRepealFlag
        TThostFtdcPlateSerialType PlateRepealSerial
        TThostFtdcBankSerialType BankRepealSerial
        TThostFtdcFutureSerialType FutureRepealSerial
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcUserIDType UserID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcTradeAmountType TradeAmount
        TThostFtdcTradeAmountType FutureFetchAmount
        TThostFtdcFeePayFlagType FeePayFlag
        TThostFtdcCustFeeType CustFee
        TThostFtdcFutureFeeType BrokerFee
        TThostFtdcAddInfoType Message
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcTransferStatusType TransferStatus
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcReqQueryAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcRspQueryAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcTradeAmountType BankUseAmount
        TThostFtdcTradeAmountType BankFetchAmount
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcFutureSignIOField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcDigestType Digest
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
    cdef struct CThostFtdcRspFutureSignInField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcDigestType Digest
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcPasswordKeyType PinKey
        TThostFtdcPasswordKeyType MacKey
    cdef struct CThostFtdcReqFutureSignOutField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcDigestType Digest
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
    cdef struct CThostFtdcRspFutureSignOutField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcDigestType Digest
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcReqQueryTradeResultBySerialField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcSerialType Reference
        TThostFtdcInstitutionTypeType RefrenceIssureType
        TThostFtdcOrganCodeType RefrenceIssure
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcTradeAmountType TradeAmount
        TThostFtdcDigestType Digest
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcRspQueryTradeResultBySerialField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcSerialType Reference
        TThostFtdcInstitutionTypeType RefrenceIssureType
        TThostFtdcOrganCodeType RefrenceIssure
        TThostFtdcReturnCodeType OriginReturnCode
        TThostFtdcDescrInfoForReturnCodeType OriginDescrInfoForReturnCode
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcTradeAmountType TradeAmount
        TThostFtdcDigestType Digest
    cdef struct CThostFtdcReqDayEndFileReadyField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcFileBusinessCodeType FileBusinessCode
        TThostFtdcDigestType Digest
    cdef struct CThostFtdcReturnResultField:
        TThostFtdcReturnCodeType ReturnCode
        TThostFtdcDescrInfoForReturnCodeType DescrInfoForReturnCode
    cdef struct CThostFtdcVerifyFuturePasswordField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcInstallIDType InstallID
        TThostFtdcTIDType TID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcVerifyCustInfoField:
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcVerifyFuturePasswordAndCustInfoField:
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcDepositResultInformField:
        TThostFtdcDepositSeqNoType DepositSeqNo
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcMoneyType Deposit
        TThostFtdcRequestIDType RequestID
        TThostFtdcReturnCodeType ReturnCode
        TThostFtdcDescrInfoForReturnCodeType DescrInfoForReturnCode
    cdef struct CThostFtdcReqSyncKeyField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcAddInfoType Message
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
    cdef struct CThostFtdcRspSyncKeyField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcAddInfoType Message
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcNotifyQueryAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcTradeAmountType BankUseAmount
        TThostFtdcTradeAmountType BankFetchAmount
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcTransferSerialField:
        TThostFtdcPlateSerialType PlateSerial
        TThostFtdcTradeDateType TradeDate
        TThostFtdcDateType TradingDay
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcSessionIDType SessionID
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcBankAccountType BankAccount
        TThostFtdcBankSerialType BankSerial
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcFutureAccTypeType FutureAccType
        TThostFtdcAccountIDType AccountID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcFutureSerialType FutureSerial
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcTradeAmountType TradeAmount
        TThostFtdcCustFeeType CustFee
        TThostFtdcFutureFeeType BrokerFee
        TThostFtdcAvailabilityFlagType AvailabilityFlag
        TThostFtdcOperatorCodeType OperatorCode
        TThostFtdcBankAccountType BankNewAccount
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcQryTransferSerialField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcBankIDType BankID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcNotifyFutureSignInField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcDigestType Digest
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcPasswordKeyType PinKey
        TThostFtdcPasswordKeyType MacKey
    cdef struct CThostFtdcNotifyFutureSignOutField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcDigestType Digest
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcNotifySyncKeyField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcInstallIDType InstallID
        TThostFtdcUserIDType UserID
        TThostFtdcAddInfoType Message
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcOperNoType OperNo
        TThostFtdcRequestIDType RequestID
        TThostFtdcTIDType TID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcQryAccountregisterField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcAccountregisterField:
        TThostFtdcTradeDateType TradeDay
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBankAccountType BankAccount
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcAccountIDType AccountID
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcOpenOrDestroyType OpenOrDestroy
        TThostFtdcTradeDateType RegDate
        TThostFtdcTradeDateType OutDate
        TThostFtdcTIDType TID
        TThostFtdcCustTypeType CustType
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcOpenAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcCashExchangeCodeType CashExchangeCode
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcTIDType TID
        TThostFtdcUserIDType UserID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcCancelAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcCashExchangeCodeType CashExchangeCode
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcDeviceIDType DeviceID
        TThostFtdcBankAccTypeType BankSecuAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcBankAccountType BankSecuAcc
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcOperNoType OperNo
        TThostFtdcTIDType TID
        TThostFtdcUserIDType UserID
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcChangeAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcBankAccountType NewBankAccount
        TThostFtdcPasswordType NewBankPassWord
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcPwdFlagType BankPwdFlag
        TThostFtdcPwdFlagType SecuPwdFlag
        TThostFtdcTIDType TID
        TThostFtdcDigestType Digest
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
        TThostFtdcLongIndividualNameType LongCustomerName
    cdef struct CThostFtdcSecAgentACIDMapField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcAccountIDType BrokerSecAgentID
    cdef struct CThostFtdcQrySecAgentACIDMapField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcAccountIDType AccountID
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcUserRightsAssignField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcDRIdentityIDType DRIdentityID
    cdef struct CThostFtdcBrokerUserRightAssignField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcDRIdentityIDType DRIdentityID
        TThostFtdcBoolType Tradeable
    cdef struct CThostFtdcDRTransferField:
        TThostFtdcDRIdentityIDType OrigDRIdentityID
        TThostFtdcDRIdentityIDType DestDRIdentityID
        TThostFtdcBrokerIDType OrigBrokerID
        TThostFtdcBrokerIDType DestBrokerID
    cdef struct CThostFtdcFensUserInfoField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcLoginModeType LoginMode
    cdef struct CThostFtdcCurrTransferIdentityField:
        TThostFtdcDRIdentityIDType IdentityID
    cdef struct CThostFtdcLoginForbiddenUserField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryLoginForbiddenUserField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcTradingAccountReserveField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcMoneyType Reserve
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcQryLoginForbiddenIPField:
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryIPListField:
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryUserRightsAssignField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcReserveOpenAccountConfirmField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcLongIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcTIDType TID
        TThostFtdcAccountIDType AccountID
        TThostFtdcPasswordType Password
        TThostFtdcBankSerialType BankReserveOpenSeq
        TThostFtdcTradeDateType BookDate
        TThostFtdcPasswordType BookPsw
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcReserveOpenAccountField:
        TThostFtdcTradeCodeType TradeCode
        TThostFtdcBankIDType BankID
        TThostFtdcBankBrchIDType BankBranchID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcFutureBranchIDType BrokerBranchID
        TThostFtdcTradeDateType TradeDate
        TThostFtdcTradeTimeType TradeTime
        TThostFtdcBankSerialType BankSerial
        TThostFtdcTradeDateType TradingDay
        TThostFtdcSerialType PlateSerial
        TThostFtdcLastFragmentType LastFragment
        TThostFtdcSessionIDType SessionID
        TThostFtdcLongIndividualNameType CustomerName
        TThostFtdcIdCardTypeType IdCardType
        TThostFtdcIdentifiedCardNoType IdentifiedCardNo
        TThostFtdcGenderType Gender
        TThostFtdcCountryCodeType CountryCode
        TThostFtdcCustTypeType CustType
        TThostFtdcAddressType Address
        TThostFtdcZipCodeType ZipCode
        TThostFtdcTelephoneType Telephone
        TThostFtdcMobilePhoneType MobilePhone
        TThostFtdcFaxType Fax
        TThostFtdcEMailType EMail
        TThostFtdcMoneyAccountStatusType MoneyAccountStatus
        TThostFtdcBankAccountType BankAccount
        TThostFtdcPasswordType BankPassWord
        TThostFtdcInstallIDType InstallID
        TThostFtdcYesNoIndicatorType VerifyCertNoFlag
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcDigestType Digest
        TThostFtdcBankAccTypeType BankAccType
        TThostFtdcBankCodingForFutureType BrokerIDByBank
        TThostFtdcTIDType TID
        TThostFtdcReserveOpenAccStasType ReserveOpenAccStas
        TThostFtdcErrorIDType ErrorID
        TThostFtdcErrorMsgType ErrorMsg
    cdef struct CThostFtdcAccountPropertyField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcBankIDType BankID
        TThostFtdcBankAccountType BankAccount
        TThostFtdcInvestorFullNameType OpenName
        TThostFtdcOpenBankType OpenBank
        TThostFtdcBoolType IsActive
        TThostFtdcAccountSourceTypeType AccountSourceType
        TThostFtdcDateType OpenDate
        TThostFtdcDateType CancelDate
        TThostFtdcOperatorIDType OperatorID
        TThostFtdcDateType OperateDate
        TThostFtdcTimeType OperateTime
        TThostFtdcCurrencyIDType CurrencyID
    cdef struct CThostFtdcQryCurrDRIdentityField:
        TThostFtdcDRIdentityIDType DRIdentityID
    cdef struct CThostFtdcCurrDRIdentityField:
        TThostFtdcDRIdentityIDType DRIdentityID
    cdef struct CThostFtdcQrySecAgentCheckModeField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcQrySecAgentTradeInfoField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType BrokerSecAgentID
    cdef struct CThostFtdcReqUserAuthMethodField:
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcRspUserAuthMethodField:
        TThostFtdcCurrentAuthMethodType UsableAuthMethod
    cdef struct CThostFtdcReqGenUserCaptchaField:
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcRspGenUserCaptchaField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcCaptchaInfoLenType CaptchaInfoLen
        TThostFtdcCaptchaInfoType CaptchaInfo
    cdef struct CThostFtdcReqGenUserTextField:
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
    cdef struct CThostFtdcRspGenUserTextField:
        TThostFtdcUserTextSeqType UserTextSeq
    cdef struct CThostFtdcReqUserLoginWithCaptchaField:
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcPasswordType Password
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcProductInfoType InterfaceProductInfo
        TThostFtdcProtocolInfoType ProtocolInfo
        TThostFtdcMacAddressType MacAddress
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcLoginRemarkType LoginRemark
        TThostFtdcPasswordType Captcha
        TThostFtdcIPPortType ClientIPPort
        TThostFtdcIPAddressType ClientIPAddress
    cdef struct CThostFtdcReqUserLoginWithTextField:
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcPasswordType Password
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcProductInfoType InterfaceProductInfo
        TThostFtdcProtocolInfoType ProtocolInfo
        TThostFtdcMacAddressType MacAddress
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcLoginRemarkType LoginRemark
        TThostFtdcPasswordType Text
        TThostFtdcIPPortType ClientIPPort
        TThostFtdcIPAddressType ClientIPAddress
    cdef struct CThostFtdcReqUserLoginWithOTPField:
        TThostFtdcDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcPasswordType Password
        TThostFtdcProductInfoType UserProductInfo
        TThostFtdcProductInfoType InterfaceProductInfo
        TThostFtdcProtocolInfoType ProtocolInfo
        TThostFtdcMacAddressType MacAddress
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcLoginRemarkType LoginRemark
        TThostFtdcPasswordType OTPPassword
        TThostFtdcIPPortType ClientIPPort
        TThostFtdcIPAddressType ClientIPAddress
    cdef struct CThostFtdcReqApiHandshakeField:
        TThostFtdcCryptoKeyVersionType CryptoKeyVersion
    cdef struct CThostFtdcRspApiHandshakeField:
        TThostFtdcHandshakeDataLenType FrontHandshakeDataLen
        TThostFtdcHandshakeDataType FrontHandshakeData
        TThostFtdcBoolType IsApiAuthEnabled
    cdef struct CThostFtdcReqVerifyApiKeyField:
        TThostFtdcHandshakeDataLenType ApiHandshakeDataLen
        TThostFtdcHandshakeDataType ApiHandshakeData
    cdef struct CThostFtdcDepartmentUserField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcDepartmentRangeType InvestorRange
        TThostFtdcInvestorIDType InvestorID
    cdef struct CThostFtdcQueryFreqField:
        TThostFtdcQueryFreqType QueryFreq
    cdef struct CThostFtdcAuthForbiddenIPField:
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryAuthForbiddenIPField:
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcSyncDelaySwapFrozenField:
        TThostFtdcDepositSeqNoType DelaySwapSeqNo
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcCurrencyIDType FromCurrencyID
        TThostFtdcMoneyType FromRemainSwap
        TThostFtdcBoolType IsManualSwap
    cdef struct CThostFtdcUserSystemInfoField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcUserIDType UserID
        TThostFtdcSystemInfoLenType ClientSystemInfoLen
        TThostFtdcClientSystemInfoType ClientSystemInfo
        TThostFtdcOldIPAddressType reserve1
        TThostFtdcIPPortType ClientIPPort
        TThostFtdcTimeType ClientLoginTime
        TThostFtdcAppIDType ClientAppID
        TThostFtdcIPAddressType ClientPublicIP
        TThostFtdcClientLoginRemarkType ClientLoginRemark
    cdef struct CThostFtdcAuthUserIDField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAppIDType AppID
        TThostFtdcUserIDType UserID
        TThostFtdcAuthTypeType AuthType
    cdef struct CThostFtdcAuthIPField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAppIDType AppID
        TThostFtdcIPAddressType IPAddress
    cdef struct CThostFtdcQryClassifiedInstrumentField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcTradingTypeType TradingType
        TThostFtdcClassTypeType ClassType
    cdef struct CThostFtdcQryCombPromotionParamField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcCombPromotionParamField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcCombHedgeFlagType CombHedgeFlag
        TThostFtdcDiscountRatioType Xparameter
    cdef struct CThostFtdcQryRiskSettleInvstPositionField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcInstrumentIDType InstrumentID
    cdef struct CThostFtdcQryRiskSettleProductStatusField:
        TThostFtdcInstrumentIDType ProductID
    cdef struct CThostFtdcRiskSettleInvstPositionField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcPosiDirectionType PosiDirection
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcPositionDateType PositionDate
        TThostFtdcVolumeType YdPosition
        TThostFtdcVolumeType Position
        TThostFtdcVolumeType LongFrozen
        TThostFtdcVolumeType ShortFrozen
        TThostFtdcMoneyType LongFrozenAmount
        TThostFtdcMoneyType ShortFrozenAmount
        TThostFtdcVolumeType OpenVolume
        TThostFtdcVolumeType CloseVolume
        TThostFtdcMoneyType OpenAmount
        TThostFtdcMoneyType CloseAmount
        TThostFtdcMoneyType PositionCost
        TThostFtdcMoneyType PreMargin
        TThostFtdcMoneyType UseMargin
        TThostFtdcMoneyType FrozenMargin
        TThostFtdcMoneyType FrozenCash
        TThostFtdcMoneyType FrozenCommission
        TThostFtdcMoneyType CashIn
        TThostFtdcMoneyType Commission
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType PositionProfit
        TThostFtdcPriceType PreSettlementPrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcMoneyType OpenCost
        TThostFtdcMoneyType ExchangeMargin
        TThostFtdcVolumeType CombPosition
        TThostFtdcVolumeType CombLongFrozen
        TThostFtdcVolumeType CombShortFrozen
        TThostFtdcMoneyType CloseProfitByDate
        TThostFtdcMoneyType CloseProfitByTrade
        TThostFtdcVolumeType TodayPosition
        TThostFtdcRatioType MarginRateByMoney
        TThostFtdcRatioType MarginRateByVolume
        TThostFtdcVolumeType StrikeFrozen
        TThostFtdcMoneyType StrikeFrozenAmount
        TThostFtdcVolumeType AbandonFrozen
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcVolumeType YdStrikeFrozen
        TThostFtdcInvestUnitIDType InvestUnitID
        TThostFtdcMoneyType PositionCostOffset
        TThostFtdcVolumeType TasPosition
        TThostFtdcMoneyType TasPositionCost
    cdef struct CThostFtdcRiskSettleProductStatusField:
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcProductStatusType ProductStatus
    cdef struct CThostFtdcSyncDeltaInfoField:
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
        TThostFtdcSyncDeltaStatusType SyncDeltaStatus
        TThostFtdcSyncDescriptionType SyncDescription
        TThostFtdcBoolType IsOnlyTrdDelta
    cdef struct CThostFtdcSyncDeltaProductStatusField:
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcProductStatusType ProductStatus
    cdef struct CThostFtdcSyncDeltaInvstPosDtlField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcDirectionType Direction
        TThostFtdcDateType OpenDate
        TThostFtdcTradeIDType TradeID
        TThostFtdcVolumeType Volume
        TThostFtdcPriceType OpenPrice
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcTradeTypeType TradeType
        TThostFtdcInstrumentIDType CombInstrumentID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcMoneyType CloseProfitByDate
        TThostFtdcMoneyType CloseProfitByTrade
        TThostFtdcMoneyType PositionProfitByDate
        TThostFtdcMoneyType PositionProfitByTrade
        TThostFtdcMoneyType Margin
        TThostFtdcMoneyType ExchMargin
        TThostFtdcRatioType MarginRateByMoney
        TThostFtdcRatioType MarginRateByVolume
        TThostFtdcPriceType LastSettlementPrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcVolumeType CloseVolume
        TThostFtdcMoneyType CloseAmount
        TThostFtdcVolumeType TimeFirstVolume
        TThostFtdcSpecPosiTypeType SpecPosiType
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaInvstPosCombDtlField:
        TThostFtdcDateType TradingDay
        TThostFtdcDateType OpenDate
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcTradeIDType ComTradeID
        TThostFtdcTradeIDType TradeID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcDirectionType Direction
        TThostFtdcVolumeType TotalAmt
        TThostFtdcMoneyType Margin
        TThostFtdcMoneyType ExchMargin
        TThostFtdcRatioType MarginRateByMoney
        TThostFtdcRatioType MarginRateByVolume
        TThostFtdcLegIDType LegID
        TThostFtdcLegMultipleType LegMultiple
        TThostFtdcTradeGroupIDType TradeGroupID
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaTradingAccountField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcAccountIDType AccountID
        TThostFtdcMoneyType PreMortgage
        TThostFtdcMoneyType PreCredit
        TThostFtdcMoneyType PreDeposit
        TThostFtdcMoneyType PreBalance
        TThostFtdcMoneyType PreMargin
        TThostFtdcMoneyType InterestBase
        TThostFtdcMoneyType Interest
        TThostFtdcMoneyType Deposit
        TThostFtdcMoneyType Withdraw
        TThostFtdcMoneyType FrozenMargin
        TThostFtdcMoneyType FrozenCash
        TThostFtdcMoneyType FrozenCommission
        TThostFtdcMoneyType CurrMargin
        TThostFtdcMoneyType CashIn
        TThostFtdcMoneyType Commission
        TThostFtdcMoneyType CloseProfit
        TThostFtdcMoneyType PositionProfit
        TThostFtdcMoneyType Balance
        TThostFtdcMoneyType Available
        TThostFtdcMoneyType WithdrawQuota
        TThostFtdcMoneyType Reserve
        TThostFtdcDateType TradingDay
        TThostFtdcSettlementIDType SettlementID
        TThostFtdcMoneyType Credit
        TThostFtdcMoneyType Mortgage
        TThostFtdcMoneyType ExchangeMargin
        TThostFtdcMoneyType DeliveryMargin
        TThostFtdcMoneyType ExchangeDeliveryMargin
        TThostFtdcMoneyType ReserveBalance
        TThostFtdcCurrencyIDType CurrencyID
        TThostFtdcMoneyType PreFundMortgageIn
        TThostFtdcMoneyType PreFundMortgageOut
        TThostFtdcMoneyType FundMortgageIn
        TThostFtdcMoneyType FundMortgageOut
        TThostFtdcMoneyType FundMortgageAvailable
        TThostFtdcMoneyType MortgageableFund
        TThostFtdcMoneyType SpecProductMargin
        TThostFtdcMoneyType SpecProductFrozenMargin
        TThostFtdcMoneyType SpecProductCommission
        TThostFtdcMoneyType SpecProductFrozenCommission
        TThostFtdcMoneyType SpecProductPositionProfit
        TThostFtdcMoneyType SpecProductCloseProfit
        TThostFtdcMoneyType SpecProductPositionProfitByAlg
        TThostFtdcMoneyType SpecProductExchangeMargin
        TThostFtdcMoneyType FrozenSwap
        TThostFtdcMoneyType RemainSwap
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaInitInvstMarginField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcMoneyType LastRiskTotalInvstMargin
        TThostFtdcMoneyType LastRiskTotalExchMargin
        TThostFtdcMoneyType ThisSyncInvstMargin
        TThostFtdcMoneyType ThisSyncExchMargin
        TThostFtdcMoneyType RemainRiskInvstMargin
        TThostFtdcMoneyType RemainRiskExchMargin
        TThostFtdcMoneyType LastRiskSpecTotalInvstMargin
        TThostFtdcMoneyType LastRiskSpecTotalExchMargin
        TThostFtdcMoneyType ThisSyncSpecInvstMargin
        TThostFtdcMoneyType ThisSyncSpecExchMargin
        TThostFtdcMoneyType RemainRiskSpecInvstMargin
        TThostFtdcMoneyType RemainRiskSpecExchMargin
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaDceCombInstrumentField:
        TThostFtdcInstrumentIDType CombInstrumentID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcTradeGroupIDType TradeGroupID
        TThostFtdcHedgeFlagType CombHedgeFlag
        TThostFtdcDceCombinationTypeType CombinationType
        TThostFtdcDirectionType Direction
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcDiscountRatioType Xparameter
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaInvstMarginRateField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcBoolType IsRelative
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaExchMarginRateField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaOptExchMarginField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcRatioType SShortMarginRatioByMoney
        TThostFtdcMoneyType SShortMarginRatioByVolume
        TThostFtdcRatioType HShortMarginRatioByMoney
        TThostFtdcMoneyType HShortMarginRatioByVolume
        TThostFtdcRatioType AShortMarginRatioByMoney
        TThostFtdcMoneyType AShortMarginRatioByVolume
        TThostFtdcRatioType MShortMarginRatioByMoney
        TThostFtdcMoneyType MShortMarginRatioByVolume
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaOptInvstMarginField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType SShortMarginRatioByMoney
        TThostFtdcMoneyType SShortMarginRatioByVolume
        TThostFtdcRatioType HShortMarginRatioByMoney
        TThostFtdcMoneyType HShortMarginRatioByVolume
        TThostFtdcRatioType AShortMarginRatioByMoney
        TThostFtdcMoneyType AShortMarginRatioByVolume
        TThostFtdcBoolType IsRelative
        TThostFtdcRatioType MShortMarginRatioByMoney
        TThostFtdcMoneyType MShortMarginRatioByVolume
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaInvstMarginRateULField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcRatioType LongMarginRatioByMoney
        TThostFtdcMoneyType LongMarginRatioByVolume
        TThostFtdcRatioType ShortMarginRatioByMoney
        TThostFtdcMoneyType ShortMarginRatioByVolume
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaOptInvstCommRateField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType OpenRatioByMoney
        TThostFtdcRatioType OpenRatioByVolume
        TThostFtdcRatioType CloseRatioByMoney
        TThostFtdcRatioType CloseRatioByVolume
        TThostFtdcRatioType CloseTodayRatioByMoney
        TThostFtdcRatioType CloseTodayRatioByVolume
        TThostFtdcRatioType StrikeRatioByMoney
        TThostFtdcRatioType StrikeRatioByVolume
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaInvstCommRateField:
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcInvestorRangeType InvestorRange
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcRatioType OpenRatioByMoney
        TThostFtdcRatioType OpenRatioByVolume
        TThostFtdcRatioType CloseRatioByMoney
        TThostFtdcRatioType CloseRatioByVolume
        TThostFtdcRatioType CloseTodayRatioByMoney
        TThostFtdcRatioType CloseTodayRatioByVolume
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaProductExchRateField:
        TThostFtdcInstrumentIDType ProductID
        TThostFtdcCurrencyIDType QuoteCurrencyID
        TThostFtdcExchangeRateType ExchangeRate
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaDepthMarketDataField:
        TThostFtdcDateType TradingDay
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcExchangeInstIDType ExchangeInstID
        TThostFtdcPriceType LastPrice
        TThostFtdcPriceType PreSettlementPrice
        TThostFtdcPriceType PreClosePrice
        TThostFtdcLargeVolumeType PreOpenInterest
        TThostFtdcPriceType OpenPrice
        TThostFtdcPriceType HighestPrice
        TThostFtdcPriceType LowestPrice
        TThostFtdcVolumeType Volume
        TThostFtdcMoneyType Turnover
        TThostFtdcLargeVolumeType OpenInterest
        TThostFtdcPriceType ClosePrice
        TThostFtdcPriceType SettlementPrice
        TThostFtdcPriceType UpperLimitPrice
        TThostFtdcPriceType LowerLimitPrice
        TThostFtdcRatioType PreDelta
        TThostFtdcRatioType CurrDelta
        TThostFtdcTimeType UpdateTime
        TThostFtdcMillisecType UpdateMillisec
        TThostFtdcPriceType BidPrice1
        TThostFtdcVolumeType BidVolume1
        TThostFtdcPriceType AskPrice1
        TThostFtdcVolumeType AskVolume1
        TThostFtdcPriceType BidPrice2
        TThostFtdcVolumeType BidVolume2
        TThostFtdcPriceType AskPrice2
        TThostFtdcVolumeType AskVolume2
        TThostFtdcPriceType BidPrice3
        TThostFtdcVolumeType BidVolume3
        TThostFtdcPriceType AskPrice3
        TThostFtdcVolumeType AskVolume3
        TThostFtdcPriceType BidPrice4
        TThostFtdcVolumeType BidVolume4
        TThostFtdcPriceType AskPrice4
        TThostFtdcVolumeType AskVolume4
        TThostFtdcPriceType BidPrice5
        TThostFtdcVolumeType BidVolume5
        TThostFtdcPriceType AskPrice5
        TThostFtdcVolumeType AskVolume5
        TThostFtdcPriceType AveragePrice
        TThostFtdcDateType ActionDay
        TThostFtdcPriceType BandingUpperPrice
        TThostFtdcPriceType BandingLowerPrice
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaIndexPriceField:
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcPriceType ClosePrice
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
    cdef struct CThostFtdcSyncDeltaEWarrantOffsetField:
        TThostFtdcTradeDateType TradingDay
        TThostFtdcBrokerIDType BrokerID
        TThostFtdcInvestorIDType InvestorID
        TThostFtdcExchangeIDType ExchangeID
        TThostFtdcInstrumentIDType InstrumentID
        TThostFtdcDirectionType Direction
        TThostFtdcHedgeFlagType HedgeFlag
        TThostFtdcVolumeType Volume
        TThostFtdcActionDirectionType ActionDirection
        TThostFtdcSequenceNoType SyncDeltaSequenceNo
