from setuptools import setup, find_packages

setup(
    name='drMD',
    version='0.0.3',
    description='drMD: Molecular Dynamics for Protein Scientists',
    author="Dr Eugene Shrimpton-Phoenix",
    author_email="eshrimpt@ed.ac.uk",
    long_description=open('README.md').read(),
    long_description_content_type="text/markdown",
    url="https://github.com/ESPhoenix/drMD",
    packages=find_packages(),
    python_requires='>=3.9',
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: MIT License',
    ],
    install_requires=[
        'pyyaml',
        'argpass',
        'pandas',
        'mdtraj',
        'numpy',
        'matplotlib',
        'weasyprint',
        'scipy',
        'tqdm',
        'pdbutils',
        'scikit-learn',
        'propka',
        'mdanalysis'
    ],
)