/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import main.Pedigree;
import vcf.GT;
import vcf.Marker;
import vcf.Markers;
import vcf.XBasicGT1;

public final class XBasicGT
implements GT {
    private final Samples samples;
    private final Markers markers;
    private final boolean isRefData;
    private final XBasicGT1[] gt1;

    public XBasicGT(GT gT, Pedigree pedigree) {
        if (!gT.samples().equals(pedigree.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        int n = gT.nSamples();
        this.markers = gT.markers();
        this.samples = gT.samples();
        this.isRefData = gT.isPhased();
        this.gt1 = new XBasicGT1[n];
        for (int i = 0; i < n; ++i) {
            int n2 = pedigree.father(i);
            int n3 = pedigree.mother(i);
            this.gt1[i] = new XBasicGT1(gT, i, n2, n3);
        }
    }

    @Override
    public boolean isPhased() {
        return this.isRefData;
    }

    @Override
    public boolean isGTData() {
        return true;
    }

    @Override
    public boolean isPhased(int n) {
        return this.gt1[n].isRefSample();
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        return this.gt1[n2].gl(n, n3, n4);
    }

    @Override
    public boolean isPhased(int n, int n2) {
        return this.gt1[n2].isPhased(n);
    }

    @Override
    public int allele1(int n, int n2) {
        return this.gt1[n2].allele1(n);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.gt1[n2].allele2(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[XBasicGTWindow: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        stringBuilder.append(Const.nl);
        int n = this.nMarkers();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.markers.marker(i));
            stringBuilder.append(Const.nl);
            stringBuilder.append('.');
            stringBuilder.append('\t');
            stringBuilder.append("PASS");
            stringBuilder.append('\t');
            stringBuilder.append('.');
            stringBuilder.append('\t');
            stringBuilder.append("GT");
            for (XBasicGT1 xBasicGT1 : this.gt1) {
                stringBuilder.append('\t');
                stringBuilder.append(xBasicGT1.allele1(i));
                stringBuilder.append(xBasicGT1.isPhased(i) ? (char)'|' : '/');
                stringBuilder.append(xBasicGT1.allele2(i));
            }
        }
        stringBuilder.append(Const.nl);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

