/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import vcf.BasicMarker;
import vcf.BitSetGT;
import vcf.GTRec;
import vcf.Marker;
import vcf.VcfHeader;

public final class VcfRecord
implements GTRec {
    public static final String GL_FORMAT = "GL";
    public static final String PL_FORMAT = "PL";
    private static final int sampleOffset = 9;
    private final VcfHeader vcfHeader;
    private final String vcfRecord;
    private final int[] delimiters;
    private final Marker marker;
    private final String[] formatFields;
    private final Map<String, Integer> formatMap;
    private final GTRec gtEm;
    private final float[] gls;

    public static int gtIndex(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("a1<0: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("a2<0: " + n2);
        }
        if (n < n2) {
            return n2 * (n2 + 1) / 2 + n;
        }
        return n * (n + 1) / 2 + n2;
    }

    private VcfRecord(VcfHeader vcfHeader, String string, boolean bl, boolean bl2, float f) {
        boolean bl3;
        this.vcfHeader = vcfHeader;
        this.vcfRecord = string;
        this.delimiters = VcfRecord.delimiters(vcfHeader, string);
        this.marker = new BasicMarker(string);
        this.formatFields = this.formats(this.format());
        this.formatMap = VcfRecord.formatToIndexMap(vcfHeader, string, this.formatFields);
        boolean bl4 = bl && this.formatMap.containsKey("GT");
        boolean bl5 = bl3 = bl2 && (this.formatMap.containsKey(PL_FORMAT) || this.formatMap.containsKey(GL_FORMAT));
        if (!bl4 && !bl3) {
            String string2 = "Missing required data: " + string;
            throw new IllegalArgumentException(string2);
        }
        this.gtEm = bl4 ? new BitSetGT(vcfHeader, string) : null;
        this.gls = bl3 ? this.likelihoodsFromGL(f) : null;
    }

    public static VcfRecord fromGT(VcfHeader vcfHeader, String string) {
        boolean bl = true;
        boolean bl2 = false;
        float f = Float.NaN;
        return new VcfRecord(vcfHeader, string, bl, bl2, f);
    }

    public static VcfRecord fromGL(VcfHeader vcfHeader, String string, float f) {
        boolean bl = false;
        boolean bl2 = true;
        return new VcfRecord(vcfHeader, string, bl, bl2, f);
    }

    public static VcfRecord fromGTGL(VcfHeader vcfHeader, String string, float f) {
        boolean bl = true;
        boolean bl2 = true;
        return new VcfRecord(vcfHeader, string, bl, bl2, f);
    }

    private static int[] delimiters(VcfHeader vcfHeader, String string) {
        int n = vcfHeader.nHeaderFields();
        int[] nArray = new int[n + 1];
        nArray[0] = -1;
        for (int i = 1; i < n; ++i) {
            nArray[i] = string.indexOf(9, nArray[i - 1] + 1);
            if (nArray[i] != -1) continue;
            VcfRecord.fieldCountError(vcfHeader, string);
        }
        if (string.indexOf(9, nArray[n - 1] + 1) != -1) {
            VcfRecord.fieldCountError(vcfHeader, string);
        }
        nArray[n] = string.length();
        return nArray;
    }

    private static void fieldCountError(VcfHeader vcfHeader, String string) {
        File file = vcfHeader.file();
        Object[] objectArray = StringUtil.getFields(string, '\t');
        String string2 = "File source: " + (file != null ? file : "stdin");
        String string3 = "VCF header line has " + vcfHeader.nHeaderFields() + " fields, but data line has " + objectArray.length + " fields" + Const.nl + "File source:" + string2 + Const.nl + Arrays.toString(objectArray);
        throw new IllegalArgumentException(string3);
    }

    private static boolean isAlphanumeric(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String[] formats(String string) {
        String[] stringArray;
        if (string.equals(".") || string.isEmpty()) {
            String string2 = "missing format field: " + this.vcfRecord;
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : stringArray = StringUtil.getFields(string, ':')) {
            if (!string3.isEmpty()) continue;
            String string4 = "missing format in format subfield list: " + this.vcfRecord;
            throw new IllegalArgumentException(string4);
        }
        return stringArray;
    }

    private static Map<String, Integer> formatToIndexMap(VcfHeader vcfHeader, String string, String[] stringArray) {
        if (vcfHeader.nSamples() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], i);
        }
        if (hashMap.containsKey("GT") && (Integer)hashMap.get("GT") != 0) {
            String string2 = "GT format is not first format: " + string;
            throw new IllegalArgumentException(string2);
        }
        return hashMap;
    }

    private int formatSubfieldEnd(int n) {
        while (n < this.vcfRecord.length()) {
            char c = this.vcfRecord.charAt(n);
            if (c == ':' || c == '\t') {
                return n;
            }
            ++n;
        }
        return n;
    }

    private float[] likelihoodsFromGL(float f) {
        float f2 = 1.0f / f;
        int n = this.marker.nGenotypes();
        String[] stringArray = this.hasFormat(GL_FORMAT) ? this.formatData(GL_FORMAT) : null;
        String[] stringArray2 = this.hasFormat(PL_FORMAT) ? this.formatData(PL_FORMAT) : null;
        double[] dArray = new double[n];
        float[] fArray = new float[this.nSamples() * n];
        int n2 = 0;
        int n3 = this.nSamples();
        for (int i = 0; i < n3; ++i) {
            int n4;
            Arrays.fill(dArray, 0.0);
            if (stringArray != null) {
                String[] stringArray3 = this.getGL(GL_FORMAT, stringArray, i, n);
                for (n4 = 0; n4 < n; ++n4) {
                    dArray[n4] = VcfRecord.GL2Like(stringArray3[n4]);
                }
            } else if (stringArray2 != null) {
                String[] stringArray4 = this.getGL(PL_FORMAT, stringArray2, i, n);
                for (n4 = 0; n4 < n; ++n4) {
                    dArray[n4] = VcfRecord.PL2Like(stringArray4[n4]);
                }
            }
            VcfRecord.rescaleToMax1(dArray);
            for (int j = 0; j < n; ++j) {
                if (dArray[j] >= (double)f2) {
                    fArray[n2] = (float)dArray[j];
                }
                ++n2;
            }
        }
        assert (n2 == fArray.length);
        return fArray;
    }

    private String[] getGL(String string, String[] stringArray, int n, int n2) {
        if (stringArray[n].equals(".")) {
            Object[] objectArray = new String[n2];
            Arrays.fill(objectArray, "0");
            return objectArray;
        }
        String[] stringArray2 = StringUtil.getFields(stringArray[n], ',');
        if (stringArray2.length != n2) {
            String string2 = "unexpected number of " + string + " subfields: " + this.sampleData(n, string) + Const.nl + this.vcfRecord;
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : stringArray2) {
            if (!string3.equals(".")) continue;
            String string4 = "missing subfield in " + string + " field: " + this.sampleData(n, string) + Const.nl + this.vcfRecord;
            throw new IllegalArgumentException(string4);
        }
        return stringArray2;
    }

    private static double GL2Like(String string) {
        return Math.pow(10.0, Double.parseDouble(string));
    }

    private static double PL2Like(String string) {
        return Math.pow(10.0, (double)(-Integer.parseInt(string)) / 10.0);
    }

    private static void rescaleToMax1(double[] dArray) {
        double d = VcfRecord.max(dArray);
        if (d == 0.0) {
            Arrays.fill(dArray, 1.0);
        } else {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
        }
    }

    private static double max(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public String qual() {
        return this.vcfRecord.substring(this.delimiters[5] + 1, this.delimiters[6]);
    }

    public String filter() {
        return this.vcfRecord.substring(this.delimiters[6] + 1, this.delimiters[7]);
    }

    public String info() {
        return this.vcfRecord.substring(this.delimiters[7] + 1, this.delimiters[8]);
    }

    public String format() {
        if (this.delimiters.length > 9) {
            return this.vcfRecord.substring(this.delimiters[8] + 1, this.delimiters[9]);
        }
        return "";
    }

    public int nFormatSubfields() {
        return this.formatFields.length;
    }

    public String formatSubfield(int n) {
        if (this.formatFields == null) {
            throw new IllegalArgumentException("No format exists");
        }
        return this.formatFields[n];
    }

    public boolean hasFormat(String string) {
        return this.formatMap.get(string) != null;
    }

    public int formatIndex(String string) {
        Integer n = this.formatMap.get(string);
        return n == null ? -1 : n;
    }

    public String sampleData(int n) {
        int n2 = this.vcfHeader.unfilteredSampleIndex(n);
        return this.vcfRecord.substring(this.delimiters[n2 + 9] + 1, this.delimiters[n2 + 9 + 1]);
    }

    public String sampleData(int n, String string) {
        Integer n2 = this.formatMap.get(string);
        if (n2 == null) {
            String string2 = "missing format data: " + string;
            throw new IllegalArgumentException(string2);
        }
        return this.sampleData(n, n2);
    }

    public String sampleData(int n, int n2) {
        int n3;
        if (n2 < 0 || n2 >= this.formatFields.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        int n4 = 9 + this.vcfHeader.unfilteredSampleIndex(n);
        int n5 = this.delimiters[n4] + 1;
        for (n3 = 0; n3 < n2; ++n3) {
            int n6 = this.formatSubfieldEnd(n5);
            if (n6 == this.vcfRecord.length() || this.vcfRecord.charAt(n6) == '\t') {
                return ".";
            }
            n5 = n6 + 1;
        }
        n3 = this.formatSubfieldEnd(n5);
        if (n3 == n5) {
            return ".";
        }
        return this.vcfRecord.substring(n5, n3);
    }

    public String[] formatData(String string) {
        Integer n = this.formatMap.get(string);
        if (n == null) {
            String string2 = "missing format data: " + string;
            throw new IllegalArgumentException(string2);
        }
        String[] stringArray = new String[this.vcfHeader.nSamples()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.sampleData(i, n);
        }
        return stringArray;
    }

    @Override
    public Samples samples() {
        return this.vcfHeader.samples();
    }

    @Override
    public int nSamples() {
        return this.vcfHeader.nSamples();
    }

    public VcfHeader vcfHeader() {
        return this.vcfHeader;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int allele1(int n) {
        return this.gtEm == null ? -1 : this.gtEm.allele1(n);
    }

    @Override
    public int allele2(int n) {
        return this.gtEm == null ? -1 : this.gtEm.allele2(n);
    }

    @Override
    public int allele(int n) {
        return this.gtEm == null ? -1 : this.gtEm.allele(n);
    }

    @Override
    public int[] alleles() {
        if (this.gtEm == null) {
            return IntStream.range(0, this.nHaps()).map(n -> -1).toArray();
        }
        return this.gtEm.alleles();
    }

    @Override
    public boolean isPhased(int n) {
        return this.gtEm == null ? false : this.gtEm.isPhased(n);
    }

    @Override
    public boolean isPhased() {
        return this.gtEm == null ? false : this.gtEm.isPhased();
    }

    @Override
    public boolean isGTData() {
        return this.gls == null;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        if (this.gtEm == null || this.gls != null && (this.gtEm.allele1(n) == -1 || this.gtEm.allele2(n) == -1)) {
            int n4 = this.marker.nAlleles();
            if (n2 < 0 || n3 < 0 || n2 >= n4 || n3 >= n4) {
                String string = n2 + " " + n3 + " " + n4;
                throw new ArrayIndexOutOfBoundsException(string);
            }
            int n5 = VcfRecord.gtIndex(n2, n3);
            return this.gls[n * this.marker.nGenotypes() + n5];
        }
        return this.gtEm.gl(n, n2, n3);
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public int nHaps() {
        return 2 * this.vcfHeader.nSamples();
    }

    public String toString() {
        return this.vcfRecord;
    }
}

