/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.GT;
import vcf.Marker;
import vcf.Markers;
import vcf.PhasedGT;

public final class SplicedGT
implements GT {
    private final int overlap;
    private final PhasedGT phasedGT;
    private final GT gt;

    public SplicedGT(PhasedGT phasedGT, GT gT) {
        if (phasedGT.nMarkers() >= gT.nMarkers()) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        int n = phasedGT.nMarkers();
        for (int i = 0; i < n; ++i) {
            if (phasedGT.marker(i).equals(gT.marker(i))) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!phasedGT.samples().equals(gT.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        this.overlap = phasedGT.nMarkers();
        this.phasedGT = phasedGT;
        this.gt = gT;
    }

    @Override
    public boolean isPhased() {
        return this.gt.isPhased();
    }

    @Override
    public boolean isGTData() {
        return this.gt.isGTData();
    }

    @Override
    public boolean isPhased(int n) {
        return this.gt.isPhased(n);
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        if (n < this.overlap) {
            int n5 = this.phasedGT.allele1(n, n2);
            int n6 = this.phasedGT.allele2(n, n2);
            return n3 == n5 && n4 == n6 ? 1.0f : 0.0f;
        }
        return this.gt.gl(n, n2, n3, n4);
    }

    @Override
    public boolean isPhased(int n, int n2) {
        if (n < this.overlap) {
            return true;
        }
        return this.gt.isPhased(n, n2);
    }

    @Override
    public int allele1(int n, int n2) {
        if (n < this.overlap) {
            return this.phasedGT.allele1(n, n2);
        }
        return this.gt.allele1(n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        if (n < this.overlap) {
            return this.phasedGT.allele2(n, n2);
        }
        return this.gt.allele2(n, n2);
    }

    @Override
    public int allele(int n, int n2) {
        if (n < this.overlap) {
            return this.phasedGT.allele(n, n2);
        }
        return this.gt.allele(n, n2);
    }

    @Override
    public Marker marker(int n) {
        return this.gt.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gt.markers();
    }

    @Override
    public int nMarkers() {
        return this.gt.nMarkers();
    }

    @Override
    public int nHaps() {
        return this.gt.nHaps();
    }

    @Override
    public int nSamples() {
        return this.gt.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gt.samples();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("SplicedGL: nSamples=");
        stringBuilder.append(this.nSamples());
        return stringBuilder.toString();
    }
}

