/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.IntArray;
import java.util.stream.IntStream;
import vcf.Marker;
import vcf.RefGTRec;

public class SeqCodedRefGT
implements RefGTRec {
    private final Marker marker;
    private final Samples samples;
    private final IntArray hapToSeq;
    private final IntArray seqToAllele;

    public SeqCodedRefGT(Marker marker, Samples samples, IntArray intArray, IntArray intArray2) {
        if (intArray.size() != 2 * samples.nSamples()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        this.marker = marker;
        this.samples = samples;
        this.hapToSeq = intArray;
        this.seqToAllele = intArray2;
    }

    @Override
    public RefGTRec changeMarker(Marker marker) {
        if (marker.nAlleles() < this.nAlleles()) {
            throw new IllegalArgumentException(marker.toString());
        }
        return new SeqCodedRefGT(marker, this.samples, this.hapToSeq, this.seqToAllele);
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nHaps() {
        return this.hapToSeq.size();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public boolean isGTData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        return true;
    }

    @Override
    public int allele1(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(2 * n));
    }

    @Override
    public int allele2(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(2 * n + 1));
    }

    @Override
    public int allele(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n));
    }

    @Override
    public int[] alleles() {
        return IntStream.range(0, this.hapToSeq.size()).map(n -> this.allele(n)).toArray();
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public IntArray hapToSeq() {
        return this.hapToSeq;
    }

    @Override
    public IntArray seqToAllele() {
        return this.seqToAllele;
    }

    public String toString() {
        return this.toVcfRec();
    }
}

