/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.FileIt;
import blbutil.Filter;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import bref.SeqCoder3;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import vcf.GTRec;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.VcfHeader;
import vcf.VcfRecGTParser;

public class RefIt
implements SampleFileIt<RefGTRec> {
    public static final int MAX_EM_BUFFER_SIZE = 1000;
    private final VcfHeader vcfHeader;
    private final FileIt<String> strIt;
    private final Function<String, RefGTRec> mapper;
    private final Filter<Marker> markerFilter;
    private final Thread fileReaderThread;
    private volatile boolean stopFileReadingThread = false;
    private final BlockingQueue<String[]> stringBuffers;
    private final Deque<RefGTRec> emBuffer;
    private final List<RefGTRec> buffer;
    private final SeqCoder3 seqCoder;

    public static RefIt create(FileIt<String> fileIt) {
        return RefIt.create(fileIt, Filter.acceptAllFilter(), Filter.acceptAllFilter(), 1000);
    }

    public static RefIt create(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, int n) {
        RefIt refIt = new RefIt(fileIt, filter, filter2, n);
        refIt.start();
        return refIt;
    }

    private RefIt(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (filter2 == null) {
            filter2 = Filter.acceptAllFilter();
        }
        this.vcfHeader = new VcfHeader(fileIt, filter);
        this.strIt = fileIt;
        this.mapper = string -> RefGTRec.alleleCodedInstance(new VcfRecGTParser(this.vcfHeader, (String)string));
        this.markerFilter = filter2;
        this.stringBuffers = new ArrayBlockingQueue<String[]>(1);
        this.emBuffer = new ArrayDeque<RefGTRec>(1000);
        this.buffer = new ArrayList<RefGTRec>();
        this.seqCoder = new SeqCoder3(this.vcfHeader.samples());
        this.fileReaderThread = this.fileReadingThread();
    }

    private void start() {
        this.fileReaderThread.setDaemon(true);
        this.fileReaderThread.start();
        this.fillEmissionBuffer();
        if (this.emBuffer.isEmpty()) {
            this.noRecordFoundError(this.strIt);
        }
    }

    private void noRecordFoundError(FileIt<String> fileIt) {
        if (!fileIt.hasNext()) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("No VCF records found (data source: ");
            stringBuilder.append(fileIt.file() == null ? "stdin" : fileIt.file());
            stringBuilder.append(")");
            stringBuilder.append(Const.nl);
            stringBuilder.append("Check that the chromosome identifiers are the same in each input VCF");
            stringBuilder.append(Const.nl);
            stringBuilder.append("file and in the 'chrom=' command line argument (if 'chrom=' is used).");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    private Thread fileReadingThread() {
        Runnable runnable = () -> {
            String string = RefIt.readLine(this.strIt);
            int n = RefIt.stringBufferSize(string);
            while (string != null && !this.stopFileReadingThread) {
                String string2 = RefIt.chromFieldPlusTab(string);
                String[] stringArray = new String[n];
                int n2 = 0;
                while (string != null && n2 < n && string.startsWith(string2)) {
                    stringArray[n2++] = string;
                    string = RefIt.readLine(this.strIt);
                }
                if (n2 < n) {
                    stringArray = Arrays.copyOf(stringArray, n2);
                }
                RefIt.putInBlockingQueue(this.stringBuffers, stringArray);
            }
            if (!this.stopFileReadingThread) {
                RefIt.putInBlockingQueue(this.stringBuffers, new String[0]);
            }
        };
        return new Thread(runnable);
    }

    private static int stringBufferSize(String string) {
        long l;
        if (string == null) {
            return 0;
        }
        long l2 = 2 * string.length();
        Runtime runtime = Runtime.getRuntime();
        long l3 = runtime.maxMemory();
        if (l3 == Long.MAX_VALUE) {
            l3 = 0L;
        }
        if ((l = 1L + l3 / (20L * l2)) > 1000L) {
            l = 1000L;
        }
        return (int)l;
    }

    private static <E> void putInBlockingQueue(BlockingQueue<E> blockingQueue, E e) {
        try {
            blockingQueue.put(e);
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
        }
    }

    private static <E> E takeFromBlockingQueue(BlockingQueue<E> blockingQueue) {
        try {
            return blockingQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
            assert (false);
            return null;
        }
    }

    private static String chromFieldPlusTab(String string) {
        int n = string.indexOf(9);
        if (n == -1) {
            String string2 = Const.nl + "ERROR: Missing tab delimiter in VCV Record:" + Const.nl + string + Const.nl + "Exiting Program";
            Utilities.exit(string2);
        }
        return string.substring(0, n + 1);
    }

    private void fillEmissionBuffer() {
        assert (this.emBuffer.isEmpty());
        int n = -1;
        while (n != 0 && this.emBuffer.size() < 1000) {
            String[] stringArray = RefIt.takeFromBlockingQueue(this.stringBuffers);
            n = stringArray.length;
            if (stringArray.length > 0) {
                List list = ((Stream)Arrays.stream(stringArray).parallel()).map(this.mapper).filter(refGTRec -> this.markerFilter.accept(refGTRec.marker())).collect(Collectors.toList());
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    RefGTRec refGTRec2;
                    if (this.buffer.size() == Integer.MAX_VALUE) {
                        this.flushBuffer();
                    }
                    if (!RefIt.applySeqCoding(refGTRec2 = (RefGTRec)list.get(i))) {
                        this.buffer.add(refGTRec2);
                        continue;
                    }
                    boolean bl = this.seqCoder.add(refGTRec2);
                    if (!bl) {
                        this.flushBuffer();
                        bl = this.seqCoder.add(refGTRec2);
                        assert (bl);
                    }
                    this.buffer.add(null);
                }
                continue;
            }
            RefIt.putInBlockingQueue(this.stringBuffers, stringArray);
        }
        if (n == 0) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() {
        List<RefGTRec> list = this.seqCoder.getCompressedList();
        int n = 0;
        int n2 = this.buffer.size();
        for (int i = 0; i < n2; ++i) {
            GTRec gTRec = this.buffer.get(i);
            if (gTRec != null) continue;
            this.buffer.set(i, list.get(n++));
        }
        this.emBuffer.addAll(this.buffer);
        this.buffer.clear();
    }

    private static String readLine(FileIt<String> fileIt) {
        if (!fileIt.hasNext()) {
            return null;
        }
        String string = (String)fileIt.next();
        while (string.trim().isEmpty() && fileIt.hasNext()) {
            string = (String)fileIt.next();
        }
        return string;
    }

    @Override
    public void close() {
        this.stopFileReadingThread = true;
        this.stringBuffers.poll();
        try {
            this.fileReaderThread.join();
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
        }
        this.strIt.close();
        this.emBuffer.clear();
    }

    @Override
    public boolean hasNext() {
        return !this.emBuffer.isEmpty();
    }

    @Override
    public RefGTRec next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        RefGTRec refGTRec = this.emBuffer.removeFirst();
        if (this.emBuffer.isEmpty()) {
            this.fillEmissionBuffer();
        }
        return refGTRec;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    @Override
    public File file() {
        return this.strIt.file();
    }

    @Override
    public Samples samples() {
        return this.vcfHeader.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("RefVcfIt from file: ");
        stringBuilder.append(this.strIt.file() == null ? "stdin" : this.strIt.file().toString());
        return stringBuilder.toString();
    }

    public static RefGTRec recodeIfLowFreq(RefGTRec refGTRec) {
        int n = 2 * refGTRec.nSamples();
        int[] nArray = RefIt.alleleCounts(refGTRec);
        int n2 = RefIt.max(nArray);
        if (0.995f < (1.0f + (float)n2) / (float)n) {
            int[][] nArray2 = RefIt.hapIndices(refGTRec, nArray);
            return RefGTRec.alleleCodedInstance(refGTRec.marker(), refGTRec.samples(), nArray2);
        }
        return refGTRec;
    }

    private static int[][] hapIndices(GTRec gTRec, int[] nArray) {
        int n = RefIt.majorAllele(nArray);
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = i == n ? null : new int[nArray[i]];
        }
        int[] nArray2 = new int[nArray.length];
        int n2 = gTRec.nHaps();
        for (int i = 0; i < n2; ++i) {
            int n3 = gTRec.allele(i);
            if (n3 == n) continue;
            int n4 = n3;
            int n5 = nArray2[n4];
            nArray2[n4] = n5 + 1;
            nArrayArray[n3][n5] = i;
        }
        return nArrayArray;
    }

    private static int majorAllele(int[] nArray) {
        int n = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[n]) continue;
            n = i;
        }
        return n;
    }

    private static int max(int[] nArray) {
        int n = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[n]) continue;
            n = i;
        }
        return nArray[n];
    }

    private static int[] alleleCounts(GTRec gTRec) {
        int[] nArray = new int[gTRec.marker().nAlleles()];
        int n = gTRec.nHaps();
        for (int i = 0; i < n; ++i) {
            int n2 = gTRec.allele(i);
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    private static boolean applySeqCoding(RefGTRec refGTRec) {
        assert (refGTRec.isAlleleCoded());
        if (refGTRec.marker().nAlleles() > 255) {
            return false;
        }
        int n = refGTRec.nHaps();
        int n2 = refGTRec.majorAllele();
        int n3 = n;
        int n4 = refGTRec.nAlleles();
        for (int i = 0; i < n4; ++i) {
            if (i == n2) continue;
            n3 -= refGTRec.alleleCount(i);
        }
        return 0.995f >= (1.0f + (float)n3) / (float)n;
    }
}

