/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.IntArray;
import java.util.Arrays;
import vcf.GTRec;
import vcf.LowMafRefDiallelicGT;
import vcf.LowMafRefGT;
import vcf.Marker;
import vcf.VcfRecGTParser;

public interface RefGTRec
extends GTRec {
    public static RefGTRec alleleCodedInstance(RefGTRec refGTRec) {
        if (refGTRec.isAlleleCoded()) {
            return refGTRec;
        }
        if (refGTRec.marker().nAlleles() == 2) {
            return new LowMafRefDiallelicGT(refGTRec);
        }
        return new LowMafRefGT(refGTRec);
    }

    public static RefGTRec alleleCodedInstance(VcfRecGTParser vcfRecGTParser) {
        if (vcfRecGTParser.nAlleles() <= 2) {
            return new LowMafRefDiallelicGT(vcfRecGTParser);
        }
        return new LowMafRefGT(vcfRecGTParser);
    }

    public static RefGTRec alleleCodedInstance(Marker marker, Samples samples, int[][] nArray) {
        if (marker.nAlleles() == 2) {
            return new LowMafRefDiallelicGT(marker, samples, nArray);
        }
        return new LowMafRefGT(marker, samples, nArray);
    }

    public static int[][] hapIndices(RefGTRec refGTRec) {
        int n;
        int n2;
        int[] nArray = new int[refGTRec.marker().nAlleles()];
        int n3 = refGTRec.nHaps();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = refGTRec.allele(n2);
            nArray[n4] = nArray[n4] + 1;
        }
        n2 = 0;
        for (n3 = 1; n3 < nArray.length; ++n3) {
            if (nArray[n3] <= nArray[n2]) continue;
            n2 = n3;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (n = 0; n < nArray.length; ++n) {
            if (n == n2) continue;
            nArrayArray[n] = new int[nArray[n]];
        }
        Arrays.fill(nArray, 0);
        int n5 = refGTRec.nHaps();
        for (n = 0; n < n5; ++n) {
            int n6 = refGTRec.allele(n);
            if (n6 == n2) continue;
            int n7 = n6;
            int n8 = nArray[n7];
            nArray[n7] = n8 + 1;
            nArrayArray[n6][n8] = n;
        }
        return nArrayArray;
    }

    @Override
    default public boolean isPhased(int n) {
        if (n < 0 || n >= this.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    default public boolean isPhased() {
        return true;
    }

    public RefGTRec changeMarker(Marker var1);

    default public boolean isAlleleCoded() {
        return false;
    }

    default public int majorAllele() {
        throw new UnsupportedOperationException();
    }

    default public int alleleCount(int n) {
        throw new UnsupportedOperationException();
    }

    default public int hapIndex(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    default public boolean isCarrier(int n, int n2) {
        return this.allele(n2) == n;
    }

    default public IntArray hapToSeq() {
        throw new UnsupportedOperationException();
    }

    default public IntArray seqToAllele() {
        throw new UnsupportedOperationException();
    }
}

