/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.GT;
import vcf.Marker;
import vcf.Markers;
import vcf.PhasedGT;

public class PhasedGTWrapper
implements PhasedGT {
    private final GT gl;

    public PhasedGTWrapper(GT gT) {
        if (!gT.isPhased()) {
            throw new IllegalArgumentException("gl.isRefData()==false");
        }
        this.gl = gT;
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public int allele1(int n, int n2) {
        return this.gl.allele1(n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.gl.allele2(n, n2);
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.gl.markers();
    }

    @Override
    public Marker marker(int n) {
        return this.gl.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.gl.nSamples();
    }
}

