/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.LowMafRefGT;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.VcfRecGTParser;

public final class LowMafRefDiallelicGT
implements RefGTRec {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int majorAllele;
    private final int minorAllele;
    private final int[] minorAlleles;

    public LowMafRefDiallelicGT(RefGTRec refGTRec) {
        if (refGTRec.marker().nAlleles() != 2) {
            throw new IllegalArgumentException(String.valueOf(refGTRec.marker().nAlleles() != 2));
        }
        int[][] nArray = RefGTRec.hapIndices(refGTRec);
        int n = 0;
        while (nArray[n] != null) {
            ++n;
        }
        this.marker = refGTRec.marker();
        this.samples = refGTRec.samples();
        this.nHaps = refGTRec.nHaps();
        this.majorAllele = n;
        this.minorAllele = 1 - n;
        this.minorAlleles = nArray[this.minorAllele];
    }

    public LowMafRefDiallelicGT(VcfRecGTParser vcfRecGTParser) {
        if (vcfRecGTParser.nAlleles() != 2) {
            throw new IllegalArgumentException(String.valueOf(vcfRecGTParser.nAlleles()));
        }
        int[][] nArray = vcfRecGTParser.nonMajRefIndices();
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        this.nHaps = 2 * vcfRecGTParser.nSamples();
        this.majorAllele = nArray[0] == null ? 0 : 1;
        this.minorAllele = 1 - this.majorAllele;
        this.minorAlleles = nArray[this.minorAllele];
    }

    public LowMafRefDiallelicGT(Marker marker, Samples samples, int[][] nArray) {
        if (marker.nAlleles() != 2) {
            throw new IllegalArgumentException(String.valueOf(marker.nAlleles()));
        }
        this.marker = marker;
        this.samples = samples;
        this.nHaps = 2 * samples.nSamples();
        this.majorAllele = LowMafRefGT.checkIndicesAndReturnMajorAllele(nArray, this.nHaps);
        this.minorAllele = 1 - this.majorAllele;
        this.minorAlleles = (int[])nArray[this.minorAllele].clone();
    }

    @Override
    public RefGTRec changeMarker(Marker marker) {
        if (marker.nAlleles() < this.nAlleles()) {
            throw new IllegalArgumentException(marker.toString());
        }
        int[][] nArrayArray = new int[2][];
        nArrayArray[this.minorAllele] = this.minorAlleles;
        if (marker.nAlleles() == 2) {
            return new LowMafRefDiallelicGT(marker, this.samples, nArrayArray);
        }
        return new LowMafRefGT(marker, this.samples, nArrayArray);
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public int nHaps() {
        return this.nHaps;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public boolean isGTData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        if (n2 != 0 && n2 != 1) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (n3 != 0 && n3 != 1) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        if (n >= this.samples.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public int allele1(int n) {
        return this.allele(2 * n);
    }

    @Override
    public int allele2(int n) {
        return this.allele(2 * n + 1);
    }

    @Override
    public int allele(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (Arrays.binarySearch(this.minorAlleles, n) >= 0) {
            return this.minorAllele;
        }
        return this.majorAllele;
    }

    @Override
    public int[] alleles() {
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int n2 : this.minorAlleles) {
            nArray[n2] = this.minorAllele;
        }
        return nArray;
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public boolean isAlleleCoded() {
        return true;
    }

    @Override
    public int majorAllele() {
        return this.majorAllele;
    }

    @Override
    public int alleleCount(int n) {
        if (n == this.majorAllele) {
            throw new IllegalArgumentException("major allele");
        }
        return this.minorAlleles.length;
    }

    @Override
    public int hapIndex(int n, int n2) {
        if (n == this.majorAllele) {
            throw new IllegalArgumentException("major allele");
        }
        return this.minorAlleles[n2];
    }

    @Override
    public boolean isCarrier(int n, int n2) {
        int n3 = Arrays.binarySearch(this.minorAlleles, n2);
        if (n == this.majorAllele) {
            return n3 < 0;
        }
        return n3 >= 0;
    }

    public String toString() {
        return this.toVcfRec();
    }
}

