/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.Const;
import blbutil.SampleFileIt;
import java.io.File;
import java.util.NoSuchElementException;
import vcf.Marker;
import vcf.MarkerContainer;

public final class IntervalVcfIt<E extends MarkerContainer>
implements SampleFileIt<E> {
    private final SampleFileIt<E> it;
    private final ChromInterval interval;
    private E next;

    public IntervalVcfIt(SampleFileIt<E> sampleFileIt, ChromInterval chromInterval) {
        E e = this.readFirstRecord(sampleFileIt, chromInterval);
        if (e == null) {
            String string = "No VCF records found in specified interval." + Const.nl + "Check chromosome identifier [" + chromInterval.chrom() + "] and interval [" + chromInterval.start() + "-" + chromInterval.end() + "]";
            throw new IllegalArgumentException(string);
        }
        this.it = sampleFileIt;
        this.interval = chromInterval;
        this.next = e;
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public Samples samples() {
        return this.it.samples();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = this.next;
        this.next = this.readNextRecord(this.it, this.interval);
        return e;
    }

    private E readFirstRecord(SampleFileIt<E> sampleFileIt, ChromInterval chromInterval) {
        MarkerContainer markerContainer = null;
        while (markerContainer == null && sampleFileIt.hasNext()) {
            MarkerContainer markerContainer2 = (MarkerContainer)sampleFileIt.next();
            if (!IntervalVcfIt.inInterval(chromInterval, markerContainer2.marker())) continue;
            markerContainer = markerContainer2;
        }
        return (E)markerContainer;
    }

    private E readNextRecord(SampleFileIt<E> sampleFileIt, ChromInterval chromInterval) {
        MarkerContainer markerContainer;
        MarkerContainer markerContainer2 = null;
        if (sampleFileIt.hasNext() && IntervalVcfIt.inInterval(chromInterval, (markerContainer = (MarkerContainer)sampleFileIt.next()).marker())) {
            markerContainer2 = markerContainer;
        }
        return (E)markerContainer2;
    }

    private static boolean inInterval(ChromInterval chromInterval, Marker marker) {
        return marker.chromIndex() == chromInterval.chromIndex() && chromInterval.start() <= marker.pos() && marker.pos() <= chromInterval.end();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    @Override
    public void close() {
        this.it.close();
    }
}

